/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.stats;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.Arrays;
import org.locationtech.geomesa.utils.stats.BinnedArray;
import org.locationtech.geomesa.utils.stats.BinnedArray$;
import org.locationtech.geomesa.utils.stats.Histogram$;
import org.locationtech.geomesa.utils.stats.MinMax;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.Stat$class;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Map;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tmc\u0001B\u0001\u0003\u00015\u0011\u0011\u0002S5ti><'/Y7\u000b\u0005\r!\u0011!B:uCR\u001c(BA\u0003\u0007\u0003\u0015)H/\u001b7t\u0015\t9\u0001\"A\u0004hK>lWm]1\u000b\u0005%Q\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0016\u00059Q5\u0003\u0002\u0001\u0010+e\u0001\"\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\u0011a!\u00118z%\u00164\u0007C\u0001\f\u0018\u001b\u0005\u0011\u0011B\u0001\r\u0003\u0005\u0011\u0019F/\u0019;\u0011\u0005i\tS\"A\u000e\u000b\u0005qi\u0012\u0001D:dC2\fGn\\4hS:<'B\u0001\u0010 \u0003!!\u0018\u0010]3tC\u001a,'\"\u0001\u0011\u0002\u0007\r|W.\u0003\u0002#7\tYA*\u0019>z\u0019><w-\u001b8h\u0011!!\u0003A!b\u0001\n\u0003)\u0013aA:giV\ta\u0005\u0005\u0002(]5\t\u0001F\u0003\u0002*U\u000511/[7qY\u0016T!a\u000b\u0017\u0002\u000f\u0019,\u0017\r^;sK*\u0011QFC\u0001\b_B,gnZ5t\u0013\ty\u0003FA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016D\u0001\"\r\u0001\u0003\u0002\u0003\u0006IAJ\u0001\u0005g\u001a$\b\u0005\u0003\u00054\u0001\t\u0015\r\u0011\"\u00015\u0003!\u0001(o\u001c9feRLX#A\u001b\u0011\u0005YJdB\u0001\t8\u0013\tA\u0014#\u0001\u0004Qe\u0016$WMZ\u0005\u0003um\u0012aa\u0015;sS:<'B\u0001\u001d\u0012\u0011!i\u0004A!A!\u0002\u0013)\u0014!\u00039s_B,'\u000f^=!\u0011!y\u0004A!A!\u0002\u0013\u0001\u0015aC5oSRL\u0017\r\u001c\"j]N\u0004\"\u0001E!\n\u0005\t\u000b\"aA%oi\"AA\t\u0001B\u0001B\u0003%Q)\u0001\tj]&$\u0018.\u00197F]\u0012\u0004x.\u001b8ugB!\u0001C\u0012%I\u0013\t9\u0015C\u0001\u0004UkBdWM\r\t\u0003\u0013*c\u0001\u0001B\u0003L\u0001\t\u0007AJA\u0001U#\ti\u0005\u000b\u0005\u0002\u0011\u001d&\u0011q*\u0005\u0002\b\u001d>$\b.\u001b8h!\t\u0001\u0012+\u0003\u0002S#\t\u0019\u0011I\\=\t\u0011Q\u0003!Q1A\u0005\u0004U\u000b\u0001\u0002Z3gCVdGo]\u000b\u0002-B\u0019qK\u0017%\u000f\u0005YA\u0016BA-\u0003\u0003\u0019i\u0015N\\'bq&\u00111\f\u0018\u0002\u000f\u001b&tW*\u0019=EK\u001a\fW\u000f\u001c;t\u0015\tI&\u0001\u0003\u0005_\u0001\t\u0005\t\u0015!\u0003W\u0003%!WMZ1vYR\u001c\b\u0005\u0003\u0005a\u0001\t\u0015\r\u0011b\u0001b\u0003\t\u0019G/F\u0001c!\r\u0019g\rS\u0007\u0002I*\u0011Q-E\u0001\be\u00164G.Z2u\u0013\t9GM\u0001\u0005DY\u0006\u001c8\u000fV1h\u0011!I\u0007A!A!\u0002\u0013\u0011\u0017aA2uA!)1\u000e\u0001C\u0001Y\u00061A(\u001b8jiz\"R!\\9sgR$2A\\8q!\r1\u0002\u0001\u0013\u0005\u0006)*\u0004\u001dA\u0016\u0005\u0006A*\u0004\u001dA\u0019\u0005\u0006I)\u0004\rA\n\u0005\u0006g)\u0004\r!\u000e\u0005\u0006\u007f)\u0004\r\u0001\u0011\u0005\u0006\t*\u0004\r!R\u0003\u0005m\u0002\u0001cNA\u0001T\u0011!A\b\u0001#b\u0001\n\u0003I\u0018!C1uiJL'-\u001e;f+\u0005\u0001\u0005\u0006B<|}~\u0004\"\u0001\u0005?\n\u0005u\f\"A\u00033faJ,7-\u0019;fI\u0006\n1'\r\u0005$k\u0005\u0005\u0011\u0011BA\u0002\u0013\u0011\t\u0019!!\u0002\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0015\r\t9!E\u0001\u000bI\u0016\u0004(/Z2bi\u0016$\u0017'C\u0012\u0002\f\u00055\u0011qBA\u0004\u001d\r\u0001\u0012QB\u0005\u0004\u0003\u000f\t\u0012'\u0002\u0012\u0011#\u0005E!!B:dC2\f\u0007\"CA\u000b\u0001!\u0005\t\u0015)\u0003A\u0003)\tG\u000f\u001e:jEV$X\r\t\u0005\t\u00033\u0001!\u0019!C\u0005s\u0006\t\u0011\u000eC\u0004\u0002\u001e\u0001\u0001\u000b\u0011\u0002!\u0002\u0005%\u0004\u0003BCA\u0011\u0001\u0001\u0007I\u0011\u0001\u0002\u0002$\u0005!!-\u001b8t+\t\t)\u0003\u0005\u0003\u0017\u0003OA\u0015bAA\u0015\u0005\tY!)\u001b8oK\u0012\f%O]1z\u0011)\ti\u0003\u0001a\u0001\n\u0003\u0011\u0011qF\u0001\tE&t7o\u0018\u0013fcR!\u0011\u0011GA\u001c!\r\u0001\u00121G\u0005\u0004\u0003k\t\"\u0001B+oSRD!\"!\u000f\u0002,\u0005\u0005\t\u0019AA\u0013\u0003\rAH%\r\u0005\t\u0003{\u0001\u0001\u0015)\u0003\u0002&\u0005)!-\u001b8tA!1\u0011\u0011\t\u0001\u0005\u0002e\fa\u0001\\3oORD\u0007bBA#\u0001\u0011\u0005\u0011qI\u0001\fI&\u0014Xm\u0019;J]\u0012,\u0007\u0010F\u0002A\u0003\u0013B\u0001\"a\u0013\u0002D\u0001\u0007\u0011QJ\u0001\u0006m\u0006dW/\u001a\t\u0004!\u0005=\u0013bAA)#\t!Aj\u001c8h\u0011\u001d\t)\u0006\u0001C\u0001\u0003/\nq!\u001b8eKb|e\rF\u0002A\u00033Bq!a\u0013\u0002T\u0001\u0007\u0001\nC\u0004\u0002^\u0001!\t!a\u0018\u0002\u000b\r|WO\u001c;\u0015\t\u00055\u0013\u0011\r\u0005\b\u00033\tY\u00061\u0001A\u0011\u001d\t)\u0007\u0001C\u0001\u0003O\n1!\\5o+\u0005A\u0005bBA6\u0001\u0011\u0005\u0011qM\u0001\u0004[\u0006D\bbBA8\u0001\u0011\u0005\u0011\u0011O\u0001\u0007E>,h\u000eZ:\u0016\u0003\u0015Cq!a\u001c\u0001\t\u0003\t)\bF\u0002F\u0003oBq!!\u0007\u0002t\u0001\u0007\u0001\tC\u0004\u0002|\u0001!\t!! \u0002\u00175,G-[1o-\u0006dW/\u001a\u000b\u0004\u0011\u0006}\u0004bBA\r\u0003s\u0002\r\u0001\u0011\u0005\b\u0003\u0007\u0003A\u0011AAC\u00035\tG\rZ\"pk:$8O\u0012:p[R!\u0011\u0011GAD\u0011\u001d\tI)!!A\u00029\fQa\u001c;iKJDq!!$\u0001\t\u0003\ny)A\u0004pEN,'O^3\u0015\t\u0005E\u0012\u0011\u0013\u0005\t\u0003'\u000bY\t1\u0001\u0002\u0016\u0006\u00111O\u001a\t\u0004O\u0005]\u0015bAAMQ\ti1+[7qY\u00164U-\u0019;ve\u0016Dq!!(\u0001\t\u0003\ny*A\u0005v]>\u00147/\u001a:wKR!\u0011\u0011GAQ\u0011!\t\u0019*a'A\u0002\u0005U\u0005bBAS\u0001\u0011\u0005\u0013qU\u0001\u0006IAdWo\u001d\u000b\u0004]\u0006%\u0006bBAE\u0003G\u0003\rA\u001c\u0005\b\u0003[\u0003A\u0011IAX\u0003!!\u0003\u000f\\;tI\u0015\fH\u0003BA\u0019\u0003cCq!!#\u0002,\u0002\u0007a\u000eC\u0004\u00026\u0002!\t%a.\u0002\u0019Q|'j]8o\u001f\nTWm\u0019;\u0016\u0005\u0005e\u0006#\u0002\u001c\u0002<V\u0002\u0016bAA_w\t\u0019Q*\u00199\t\u000f\u0005\u0005\u0007\u0001\"\u0011\u0002D\u00069\u0011n]#naRLXCAAc!\r\u0001\u0012qY\u0005\u0004\u0003\u0013\f\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u001b\u0004A\u0011IAh\u0003\u0015\u0019G.Z1s)\t\t\t\u0004C\u0004\u0002T\u0002!\t%!6\u0002\u0019%\u001cX)];jm\u0006dWM\u001c;\u0015\t\u0005\u0015\u0017q\u001b\u0005\b\u0003\u0013\u000b\t\u000e1\u0001\u0016\u000f\u001d\tYN\u0001E\u0001\u0003;\f\u0011\u0002S5ti><'/Y7\u0011\u0007Y\tyN\u0002\u0004\u0002\u0005!\u0005\u0011\u0011]\n\u0004\u0003?|\u0001bB6\u0002`\u0012\u0005\u0011Q\u001d\u000b\u0003\u0003;D\u0001\"!;\u0002`\u0012\u0005\u00111^\u0001\u0007EV4g-\u001a:\u0016\t\u00055\u00181\u001f\u000b\u0005\u0003_\f)\u0010\u0005\u0004\u0011\r\u0006E\u0018\u0011\u001f\t\u0004\u0013\u0006MHAB&\u0002h\n\u0007A\n\u0003\u0005\u0002L\u0005\u001d\b\u0019AAy\u0011!\tI0a8\u0005\u0002\u0005m\u0018AC3ya\u0006tGMQ5ogV!\u0011Q B\u0003)\u0019\tyPa\u0004\u0003\u0012Q1!\u0011\u0001B\u0004\u0005\u0017\u0001RAFA\u0014\u0005\u0007\u00012!\u0013B\u0003\t\u0019Y\u0015q\u001fb\u0001\u0019\"9A+a>A\u0004\t%\u0001\u0003B,[\u0005\u0007Aq\u0001YA|\u0001\b\u0011i\u0001\u0005\u0003dM\n\r\u0001\u0002CA&\u0003o\u0004\rAa\u0001\t\u0011\tM\u0011q\u001fa\u0001\u0005\u0003\t1a\u001c7e\u0011!\u00119\"a8\u0005\u0002\te\u0011AD2iK\u000e\\WI\u001c3q_&tGo]\u000b\u0005\u00057\u0011\u0019\u0003\u0006\u0004\u0003\u001e\t%\"q\u0006\u000b\u0005\u0005?\u0011)\u0003\u0005\u0004\u0011\r\n\u0005\"\u0011\u0005\t\u0004\u0013\n\rBAB&\u0003\u0016\t\u0007A\nC\u0004U\u0005+\u0001\u001dAa\n\u0011\t]S&\u0011\u0005\u0005\t\u0005W\u0011)\u00021\u0001\u0003.\u0005!A.\u001a4u!\u00151\u0012q\u0005B\u0011\u0011!\u0011\tD!\u0006A\u0002\t5\u0012!\u0002:jO\"$\b\u0002\u0003B\u001b\u0003?$IAa\u000e\u0002\u001f\u001d,G/Q2uk\u0006d'i\\;oIN,BA!\u000f\u0003@Q!!1\bB!!\u0019\u0001bI!\u0010\u0003>A\u0019\u0011Ja\u0010\u0005\r-\u0013\u0019D1\u0001M\u0011!\t\tCa\rA\u0002\t\r\u0003#\u0002\f\u0002(\tu\u0002\u0002\u0003B$\u0003?$\tA!\u0013\u0002\u0011\r|\u0007/_%oi>,BAa\u0013\u0003VQ1\u0011\u0011\u0007B'\u0005/B\u0001Ba\u0014\u0003F\u0001\u0007!\u0011K\u0001\u0003i>\u0004RAFA\u0014\u0005'\u00022!\u0013B+\t\u0019Y%Q\tb\u0001\u0019\"A!\u0011\fB#\u0001\u0004\u0011\t&\u0001\u0003ge>l\u0007")
public class Histogram<T>
implements Stat,
LazyLogging {
    private final SimpleFeatureType sft;
    private final String property;
    private final MinMax.MinMaxDefaults<T> defaults;
    private final ClassTag<T> ct;
    private int attribute;
    private final int i;
    private BinnedArray<T> bins;
    private final Logger logger;
    private volatile byte bitmap$0;

    public static <T> void copyInto(BinnedArray<T> binnedArray, BinnedArray<T> binnedArray2) {
        Histogram$.MODULE$.copyInto(binnedArray, binnedArray2);
    }

    public static <T> Tuple2<T, T> checkEndpoints(BinnedArray<T> binnedArray, BinnedArray<T> binnedArray2, MinMax.MinMaxDefaults<T> minMaxDefaults) {
        return Histogram$.MODULE$.checkEndpoints(binnedArray, binnedArray2, minMaxDefaults);
    }

    public static <T> BinnedArray<T> expandBins(T t, BinnedArray<T> binnedArray, MinMax.MinMaxDefaults<T> minMaxDefaults, ClassTag<T> classTag) {
        return Histogram$.MODULE$.expandBins(t, binnedArray, minMaxDefaults, classTag);
    }

    public static <T> Tuple2<T, T> buffer(T t) {
        return Histogram$.MODULE$.buffer(t);
    }

    private int attribute$lzycompute() {
        Histogram histogram2 = this;
        synchronized (histogram2) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.attribute = this.i();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.attribute;
        }
    }

    private Logger logger$lzycompute() {
        Histogram histogram2 = this;
        synchronized (histogram2) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public void $plus$eq(Stat other, Predef.DummyImplicit d) {
        Stat$class.$plus$eq(this, other, d);
    }

    @Override
    public Stat $plus(Stat other, Predef.DummyImplicit d) {
        return Stat$class.$plus(this, other, d);
    }

    @Override
    public String toJson() {
        return Stat$class.toJson(this);
    }

    @Override
    public SimpleFeatureType sft() {
        return this.sft;
    }

    public String property() {
        return this.property;
    }

    public MinMax.MinMaxDefaults<T> defaults() {
        return this.defaults;
    }

    public ClassTag<T> ct() {
        return this.ct;
    }

    public int attribute() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.attribute$lzycompute() : this.attribute;
    }

    private int i() {
        return this.i;
    }

    public BinnedArray<T> bins() {
        return this.bins;
    }

    public void bins_$eq(BinnedArray<T> x$1) {
        this.bins = x$1;
    }

    public int length() {
        return this.bins().length();
    }

    public int directIndex(long value2) {
        return this.bins().directIndex(value2);
    }

    public int indexOf(T value2) {
        return this.bins().indexOf(value2);
    }

    public long count(int i) {
        return this.bins().counts()[i];
    }

    public T min() {
        return (T)this.bins().bounds()._1();
    }

    public T max() {
        return (T)this.bins().bounds()._2();
    }

    public Tuple2<T, T> bounds() {
        return this.bins().bounds();
    }

    public Tuple2<T, T> bounds(int i) {
        return this.bins().bounds(i);
    }

    public T medianValue(int i) {
        return this.bins().medianValue(i);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addCountsFrom(Histogram<T> other) {
        if (this.length() == other.length()) {
            Tuple2<T, T> tuple2 = this.bounds();
            Tuple2<T, T> tuple22 = other.bounds();
            if (!(tuple2 != null ? !tuple2.equals(tuple22) : tuple22 != null)) {
                this.$plus$eq(other);
                return;
            }
        }
        Histogram$.MODULE$.copyInto(this.bins(), other.bins());
    }

    @Override
    public void observe(SimpleFeature sf) {
        Object value2 = sf.getAttribute(this.i());
        if (value2 != null) {
            try {
                int i = this.bins().indexOf(value2);
                if (i == -1) {
                    this.bins_$eq(Histogram$.MODULE$.expandBins(value2, this.bins(), this.defaults(), this.ct()));
                    BinnedArray<Object> qual$1 = this.bins();
                    Object x$7 = value2;
                    long x$8 = qual$1.add$default$2();
                    qual$1.add(x$7, x$8);
                } else {
                    long[] lArray = this.bins().counts();
                    lArray[i] = lArray[i] + 1L;
                }
            }
            catch (Exception exception) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Error observing value '{}': {}", new Object[]{value2, exception.toString()});
                    boxedUnit = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public void unobserve(SimpleFeature sf) {
        Object value2 = sf.getAttribute(this.i());
        if (value2 != null) {
            try {
                int i = this.bins().indexOf(value2);
                if (i == -1) {
                    this.bins_$eq(Histogram$.MODULE$.expandBins(value2, this.bins(), this.defaults(), this.ct()));
                    this.bins().add(value2, -1L);
                } else {
                    long[] lArray = this.bins().counts();
                    lArray[i] = lArray[i] - 1L;
                }
            }
            catch (Exception exception) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Error un-observing value '{}': {}", new Object[]{value2, exception.toString()});
                    boxedUnit = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Histogram<T> $plus(Histogram<T> other) {
        void var2_2;
        Histogram<T> plus2 = new Histogram<T>(this.sft(), this.property(), this.length(), this.bounds(), this.defaults(), this.ct());
        plus2.$plus$eq(this);
        plus2.$plus$eq(other);
        return var2_2;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public void $plus$eq(Histogram<T> other) {
        if (this.length() == other.length()) {
            Tuple2<T, T> tuple2 = this.bounds();
            Tuple2<T, T> tuple22 = other.bounds();
            if (!(tuple2 != null ? !tuple2.equals(tuple22) : tuple22 != null)) {
                int i = 0;
                while (i < this.bins().length()) {
                    long[] lArray = this.bins().counts();
                    int n = i;
                    lArray[n] = lArray[n] + other.bins().counts()[i];
                    ++i;
                }
                return;
            }
        }
        if (other.isEmpty()) return;
        if (this.isEmpty()) {
            this.bins_$eq(BinnedArray$.MODULE$.apply(other.length(), other.bounds(), this.ct()));
            int i = 0;
            while (i < this.bins().length()) {
                this.bins().counts()[i] = other.bins().counts()[i];
                ++i;
            }
            return;
        }
        Tuple2<T, T> newEndpoints = Histogram$.MODULE$.checkEndpoints(this.bins(), other.bins(), this.defaults());
        int newLength = package$.MODULE$.max(this.length(), other.length());
        Tuple2<T, T> tuple2 = newEndpoints;
        Tuple2<T, T> tuple23 = this.bounds();
        if ((tuple2 != null ? !tuple2.equals(tuple23) : tuple23 != null) || newLength != this.length()) {
            BinnedArray<T> newBins = BinnedArray$.MODULE$.apply(newLength, newEndpoints, this.ct());
            Histogram$.MODULE$.copyInto(newBins, this.bins());
            this.bins_$eq(newBins);
        }
        Histogram$.MODULE$.copyInto(this.bins(), other.bins());
    }

    public Map<String, Object> toJsonObject() {
        Seq binSeq = (Seq)Seq$.MODULE$.tabulate(this.bins().length(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Histogram $outer;

            public final ListMap<String, Object> apply(int bin) {
                return (ListMap)ListMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index"), (Object)BoxesRunTime.boxToInteger((int)bin)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lower-bound"), this.$outer.bounds(bin)._1()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"upper-bound"), this.$outer.bounds(bin)._2()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"count"), (Object)BoxesRunTime.boxToLong((long)this.$outer.bins().counts()[bin]))}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return (Map)ListMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lower-bound"), this.bounds()._1()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"upper-bound"), this.bounds()._2()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bins"), (Object)binSeq)}));
    }

    @Override
    public boolean isEmpty() {
        return Predef$.MODULE$.longArrayOps(this.bins().counts()).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long x$1) {
                return this.apply$mcZJ$sp(x$1);
            }

            public boolean apply$mcZJ$sp(long x$1) {
                return x$1 == 0L;
            }
        });
    }

    @Override
    public void clear() {
        this.bins().clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEquivalent(Stat other) {
        Stat stat2 = other;
        if (!(stat2 instanceof Histogram)) return false;
        Histogram histogram2 = (Histogram)stat2;
        String string2 = this.property();
        String string3 = histogram2.property();
        if (string2 == null) {
            if (string3 != null) {
                return false;
            }
        } else if (!string2.equals(string3)) return false;
        Tuple2<T, T> tuple2 = this.bounds();
        Tuple2<T, T> tuple22 = histogram2.bounds();
        if (tuple2 == null) {
            if (tuple22 != null) {
                return false;
            }
        } else if (!tuple2.equals(tuple22)) return false;
        if (!Arrays.equals(this.bins().counts(), histogram2.bins().counts())) return false;
        return true;
    }

    public Histogram(SimpleFeatureType sft, String property, int initialBins, Tuple2<T, T> initialEndpoints, MinMax.MinMaxDefaults<T> defaults, ClassTag<T> ct) {
        this.sft = sft;
        this.property = property;
        this.defaults = defaults;
        this.ct = ct;
        Stat$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        this.i = sft.indexOf(property);
        this.bins = BinnedArray$.MODULE$.apply(initialBins, initialEndpoints, ct);
    }
}

