/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.prism.MappingTargetPrism;
import org.mapstruct.ap.internal.prism.TargetTypePrism;
import org.mapstruct.ap.internal.util.AnnotationProcessingException;
import org.mapstruct.ap.internal.util.SpecificCompilerWorkarounds;

public class TypeFactory {
    private final Elements elementUtils;
    private final Types typeUtils;
    private final TypeMirror iterableType;
    private final TypeMirror collectionType;
    private final TypeMirror mapType;
    private final Map<String, Type> implementationTypes = new HashMap<String, Type>();
    private final Map<String, String> importedQualifiedTypesBySimpleName = new HashMap<String, String>();

    public TypeFactory(Elements elementUtils, Types typeUtils) {
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
        this.iterableType = SpecificCompilerWorkarounds.erasure(typeUtils, elementUtils.getTypeElement(Iterable.class.getCanonicalName()).asType());
        this.collectionType = SpecificCompilerWorkarounds.erasure(typeUtils, elementUtils.getTypeElement(Collection.class.getCanonicalName()).asType());
        this.mapType = SpecificCompilerWorkarounds.erasure(typeUtils, elementUtils.getTypeElement(Map.class.getCanonicalName()).asType());
        this.implementationTypes.put(Iterable.class.getName(), this.getType(ArrayList.class));
        this.implementationTypes.put(Collection.class.getName(), this.getType(ArrayList.class));
        this.implementationTypes.put(List.class.getName(), this.getType(ArrayList.class));
        this.implementationTypes.put(Set.class.getName(), this.getType(HashSet.class));
        this.implementationTypes.put(SortedSet.class.getName(), this.getType(TreeSet.class));
        this.implementationTypes.put(NavigableSet.class.getName(), this.getType(TreeSet.class));
        this.implementationTypes.put(Map.class.getName(), this.getType(HashMap.class));
        this.implementationTypes.put(SortedMap.class.getName(), this.getType(TreeMap.class));
        this.implementationTypes.put(NavigableMap.class.getName(), this.getType(TreeMap.class));
        this.implementationTypes.put(ConcurrentMap.class.getName(), this.getType(ConcurrentHashMap.class));
        this.implementationTypes.put(ConcurrentNavigableMap.class.getName(), this.getType(ConcurrentSkipListMap.class));
    }

    public Type getType(Class<?> type) {
        return type.isPrimitive() ? this.getType(this.getPrimitiveType(type)) : this.getType(type.getCanonicalName());
    }

    public Type getType(String canonicalName) {
        TypeElement typeElement = this.elementUtils.getTypeElement(canonicalName);
        if (typeElement == null) {
            throw new AnnotationProcessingException("Couldn't find type " + canonicalName + ". Are you missing a dependency on your classpath?");
        }
        return this.getType(typeElement);
    }

    public boolean isTypeAvailable(String canonicalName) {
        return null != this.elementUtils.getTypeElement(canonicalName);
    }

    public Type getType(TypeElement typeElement) {
        return this.getType(typeElement.asType());
    }

    public Type getType(TypeMirror mirror) {
        Type componentType;
        String qualifiedName;
        String packageName;
        TypeElement typeElement;
        String name;
        boolean isInterface;
        boolean isEnumType;
        if (mirror.getKind() == TypeKind.ERROR) {
            throw new AnnotationProcessingException("Encountered erroneous type " + mirror);
        }
        Type implementationType = this.getImplementationType(mirror);
        boolean isIterableType = SpecificCompilerWorkarounds.isSubType(this.typeUtils, mirror, this.iterableType);
        boolean isCollectionType = SpecificCompilerWorkarounds.isSubType(this.typeUtils, mirror, this.collectionType);
        boolean isMapType = SpecificCompilerWorkarounds.isSubType(this.typeUtils, mirror, this.mapType);
        if (mirror.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)mirror;
            isEnumType = declaredType.asElement().getKind() == ElementKind.ENUM;
            isInterface = declaredType.asElement().getKind() == ElementKind.INTERFACE;
            name = declaredType.asElement().getSimpleName().toString();
            typeElement = declaredType.asElement().accept(new TypeElementRetrievalVisitor(), null);
            if (typeElement != null) {
                packageName = this.elementUtils.getPackageOf(typeElement).getQualifiedName().toString();
                qualifiedName = typeElement.getQualifiedName().toString();
            } else {
                packageName = null;
                qualifiedName = name;
            }
            componentType = null;
        } else if (mirror.getKind() == TypeKind.ARRAY) {
            TypeMirror componentTypeMirror = this.getComponentType(mirror);
            if (componentTypeMirror.getKind() == TypeKind.DECLARED) {
                DeclaredType declaredType = (DeclaredType)componentTypeMirror;
                TypeElement componentTypeElement = declaredType.asElement().accept(new TypeElementRetrievalVisitor(), null);
                name = componentTypeElement.getSimpleName().toString() + "[]";
                packageName = this.elementUtils.getPackageOf(componentTypeElement).getQualifiedName().toString();
                qualifiedName = componentTypeElement.getQualifiedName().toString() + "[]";
            } else {
                name = mirror.toString();
                packageName = null;
                qualifiedName = name;
            }
            isEnumType = false;
            isInterface = false;
            typeElement = null;
            componentType = this.getType(componentTypeMirror);
        } else {
            isEnumType = false;
            isInterface = false;
            name = mirror.toString();
            packageName = null;
            qualifiedName = name;
            typeElement = null;
            componentType = null;
        }
        return new Type(this.typeUtils, this.elementUtils, this, mirror, typeElement, this.getTypeParameters(mirror, false), implementationType, componentType, packageName, name, qualifiedName, isInterface, isEnumType, isIterableType, isCollectionType, isMapType, this.isImported(name, qualifiedName));
    }

    public Type classTypeOf(Type type) {
        if (type.isVoid()) {
            return null;
        }
        TypeMirror typeToUse = type.isPrimitive() ? this.typeUtils.boxedClass((PrimitiveType)type.getTypeMirror()).asType() : type.getTypeMirror();
        return this.getType(this.typeUtils.getDeclaredType(this.elementUtils.getTypeElement("java.lang.Class"), typeToUse));
    }

    public ExecutableType getMethodType(TypeElement usedMapper, ExecutableElement method) {
        DeclaredType asType = (DeclaredType)SpecificCompilerWorkarounds.replaceTypeElementIfNecessary(this.elementUtils, usedMapper).asType();
        TypeMirror asMemberOf = this.typeUtils.asMemberOf(asType, method);
        ExecutableType methodType = asMemberOf.accept(new ExecutableTypeRetrievalVisitor(), null);
        return methodType;
    }

    public Parameter getSingleParameter(ExecutableElement method) {
        List<? extends VariableElement> parameters = method.getParameters();
        if (parameters.size() != 1) {
            return null;
        }
        VariableElement parameter = parameters.get(0);
        return new Parameter(parameter.getSimpleName().toString(), this.getType(parameter.asType()));
    }

    public List<Parameter> getParameters(ExecutableElement method) {
        List<? extends VariableElement> parameters = method.getParameters();
        ArrayList<Parameter> result = new ArrayList<Parameter>(parameters.size());
        for (VariableElement variableElement : parameters) {
            result.add(new Parameter(variableElement.getSimpleName().toString(), this.getType(variableElement.asType()), MappingTargetPrism.getInstanceOn(variableElement) != null, TargetTypePrism.getInstanceOn(variableElement) != null));
        }
        return result;
    }

    public List<Parameter> getParameters(ExecutableType methodType, ExecutableElement method) {
        List<? extends TypeMirror> parameterTypes = methodType.getParameterTypes();
        List<? extends VariableElement> parameters = method.getParameters();
        ArrayList<Parameter> result = new ArrayList<Parameter>(parameters.size());
        Iterator<? extends VariableElement> varIt = parameters.iterator();
        Iterator<? extends TypeMirror> typesIt = parameterTypes.iterator();
        while (varIt.hasNext()) {
            VariableElement parameter = varIt.next();
            TypeMirror parameterType = typesIt.next();
            result.add(new Parameter(parameter.getSimpleName().toString(), this.getType(parameterType), MappingTargetPrism.getInstanceOn(parameter) != null, TargetTypePrism.getInstanceOn(parameter) != null));
        }
        return result;
    }

    public Type getReturnType(ExecutableElement method) {
        return this.getType(method.getReturnType());
    }

    public Type getReturnType(ExecutableType method) {
        return this.getType(method.getReturnType());
    }

    public List<Type> getThrownTypes(ExecutableElement method) {
        ArrayList<Type> thrownTypes = new ArrayList<Type>();
        for (TypeMirror typeMirror : method.getThrownTypes()) {
            thrownTypes.add(this.getType(typeMirror));
        }
        return thrownTypes;
    }

    public List<Type> getThrownTypes(ExecutableType method) {
        ArrayList<Type> thrownTypes = new ArrayList<Type>();
        for (TypeMirror typeMirror : method.getThrownTypes()) {
            thrownTypes.add(this.getType(typeMirror));
        }
        return thrownTypes;
    }

    private List<Type> getTypeParameters(TypeMirror mirror, boolean isImplementationType) {
        if (mirror.getKind() != TypeKind.DECLARED) {
            return Collections.emptyList();
        }
        DeclaredType declaredType = (DeclaredType)mirror;
        ArrayList<Type> typeParameters = new ArrayList<Type>(declaredType.getTypeArguments().size());
        for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
            if (isImplementationType) {
                typeParameters.add(this.getType(typeMirror).getTypeBound());
                continue;
            }
            typeParameters.add(this.getType(typeMirror));
        }
        return typeParameters;
    }

    private TypeMirror getPrimitiveType(Class<?> primitiveType) {
        return primitiveType == Byte.TYPE ? this.typeUtils.getPrimitiveType(TypeKind.BYTE) : (primitiveType == Short.TYPE ? this.typeUtils.getPrimitiveType(TypeKind.SHORT) : (primitiveType == Integer.TYPE ? this.typeUtils.getPrimitiveType(TypeKind.INT) : (primitiveType == Long.TYPE ? this.typeUtils.getPrimitiveType(TypeKind.LONG) : (primitiveType == Float.TYPE ? this.typeUtils.getPrimitiveType(TypeKind.FLOAT) : (primitiveType == Double.TYPE ? this.typeUtils.getPrimitiveType(TypeKind.DOUBLE) : (primitiveType == Boolean.TYPE ? this.typeUtils.getPrimitiveType(TypeKind.BOOLEAN) : (primitiveType == Character.TYPE ? this.typeUtils.getPrimitiveType(TypeKind.CHAR) : this.typeUtils.getPrimitiveType(TypeKind.VOID))))))));
    }

    private Type getImplementationType(TypeMirror mirror) {
        if (mirror.getKind() != TypeKind.DECLARED) {
            return null;
        }
        DeclaredType declaredType = (DeclaredType)mirror;
        Type implementationType = this.implementationTypes.get(((TypeElement)declaredType.asElement()).getQualifiedName().toString());
        if (implementationType != null) {
            return new Type(this.typeUtils, this.elementUtils, this, this.typeUtils.getDeclaredType(implementationType.getTypeElement(), declaredType.getTypeArguments().toArray(new TypeMirror[0])), implementationType.getTypeElement(), this.getTypeParameters(mirror, true), null, null, implementationType.getPackageName(), implementationType.getName(), implementationType.getFullyQualifiedName(), implementationType.isInterface(), implementationType.isEnumType(), implementationType.isIterableType(), implementationType.isCollectionType(), implementationType.isMapType(), this.isImported(implementationType.getName(), implementationType.getFullyQualifiedName()));
        }
        return null;
    }

    private TypeMirror getComponentType(TypeMirror mirror) {
        if (mirror.getKind() != TypeKind.ARRAY) {
            return null;
        }
        ArrayType arrayType = (ArrayType)mirror;
        return arrayType.getComponentType();
    }

    private boolean isImported(String name, String qualifiedName) {
        String importedType = this.importedQualifiedTypesBySimpleName.get(name);
        boolean imported = false;
        if (importedType != null) {
            if (importedType.equals(qualifiedName)) {
                imported = true;
            }
        } else {
            this.importedQualifiedTypesBySimpleName.put(name, qualifiedName);
            imported = true;
        }
        return imported;
    }

    public Type asCollectionOrMap(Type collectionOrMap) {
        List<Type> originalParameters = collectionOrMap.getTypeParameters();
        TypeMirror[] originalParameterMirrors = new TypeMirror[originalParameters.size()];
        int i = 0;
        for (Type param : originalParameters) {
            originalParameterMirrors[i++] = param.getTypeMirror();
        }
        if (collectionOrMap.isCollectionType() && !"java.util.Collection".equals(collectionOrMap.getFullyQualifiedName())) {
            return this.getType(this.typeUtils.getDeclaredType(this.elementUtils.getTypeElement("java.util.Collection"), originalParameterMirrors));
        }
        if (collectionOrMap.isMapType() && !"java.util.Map".equals(collectionOrMap.getFullyQualifiedName())) {
            return this.getType(this.typeUtils.getDeclaredType(this.elementUtils.getTypeElement("java.util.Map"), originalParameterMirrors));
        }
        return collectionOrMap;
    }

    private static class ExecutableTypeRetrievalVisitor
    extends SimpleTypeVisitor6<ExecutableType, Void> {
        private ExecutableTypeRetrievalVisitor() {
        }

        @Override
        public ExecutableType visitExecutable(ExecutableType t, Void p) {
            return t;
        }
    }

    private static class TypeElementRetrievalVisitor
    extends SimpleElementVisitor6<TypeElement, Void> {
        private TypeElementRetrievalVisitor() {
        }

        @Override
        public TypeElement visitType(TypeElement e, Void p) {
            return e;
        }
    }
}

