/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.dependency;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.mapstruct.ap.internal.model.dependency.Node;

public class GraphAnalyzer {
    private final Map<String, Node> nodes;
    private final Set<List<String>> cycles;
    private final Stack<Node> currentPath;

    private GraphAnalyzer(Map<String, Node> nodes) {
        this.nodes = nodes;
        this.cycles = new HashSet<List<String>>();
        this.currentPath = new Stack();
    }

    public static GraphAnalyzerBuilder builder() {
        return new GraphAnalyzerBuilder();
    }

    public static GraphAnalyzerBuilder withNode(String name, String ... descendants) {
        return GraphAnalyzer.builder().withNode(name, descendants);
    }

    private void analyze() {
        for (Node node : this.nodes.values()) {
            this.depthFirstSearch(node);
        }
    }

    public Set<String> getAllDescendants(String name) {
        Node node = this.nodes.get(name);
        return node != null ? node.getAllDescendants() : Collections.emptySet();
    }

    public Set<List<String>> getCycles() {
        return this.cycles;
    }

    private void depthFirstSearch(Node node) {
        if (node.isProcessed()) {
            return;
        }
        this.currentPath.push(node);
        if (node.isVisited()) {
            this.cycles.add(this.getCurrentCycle(node));
            this.currentPath.pop();
            return;
        }
        node.setVisited(true);
        for (Node descendant : node.getDescendants()) {
            this.depthFirstSearch(descendant);
            node.getAllDescendants().addAll(descendant.getAllDescendants());
        }
        node.setProcessed(true);
        this.currentPath.pop();
    }

    private List<String> getCurrentCycle(Node start) {
        ArrayList<String> cycle = new ArrayList<String>();
        boolean inCycle = false;
        for (Node n : this.currentPath) {
            if (!inCycle && n.equals(start)) {
                inCycle = true;
            }
            if (!inCycle) continue;
            cycle.add(n.getName());
        }
        return cycle;
    }

    public static class GraphAnalyzerBuilder {
        private final Map<String, Node> nodes = new HashMap<String, Node>();

        public GraphAnalyzerBuilder withNode(String name, List<String> descendants) {
            Node node = this.getNode(name);
            for (String descendant : descendants) {
                node.addDescendant(this.getNode(descendant));
            }
            return this;
        }

        public GraphAnalyzerBuilder withNode(String name, String ... descendants) {
            return this.withNode(name, Arrays.asList(descendants));
        }

        public GraphAnalyzer build() {
            GraphAnalyzer graphAnalyzer = new GraphAnalyzer(this.nodes);
            graphAnalyzer.analyze();
            return graphAnalyzer;
        }

        private Node getNode(String name) {
            Node node = this.nodes.get(name);
            if (node == null) {
                node = new Node(name);
                this.nodes.put(name, node);
            }
            return node;
        }
    }
}

