/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.mapstruct.ap.internal.prism.MapMappingPrism;
import org.mapstruct.ap.internal.prism.NullValueMappingStrategyPrism;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;

public class MapMapping {
    private final String keyFormat;
    private final List<TypeMirror> keyQualifiers;
    private final String valueFormat;
    private final List<TypeMirror> valueQualifiers;
    private final AnnotationMirror mirror;
    private final TypeMirror keyQualifyingTargetType;
    private final TypeMirror valueQualifyingTargetType;
    private final NullValueMappingStrategyPrism nullValueMappingStrategy;

    public static MapMapping fromPrism(MapMappingPrism mapMapping, ExecutableElement method, FormattingMessager messager) {
        boolean valueTargetTypeIsDefined;
        if (mapMapping == null) {
            return null;
        }
        NullValueMappingStrategyPrism nullValueMappingStrategy = NullValueMappingStrategyPrism.valueOf(mapMapping.nullValueMappingStrategy());
        boolean keyTargetTypeIsDefined = !TypeKind.VOID.equals((Object)mapMapping.keyTargetType().getKind());
        boolean bl = valueTargetTypeIsDefined = !TypeKind.VOID.equals((Object)mapMapping.valueTargetType().getKind());
        if (mapMapping.keyDateFormat().isEmpty() && mapMapping.keyQualifiedBy().isEmpty() && mapMapping.valueDateFormat().isEmpty() && mapMapping.valueQualifiedBy().isEmpty() && !keyTargetTypeIsDefined && !valueTargetTypeIsDefined && nullValueMappingStrategy == NullValueMappingStrategyPrism.DEFAULT) {
            messager.printMessage((Element)method, Message.MAPMAPPING_NO_ELEMENTS, new Object[0]);
        }
        return new MapMapping(mapMapping.keyDateFormat(), mapMapping.keyQualifiedBy(), keyTargetTypeIsDefined ? mapMapping.keyTargetType() : null, mapMapping.valueDateFormat(), mapMapping.valueQualifiedBy(), valueTargetTypeIsDefined ? mapMapping.valueTargetType() : null, mapMapping.mirror, nullValueMappingStrategy);
    }

    private MapMapping(String keyFormat, List<TypeMirror> keyQualifiers, TypeMirror keyResultType, String valueFormat, List<TypeMirror> valueQualifiers, TypeMirror valueResultType, AnnotationMirror mirror, NullValueMappingStrategyPrism nvms) {
        this.keyFormat = keyFormat;
        this.keyQualifiers = keyQualifiers;
        this.keyQualifyingTargetType = keyResultType;
        this.valueFormat = valueFormat;
        this.valueQualifiers = valueQualifiers;
        this.valueQualifyingTargetType = valueResultType;
        this.mirror = mirror;
        this.nullValueMappingStrategy = nvms;
    }

    public String getKeyFormat() {
        return this.keyFormat;
    }

    public List<TypeMirror> getKeyQualifiers() {
        return this.keyQualifiers;
    }

    public TypeMirror getKeyQualifyingTargetType() {
        return this.keyQualifyingTargetType;
    }

    public String getValueFormat() {
        return this.valueFormat;
    }

    public List<TypeMirror> getValueQualifiers() {
        return this.valueQualifiers;
    }

    public TypeMirror getValueQualifyingTargetType() {
        return this.valueQualifyingTargetType;
    }

    public AnnotationMirror getMirror() {
        return this.mirror;
    }

    public NullValueMappingStrategyPrism getNullValueMappingStrategy() {
        return this.nullValueMappingStrategy;
    }
}

