/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.writer;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;

class IndentationCorrectingWriter
extends Writer {
    private static final boolean DEBUG = false;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final boolean IS_WINDOWS = System.getProperty("os.name").startsWith("Windows");
    private State currentState = State.START_OF_LINE;
    private final StateContext context;

    IndentationCorrectingWriter(Writer out) {
        super((Object)out);
        this.context = new StateContext(out);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.context.reset(cbuf, off);
        for (int i = off; i < len; ++i) {
            char c = cbuf[i];
            State newState = this.currentState.handleCharacter(c, this.context);
            if (newState != this.currentState) {
                this.currentState.onExit(this.context);
                newState.onEntry(this.context);
                this.currentState = newState;
            }
            ++this.context.currentIndex;
        }
        this.currentState.onBufferFinished(this.context);
    }

    @Override
    public void flush() throws IOException {
        this.context.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.currentState.onExit(this.context);
        this.context.writer.close();
    }

    private static boolean isWindows() {
        return IS_WINDOWS;
    }

    private static char[] getIndentation(int indentationLevel) {
        char[] indentation = new char[indentationLevel * 4];
        Arrays.fill(indentation, ' ');
        return indentation;
    }

    private static class StateContext {
        final Writer writer;
        char[] characters;
        int lastStateChange;
        int currentIndex;
        int indentationLevel;
        int consecutiveLineBreaks;

        StateContext(Writer writer) {
            this.writer = writer;
        }

        void reset(char[] characters, int off) {
            this.characters = characters;
            this.lastStateChange = off;
            this.currentIndex = 0;
        }
    }

    private static enum State {
        START_OF_LINE{

            @Override
            State doHandleCharacter(char c, StateContext context) {
                switch (c) {
                    case '(': 
                    case '{': {
                        ++context.indentationLevel;
                        return IN_TEXT;
                    }
                    case ')': 
                    case '}': {
                        --context.indentationLevel;
                        return IN_TEXT;
                    }
                    case '\"': {
                        return IN_STRING;
                    }
                    case '\r': {
                        return IndentationCorrectingWriter.isWindows() ? IN_LINE_BREAK : AFTER_LINE_BREAK;
                    }
                    case '\n': {
                        return AFTER_LINE_BREAK;
                    }
                }
                return IN_TEXT;
            }

            @Override
            void doOnEntry(StateContext context) throws IOException {
                context.writer.write(IndentationCorrectingWriter.getIndentation(context.indentationLevel));
            }

            @Override
            void onExit(StateContext context) throws IOException {
                this.flush(context);
            }

            @Override
            void onBufferFinished(StateContext context) throws IOException {
                this.flush(context);
            }
        }
        ,
        IN_TEXT{

            @Override
            State doHandleCharacter(char c, StateContext context) {
                switch (c) {
                    case '(': 
                    case '{': {
                        ++context.indentationLevel;
                        return IN_TEXT;
                    }
                    case ')': 
                    case '}': {
                        --context.indentationLevel;
                        return IN_TEXT;
                    }
                    case '\"': {
                        return IN_STRING;
                    }
                    case '\r': {
                        return IndentationCorrectingWriter.isWindows() ? IN_LINE_BREAK : AFTER_LINE_BREAK;
                    }
                    case '\n': {
                        return AFTER_LINE_BREAK;
                    }
                }
                return IN_TEXT;
            }

            @Override
            void onExit(StateContext context) throws IOException {
                this.flush(context);
            }

            @Override
            void onBufferFinished(StateContext context) throws IOException {
                this.flush(context);
            }
        }
        ,
        IN_STRING{

            @Override
            State doHandleCharacter(char c, StateContext context) {
                switch (c) {
                    case '\"': {
                        return IN_TEXT;
                    }
                    case '\\': {
                        return IN_STRING_ESCAPED_CHAR;
                    }
                }
                return IN_STRING;
            }

            @Override
            void onExit(StateContext context) throws IOException {
                this.flush(context);
            }

            @Override
            void onBufferFinished(StateContext context) throws IOException {
                this.flush(context);
            }
        }
        ,
        IN_STRING_ESCAPED_CHAR{

            @Override
            State doHandleCharacter(char c, StateContext context) {
                return IN_STRING;
            }

            @Override
            void onExit(StateContext context) throws IOException {
                this.flush(context);
            }

            @Override
            void onBufferFinished(StateContext context) throws IOException {
                this.flush(context);
            }
        }
        ,
        IN_LINE_BREAK{

            @Override
            State doHandleCharacter(char c, StateContext context) {
                if (c == '\n') {
                    return AFTER_LINE_BREAK;
                }
                throw new IllegalArgumentException("Unexpected character: " + c);
            }
        }
        ,
        AFTER_LINE_BREAK{

            @Override
            State doHandleCharacter(char c, StateContext context) {
                switch (c) {
                    case '(': 
                    case '{': {
                        ++context.indentationLevel;
                        return START_OF_LINE;
                    }
                    case ')': 
                    case '}': {
                        --context.indentationLevel;
                        return START_OF_LINE;
                    }
                    case '\r': {
                        return IndentationCorrectingWriter.isWindows() ? IN_LINE_BREAK : AFTER_LINE_BREAK;
                    }
                    case ' ': {
                        return AFTER_LINE_BREAK;
                    }
                    case '\n': {
                        ++context.consecutiveLineBreaks;
                        return AFTER_LINE_BREAK;
                    }
                }
                return START_OF_LINE;
            }

            @Override
            void onExit(StateContext context) throws IOException {
                ++context.consecutiveLineBreaks;
                int lineBreaks = Math.min(context.consecutiveLineBreaks, 2);
                for (int i = 0; i < lineBreaks; ++i) {
                    context.writer.append(LINE_SEPARATOR);
                }
                context.consecutiveLineBreaks = 0;
            }
        };


        final State handleCharacter(char c, StateContext context) throws IOException {
            return this.doHandleCharacter(c, context);
        }

        abstract State doHandleCharacter(char var1, StateContext var2) throws IOException;

        final void onEntry(StateContext context) throws IOException {
            context.lastStateChange = context.currentIndex;
            this.doOnEntry(context);
        }

        void doOnEntry(StateContext context) throws IOException {
        }

        void onExit(StateContext context) throws IOException {
        }

        void onBufferFinished(StateContext context) throws IOException {
        }

        protected void flush(StateContext context) throws IOException {
            if (null != context.characters && context.currentIndex - context.lastStateChange > 0) {
                context.writer.write(context.characters, context.lastStateChange, context.currentIndex - context.lastStateChange);
            }
        }
    }
}

