/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.mapstruct.ap.internal.model.Constructor;
import org.mapstruct.ap.internal.model.Decorator;
import org.mapstruct.ap.internal.model.Field;
import org.mapstruct.ap.internal.model.GeneratedType;
import org.mapstruct.ap.internal.model.MappingMethod;
import org.mapstruct.ap.internal.model.NoArgumentConstructor;
import org.mapstruct.ap.internal.model.SupportingConstructorFragment;
import org.mapstruct.ap.internal.model.common.Accessibility;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.option.Options;
import org.mapstruct.ap.internal.version.VersionInformation;

public class Mapper
extends GeneratedType {
    static final String CLASS_NAME_PLACEHOLDER = "<CLASS_NAME>";
    static final String PACKAGE_NAME_PLACEHOLDER = "<PACKAGE_NAME>";
    static final String DEFAULT_IMPLEMENTATION_CLASS = "<CLASS_NAME>Impl";
    static final String DEFAULT_IMPLEMENTATION_PACKAGE = "<PACKAGE_NAME>";
    private final boolean customPackage;
    private final boolean customImplName;
    private Decorator decorator;

    private Mapper(TypeFactory typeFactory, String packageName, String name, String superClassName, String interfacePackage, String interfaceName, boolean customPackage, boolean customImplName, List<MappingMethod> methods, Options options, VersionInformation versionInformation, Accessibility accessibility, List<Field> fields, Constructor constructor, Decorator decorator, SortedSet<Type> extraImportedTypes) {
        super(typeFactory, packageName, name, superClassName, interfacePackage, interfaceName, methods, fields, options, versionInformation, accessibility, extraImportedTypes, constructor);
        this.customPackage = customPackage;
        this.customImplName = customImplName;
        this.decorator = decorator;
    }

    public Decorator getDecorator() {
        return this.decorator;
    }

    public void removeDecorator() {
        this.decorator = null;
    }

    public boolean hasCustomImplementation() {
        return this.customImplName || this.customPackage;
    }

    @Override
    protected String getTemplateName() {
        return this.getTemplateNameForClass(GeneratedType.class);
    }

    public static String getFlatName(TypeElement element) {
        if (!(element.getEnclosingElement() instanceof TypeElement)) {
            return element.getSimpleName().toString();
        }
        StringBuilder nameBuilder = new StringBuilder(element.getSimpleName().toString());
        Element enclosing = element.getEnclosingElement();
        while (enclosing instanceof TypeElement) {
            nameBuilder.insert(0, '$');
            nameBuilder.insert(0, enclosing.getSimpleName().toString());
            enclosing = enclosing.getEnclosingElement();
        }
        return nameBuilder.toString();
    }

    public static class Builder {
        private TypeFactory typeFactory;
        private TypeElement element;
        private List<MappingMethod> mappingMethods;
        private List<Field> fields;
        private Set<SupportingConstructorFragment> fragments;
        private SortedSet<Type> extraImportedTypes;
        private Elements elementUtils;
        private Options options;
        private VersionInformation versionInformation;
        private Decorator decorator;
        private String implName;
        private boolean customName;
        private String implPackage;
        private boolean customPackage;

        public Builder element(TypeElement element) {
            this.element = element;
            return this;
        }

        public Builder mappingMethods(List<MappingMethod> mappingMethods) {
            this.mappingMethods = mappingMethods;
            return this;
        }

        public Builder fields(List<Field> fields) {
            this.fields = fields;
            return this;
        }

        public Builder constructorFragments(Set<SupportingConstructorFragment> fragments) {
            this.fragments = fragments;
            return this;
        }

        public Builder options(Options options) {
            this.options = options;
            return this;
        }

        public Builder versionInformation(VersionInformation versionInformation) {
            this.versionInformation = versionInformation;
            return this;
        }

        public Builder typeFactory(TypeFactory typeFactory) {
            this.typeFactory = typeFactory;
            return this;
        }

        public Builder elementUtils(Elements elementUtils) {
            this.elementUtils = elementUtils;
            return this;
        }

        public Builder decorator(Decorator decorator) {
            this.decorator = decorator;
            return this;
        }

        public Builder extraImports(SortedSet<Type> extraImportedTypes) {
            this.extraImportedTypes = extraImportedTypes;
            return this;
        }

        public Builder implName(String implName) {
            this.implName = implName;
            this.customName = !Mapper.DEFAULT_IMPLEMENTATION_CLASS.equals(this.implName);
            return this;
        }

        public Builder implPackage(String implPackage) {
            this.implPackage = implPackage;
            this.customPackage = !"<PACKAGE_NAME>".equals(this.implPackage);
            return this;
        }

        public Mapper build() {
            String implementationName = this.implName.replace(Mapper.CLASS_NAME_PLACEHOLDER, Mapper.getFlatName(this.element)) + (this.decorator == null ? "" : "_");
            String elementPackage = this.elementUtils.getPackageOf(this.element).getQualifiedName().toString();
            String packageName = this.implPackage.replace("<PACKAGE_NAME>", elementPackage);
            NoArgumentConstructor constructor = null;
            if (!this.fragments.isEmpty()) {
                constructor = new NoArgumentConstructor(implementationName, this.fragments);
            }
            return new Mapper(this.typeFactory, packageName, implementationName, this.element.getKind() != ElementKind.INTERFACE ? this.element.getSimpleName().toString() : null, elementPackage, this.element.getKind() == ElementKind.INTERFACE ? this.element.getSimpleName().toString() : null, this.customPackage, this.customName, this.mappingMethods, this.options, this.versionInformation, Accessibility.fromModifiers(this.element.getModifiers()), this.fields, constructor, this.decorator, this.extraImportedTypes);
        }
    }
}

