/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mapstruct.ap.internal.model.LifecycleCallbackMethodReference;
import org.mapstruct.ap.internal.model.MapperReference;
import org.mapstruct.ap.internal.model.MappingBuilderContext;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.ParameterProvidedMethods;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.model.source.selector.MethodSelectors;
import org.mapstruct.ap.internal.model.source.selector.SelectedMethod;
import org.mapstruct.ap.internal.model.source.selector.SelectionCriteria;

public final class LifecycleMethodResolver {
    private LifecycleMethodResolver() {
    }

    public static List<LifecycleCallbackMethodReference> beforeMappingMethods(Method method, Type alternativeTarget, SelectionParameters selectionParameters, MappingBuilderContext ctx, Set<String> existingVariableNames) {
        return LifecycleMethodResolver.collectLifecycleCallbackMethods(method, alternativeTarget, selectionParameters, LifecycleMethodResolver.filterBeforeMappingMethods(LifecycleMethodResolver.getAllAvailableMethods(method, ctx.getSourceModel())), ctx, existingVariableNames);
    }

    public static List<LifecycleCallbackMethodReference> afterMappingMethods(Method method, Type alternativeTarget, SelectionParameters selectionParameters, MappingBuilderContext ctx, Set<String> existingVariableNames) {
        return LifecycleMethodResolver.collectLifecycleCallbackMethods(method, alternativeTarget, selectionParameters, LifecycleMethodResolver.filterAfterMappingMethods(LifecycleMethodResolver.getAllAvailableMethods(method, ctx.getSourceModel())), ctx, existingVariableNames);
    }

    public static List<LifecycleCallbackMethodReference> beforeMappingMethods(Method method, SelectionParameters selectionParameters, MappingBuilderContext ctx, Set<String> existingVariableNames) {
        return LifecycleMethodResolver.collectLifecycleCallbackMethods(method, method.getResultType(), selectionParameters, LifecycleMethodResolver.filterBeforeMappingMethods(LifecycleMethodResolver.getAllAvailableMethods(method, ctx.getSourceModel())), ctx, existingVariableNames);
    }

    public static List<LifecycleCallbackMethodReference> afterMappingMethods(Method method, SelectionParameters selectionParameters, MappingBuilderContext ctx, Set<String> existingVariableNames) {
        return LifecycleMethodResolver.collectLifecycleCallbackMethods(method, method.getResultType(), selectionParameters, LifecycleMethodResolver.filterAfterMappingMethods(LifecycleMethodResolver.getAllAvailableMethods(method, ctx.getSourceModel())), ctx, existingVariableNames);
    }

    private static List<SourceMethod> getAllAvailableMethods(Method method, List<SourceMethod> sourceModelMethods) {
        ParameterProvidedMethods contextProvidedMethods = method.getContextProvidedMethods();
        if (contextProvidedMethods.isEmpty()) {
            return sourceModelMethods;
        }
        List<SourceMethod> methodsProvidedByParams = contextProvidedMethods.getAllProvidedMethodsInParameterOrder(method.getContextParameters());
        ArrayList<SourceMethod> availableMethods = new ArrayList<SourceMethod>(methodsProvidedByParams.size() + sourceModelMethods.size());
        availableMethods.addAll(methodsProvidedByParams);
        availableMethods.addAll(sourceModelMethods);
        return availableMethods;
    }

    private static List<LifecycleCallbackMethodReference> collectLifecycleCallbackMethods(Method method, Type targetType, SelectionParameters selectionParameters, List<SourceMethod> callbackMethods, MappingBuilderContext ctx, Set<String> existingVariableNames) {
        MethodSelectors selectors = new MethodSelectors(ctx.getTypeUtils(), ctx.getElementUtils(), ctx.getTypeFactory(), ctx.getMessager());
        List<SelectedMethod<SourceMethod>> matchingMethods = selectors.getMatchingMethods(method, callbackMethods, Collections.emptyList(), targetType, SelectionCriteria.forLifecycleMethods(selectionParameters));
        return LifecycleMethodResolver.toLifecycleCallbackMethodRefs(method, matchingMethods, ctx, existingVariableNames);
    }

    private static List<LifecycleCallbackMethodReference> toLifecycleCallbackMethodRefs(Method method, List<SelectedMethod<SourceMethod>> candidates, MappingBuilderContext ctx, Set<String> existingVariableNames) {
        ArrayList<LifecycleCallbackMethodReference> result = new ArrayList<LifecycleCallbackMethodReference>();
        for (SelectedMethod<SourceMethod> candidate : candidates) {
            Parameter providingParameter = method.getContextProvidedMethods().getParameterForProvidedMethod(candidate.getMethod());
            if (providingParameter != null) {
                result.add(LifecycleCallbackMethodReference.forParameterProvidedMethod(candidate, providingParameter, method, existingVariableNames));
                continue;
            }
            MapperReference mapperReference = MapperReference.findMapperReference(ctx.getMapperReferences(), candidate.getMethod());
            result.add(LifecycleCallbackMethodReference.forMethodReference(candidate, mapperReference, method, existingVariableNames));
        }
        return result;
    }

    private static List<SourceMethod> filterBeforeMappingMethods(List<SourceMethod> methods) {
        return methods.stream().filter(SourceMethod::isBeforeMappingMethod).collect(Collectors.toList());
    }

    private static List<SourceMethod> filterAfterMappingMethods(List<SourceMethod> methods) {
        return methods.stream().filter(SourceMethod::isAfterMappingMethod).collect(Collectors.toList());
    }
}

