/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc;

import io.r2dbc.spi.ColumnMetadata;
import io.r2dbc.spi.Nullability;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;

final class MariadbColumnMetadata
implements ColumnMetadata {
    private ColumnDefinitionPacket columnDefinitionPacket;

    MariadbColumnMetadata(ColumnDefinitionPacket columnDefinitionPacket) {
        this.columnDefinitionPacket = columnDefinitionPacket;
    }

    public String getName() {
        return this.columnDefinitionPacket.getColumnAlias();
    }

    public Class<?> getJavaType() {
        return this.columnDefinitionPacket.getJavaClass();
    }

    public ColumnDefinitionPacket getNativeTypeMetadata() {
        return this.columnDefinitionPacket;
    }

    public Nullability getNullability() {
        return this.columnDefinitionPacket.getNullability();
    }

    public Integer getPrecision() {
        switch (this.columnDefinitionPacket.getType()) {
            case OLDDECIMAL: 
            case DECIMAL: {
                if (this.columnDefinitionPacket.isSigned()) {
                    return (int)(this.columnDefinitionPacket.getLength() - (long)(this.columnDefinitionPacket.getDecimals() > 0 ? 2 : 1));
                }
                return (int)(this.columnDefinitionPacket.getLength() - (long)(this.columnDefinitionPacket.getDecimals() > 0 ? 1 : 0));
            }
        }
        return (int)this.columnDefinitionPacket.getLength();
    }

    public Integer getScale() {
        switch (this.columnDefinitionPacket.getType()) {
            case OLDDECIMAL: 
            case DECIMAL: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: 
            case BIGINT: 
            case MEDIUMINT: 
            case BIT: {
                return this.columnDefinitionPacket.getDecimals();
            }
        }
        return 0;
    }
}

