/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.client;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import org.mariadb.r2dbc.client.Context;
import org.mariadb.r2dbc.message.client.ClientMessage;

public class MariadbPacketEncoder
extends MessageToByteEncoder<ClientMessage> {
    private Context context = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encode(ChannelHandlerContext ctx, ClientMessage msg, ByteBuf out) throws Exception {
        ByteBuf buf = null;
        try {
            buf = msg.encode(this.context, ctx.alloc());
            if (buf.writerIndex() - buf.readerIndex() < 0xFFFFFF) {
                out.writeMediumLE(buf.writerIndex() - buf.readerIndex());
                out.writeByte((int)msg.getSequencer().next());
                out.writeBytes(buf);
                return;
            }
            int packetLength = -1;
            for (int readerIndex = buf.readerIndex(); readerIndex < buf.writerIndex(); readerIndex += packetLength) {
                packetLength = Math.min(0xFFFFFF, buf.writerIndex() - readerIndex);
                out.writeMediumLE(packetLength);
                out.writeByte((int)msg.getSequencer().next());
                out.writeBytes(buf.slice(readerIndex, packetLength));
            }
            if (packetLength == 0xFFFFFF) {
                out.writeMediumLE(packetLength);
                out.writeByte((int)msg.getSequencer().next());
            }
        }
        finally {
            if (buf != null) {
                buf.release();
            }
        }
    }

    public void setContext(Context context) {
        this.context = context;
    }
}

