/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.codec;

import io.netty.buffer.ByteBuf;
import org.mariadb.r2dbc.client.Context;
import org.mariadb.r2dbc.codec.Codec;
import org.mariadb.r2dbc.codec.DataType;
import org.mariadb.r2dbc.util.BufferUtils;

public class Parameter<T> {
    public static final Parameter<?> NULL_PARAMETER = new Parameter(null, (Object)null){

        @Override
        public void encodeText(ByteBuf out, Context context) {
            BufferUtils.writeAscii(out, "null");
        }

        @Override
        public DataType getBinaryEncodeType() {
            return DataType.VARCHAR;
        }

        @Override
        public boolean isNull() {
            return true;
        }
    };
    private final Codec<T> codec;
    private final T value;

    public Parameter(Codec<T> codec, T value) {
        this.codec = codec;
        this.value = value;
    }

    public void encodeText(ByteBuf out, Context context) {
        this.codec.encodeText(out, context, this.value);
    }

    public void encodeBinary(ByteBuf out, Context context) {
        this.codec.encodeBinary(out, context, this.value);
    }

    public DataType getBinaryEncodeType() {
        return this.codec.getBinaryEncodeType();
    }

    public boolean isNull() {
        return false;
    }

    public String toString() {
        return "Parameter{codec=" + this.codec.getClass().getSimpleName() + ", value=" + this.value + '}';
    }
}

