/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.codec;

import org.mariadb.r2dbc.MariadbConnectionConfiguration;
import org.mariadb.r2dbc.codec.Codec;
import org.mariadb.r2dbc.codec.Codecs;
import org.mariadb.r2dbc.codec.RowDecoder;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;

public class TextRowDecoder
extends RowDecoder {
    public TextRowDecoder(int columnNumber, ColumnDefinitionPacket[] columns, MariadbConnectionConfiguration conf) {
        super(conf);
    }

    @Override
    public <T> T get(int index, ColumnDefinitionPacket column, Class<T> type) throws IllegalArgumentException {
        this.setPosition(index);
        if (this.length == -1) {
            if (type.isPrimitive()) {
                throw new IllegalArgumentException(String.format("Cannot return null for primitive %s", type.getName()));
            }
            return null;
        }
        if (Object.class == type || type == null) {
            Codec<?> defaultCodec = column.getDefaultCodec(this.conf);
            return (T)defaultCodec.decodeText(this.buf, this.length, column, type);
        }
        for (Codec<T> codec : Codecs.LIST) {
            if (!codec.canDecode(column, type)) continue;
            return (T)codec.decodeText(this.buf, this.length, column, type);
        }
        this.buf.skipBytes(this.length);
        throw this.noDecoderException(column, type);
    }

    @Override
    public void setPosition(int newIndex) {
        short type;
        if (this.index >= newIndex) {
            this.index = -1;
            this.buf.resetReaderIndex();
        }
        ++this.index;
        while (this.index < newIndex) {
            type = this.buf.readUnsignedByte();
            switch (type) {
                case 252: {
                    this.buf.skipBytes(this.buf.readUnsignedShortLE());
                    break;
                }
                case 253: {
                    this.buf.skipBytes(this.buf.readUnsignedMediumLE());
                    break;
                }
                case 254: {
                    this.buf.skipBytes((int)this.buf.readLongLE());
                    break;
                }
                case 251: {
                    break;
                }
                default: {
                    this.buf.skipBytes((int)type);
                }
            }
            ++this.index;
        }
        type = this.buf.readUnsignedByte();
        switch (type) {
            case 251: {
                this.length = -1;
                break;
            }
            case 252: {
                this.length = this.buf.readUnsignedShortLE();
                break;
            }
            case 253: {
                this.length = this.buf.readUnsignedMediumLE();
                break;
            }
            case 254: {
                this.length = (int)this.buf.readLongLE();
                break;
            }
            default: {
                this.length = type;
            }
        }
    }
}

