/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.codec.list;

import io.netty.buffer.ByteBuf;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import org.mariadb.r2dbc.client.Context;
import org.mariadb.r2dbc.codec.Codec;
import org.mariadb.r2dbc.codec.DataType;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;
import org.mariadb.r2dbc.util.BufferUtils;

public class FloatCodec
implements Codec<Float> {
    public static final FloatCodec INSTANCE = new FloatCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.TINYINT, new DataType[]{DataType.SMALLINT, DataType.MEDIUMINT, DataType.INTEGER, DataType.FLOAT, DataType.BIGINT, DataType.OLDDECIMAL, DataType.DECIMAL, DataType.YEAR, DataType.DOUBLE, DataType.VARCHAR, DataType.VARSTRING, DataType.STRING});

    @Override
    public boolean canDecode(ColumnDefinitionPacket column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && (type.isPrimitive() && type == Float.TYPE || type.isAssignableFrom(Float.class));
    }

    @Override
    public boolean canEncode(Class<?> value) {
        return Float.class.isAssignableFrom(value);
    }

    @Override
    public Float decodeText(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends Float> type) {
        switch (column.getType()) {
            case TINYINT: 
            case SMALLINT: 
            case MEDIUMINT: 
            case INTEGER: 
            case BIGINT: 
            case DOUBLE: 
            case OLDDECIMAL: 
            case DECIMAL: 
            case YEAR: 
            case FLOAT: {
                return Float.valueOf(buf.readCharSequence(length, StandardCharsets.US_ASCII).toString());
            }
        }
        String val = buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
        try {
            return Float.valueOf(val);
        }
        catch (NumberFormatException nfe) {
            throw new R2dbcNonTransientResourceException(String.format("value '%s' cannot be decoded as Float", val));
        }
    }

    @Override
    public Float decodeBinary(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends Float> type) {
        switch (column.getType()) {
            case FLOAT: {
                return Float.valueOf(buf.readFloatLE());
            }
            case TINYINT: {
                if (!column.isSigned()) {
                    return Float.valueOf(buf.readUnsignedByte());
                }
                return Float.valueOf(buf.readByte());
            }
            case SMALLINT: 
            case YEAR: {
                if (!column.isSigned()) {
                    return Float.valueOf(buf.readUnsignedShortLE());
                }
                return Float.valueOf(buf.readShortLE());
            }
            case MEDIUMINT: {
                if (!column.isSigned()) {
                    return Float.valueOf(buf.readUnsignedMediumLE());
                }
                return Float.valueOf(buf.readMediumLE());
            }
            case INTEGER: {
                if (!column.isSigned()) {
                    return Float.valueOf(buf.readUnsignedIntLE());
                }
                return Float.valueOf(buf.readIntLE());
            }
            case BIGINT: {
                if (column.isSigned()) {
                    return Float.valueOf(buf.readLongLE());
                }
                byte[] bb = new byte[8];
                for (int i = 7; i >= 0; --i) {
                    bb[i] = buf.readByte();
                }
                return Float.valueOf(new BigInteger(1, bb).floatValue());
            }
            case DOUBLE: {
                return Float.valueOf((float)buf.readDoubleLE());
            }
            case OLDDECIMAL: 
            case DECIMAL: {
                return Float.valueOf(new BigDecimal(buf.readCharSequence(length, StandardCharsets.US_ASCII).toString()).floatValue());
            }
        }
        String str2 = buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
        try {
            return Float.valueOf(str2);
        }
        catch (NumberFormatException nfe) {
            throw new R2dbcNonTransientResourceException(String.format("value '%s' cannot be decoded as Float", str2));
        }
    }

    @Override
    public void encodeText(ByteBuf buf, Context context, Float value) {
        BufferUtils.writeAscii(buf, String.valueOf(value));
    }

    @Override
    public void encodeBinary(ByteBuf buf, Context context, Float value) {
        buf.writeFloatLE(value.floatValue());
    }

    @Override
    public DataType getBinaryEncodeType() {
        return DataType.FLOAT;
    }
}

