/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.message.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.StandardCharsets;
import org.mariadb.r2dbc.client.Context;
import org.mariadb.r2dbc.message.client.ClientMessage;
import org.mariadb.r2dbc.message.server.Sequencer;
import org.mariadb.r2dbc.util.Assert;

public final class PreparePacket
implements ClientMessage {
    private final String sql;
    private final Sequencer sequencer = new Sequencer(-1);

    public PreparePacket(String sql) {
        this.sql = Assert.requireNonNull(sql, "query must not be null");
    }

    public String getSql() {
        return this.sql;
    }

    @Override
    public Sequencer getSequencer() {
        return this.sequencer;
    }

    @Override
    public ByteBuf encode(Context context, ByteBufAllocator allocator) {
        ByteBuf buf = allocator.ioBuffer(this.sql.length() + 1);
        buf.writeByte(22);
        buf.writeCharSequence((CharSequence)this.sql, StandardCharsets.UTF_8);
        return buf;
    }
}

