/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.message.server;

import io.netty.buffer.ByteBuf;
import io.r2dbc.spi.Blob;
import io.r2dbc.spi.Nullability;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.BitSet;
import org.mariadb.r2dbc.MariadbConnectionConfiguration;
import org.mariadb.r2dbc.client.Context;
import org.mariadb.r2dbc.codec.Codec;
import org.mariadb.r2dbc.codec.DataType;
import org.mariadb.r2dbc.codec.list.BigDecimalCodec;
import org.mariadb.r2dbc.codec.list.BigIntegerCodec;
import org.mariadb.r2dbc.codec.list.BitSetCodec;
import org.mariadb.r2dbc.codec.list.BlobCodec;
import org.mariadb.r2dbc.codec.list.BooleanCodec;
import org.mariadb.r2dbc.codec.list.ByteArrayCodec;
import org.mariadb.r2dbc.codec.list.ByteCodec;
import org.mariadb.r2dbc.codec.list.DoubleCodec;
import org.mariadb.r2dbc.codec.list.DurationCodec;
import org.mariadb.r2dbc.codec.list.FloatCodec;
import org.mariadb.r2dbc.codec.list.IntCodec;
import org.mariadb.r2dbc.codec.list.LocalDateCodec;
import org.mariadb.r2dbc.codec.list.LocalDateTimeCodec;
import org.mariadb.r2dbc.codec.list.LongCodec;
import org.mariadb.r2dbc.codec.list.ShortCodec;
import org.mariadb.r2dbc.codec.list.StringCodec;
import org.mariadb.r2dbc.message.server.Sequencer;
import org.mariadb.r2dbc.message.server.ServerMessage;
import reactor.util.Logger;
import reactor.util.Loggers;

public final class ColumnDefinitionPacket
implements ServerMessage {
    private static final Logger logger = Loggers.getLogger(ColumnDefinitionPacket.class);
    private static final int[] maxCharlen = new int[]{0, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 2, 1, 1, 1, 0, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 3, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 4, 1, 1, 1, 1, 1, 1, 1, 4, 4, 0, 1, 1, 1, 4, 4, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 3, 2, 2, 2, 2, 2, 1, 2, 3, 1, 1, 1, 2, 2, 3, 3, 1, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 4, 4, 0, 0, 0, 0, 0, 0, 0, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private final byte[] meta;
    private final int charset;
    private final long length;
    private final DataType dataType;
    private final byte decimals;
    private final int flags;
    private boolean ending;

    private ColumnDefinitionPacket(byte[] meta, int charset, long length, DataType dataType, byte decimals, int flags, boolean ending) {
        this.meta = meta;
        this.charset = charset;
        this.length = length;
        this.dataType = dataType;
        this.decimals = decimals;
        this.flags = flags;
        this.ending = ending;
    }

    private ColumnDefinitionPacket(String name) {
        int i;
        byte[] nameBytes = name.getBytes(StandardCharsets.UTF_8);
        byte[] arr = new byte[6 + 2 * nameBytes.length];
        int pos = 0;
        for (i = 0; i < 4; ++i) {
            arr[pos++] = 0;
        }
        for (i = 0; i < 2; ++i) {
            arr[pos++] = (byte)nameBytes.length;
            System.arraycopy(nameBytes, 0, arr, pos, nameBytes.length);
            pos += nameBytes.length;
        }
        this.meta = arr;
        this.charset = 33;
        this.length = 8L;
        this.dataType = DataType.BIGINT;
        this.decimals = 0;
        this.flags = 2;
        this.ending = false;
    }

    public static ColumnDefinitionPacket decode(Sequencer sequencer, ByteBuf buf, Context context, boolean ending) {
        byte[] meta = new byte[buf.readableBytes() - 12];
        buf.readBytes(meta);
        int charset = buf.readUnsignedShortLE();
        long length = buf.readUnsignedIntLE();
        DataType dataType = DataType.fromServer(buf.readUnsignedByte(), charset);
        int flags = buf.readUnsignedShortLE();
        byte decimals = buf.readByte();
        return new ColumnDefinitionPacket(meta, charset, length, dataType, decimals, flags, ending);
    }

    public static ColumnDefinitionPacket fromGeneratedId(String name) {
        return new ColumnDefinitionPacket(name);
    }

    private String getString(int idx) {
        int pos = 0;
        for (int i = 0; i < idx; ++i) {
            int len = this.meta[pos++] & 0xFF;
            pos += len;
        }
        int length = this.meta[pos++] & 0xFF;
        return new String(this.meta, pos, length, StandardCharsets.UTF_8);
    }

    public String getSchema() {
        return this.getString(1);
    }

    public String getTableAlias() {
        return this.getString(2);
    }

    public String getTable() {
        return this.getString(3);
    }

    public String getColumnAlias() {
        return this.getString(4);
    }

    public String getColumn() {
        return this.getString(5);
    }

    public int getCharset() {
        return this.charset;
    }

    public long getLength() {
        return this.length;
    }

    public DataType getType() {
        return this.dataType;
    }

    public byte getDecimals() {
        return this.decimals;
    }

    public boolean isSigned() {
        return (this.flags & 0x20) == 0;
    }

    public int getDisplaySize() {
        if (this.dataType == DataType.VARCHAR || this.dataType == DataType.JSON || this.dataType == DataType.ENUM || this.dataType == DataType.SET || this.dataType == DataType.VARSTRING || this.dataType == DataType.STRING) {
            return (int)(this.length / (long)(maxCharlen[this.charset] == 0 ? 1 : maxCharlen[this.charset]));
        }
        return (int)this.length;
    }

    public Nullability getNullability() {
        return (this.flags & 1) > 0 ? Nullability.NON_NULL : Nullability.NULLABLE;
    }

    public boolean isPrimaryKey() {
        return (this.flags & 2) > 0;
    }

    public boolean isUniqueKey() {
        return (this.flags & 4) > 0;
    }

    public boolean isMultipleKey() {
        return (this.flags & 8) > 0;
    }

    public boolean isBlob() {
        return (this.flags & 0x10) > 0;
    }

    public boolean isZeroFill() {
        return (this.flags & 0x40) > 0;
    }

    public boolean isBinary() {
        return this.charset == 63;
    }

    public Class<?> getJavaClass() {
        switch (this.dataType) {
            case TINYINT: {
                return this.isSigned() ? Byte.class : Short.class;
            }
            case SMALLINT: {
                return this.isSigned() ? Short.class : Integer.class;
            }
            case INTEGER: {
                return this.isSigned() ? Integer.class : Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case TIMESTAMP: 
            case DATETIME: {
                return LocalDateTime.class;
            }
            case BIGINT: {
                return this.isSigned() ? Long.class : BigInteger.class;
            }
            case MEDIUMINT: {
                return Integer.class;
            }
            case DATE: 
            case NEWDATE: {
                return LocalDate.class;
            }
            case TIME: {
                return Duration.class;
            }
            case YEAR: {
                return Short.class;
            }
            case VARCHAR: 
            case JSON: 
            case ENUM: 
            case SET: 
            case VARSTRING: 
            case STRING: {
                return this.isBinary() ? ByteBuffer.class : String.class;
            }
            case OLDDECIMAL: 
            case DECIMAL: {
                return BigDecimal.class;
            }
            case BIT: {
                return BitSet.class;
            }
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: 
            case BLOB: 
            case GEOMETRY: {
                return Blob.class;
            }
        }
        return null;
    }

    public Codec<?> getDefaultCodec(MariadbConnectionConfiguration conf) {
        switch (this.dataType) {
            case VARCHAR: 
            case JSON: 
            case ENUM: 
            case SET: 
            case VARSTRING: 
            case STRING: 
            case NULL: {
                return this.isBinary() ? ByteArrayCodec.INSTANCE : StringCodec.INSTANCE;
            }
            case TINYINT: {
                if (this.length == 1L && conf.tinyInt1isBit()) {
                    return BooleanCodec.INSTANCE;
                }
                return this.isSigned() ? ByteCodec.INSTANCE : ShortCodec.INSTANCE;
            }
            case SMALLINT: {
                return this.isSigned() ? ShortCodec.INSTANCE : IntCodec.INSTANCE;
            }
            case INTEGER: {
                return this.isSigned() ? IntCodec.INSTANCE : LongCodec.INSTANCE;
            }
            case FLOAT: {
                return FloatCodec.INSTANCE;
            }
            case DOUBLE: {
                return DoubleCodec.INSTANCE;
            }
            case TIMESTAMP: 
            case DATETIME: {
                return LocalDateTimeCodec.INSTANCE;
            }
            case BIGINT: {
                return this.isSigned() ? LongCodec.INSTANCE : BigIntegerCodec.INSTANCE;
            }
            case MEDIUMINT: {
                return IntCodec.INSTANCE;
            }
            case DATE: 
            case NEWDATE: {
                return LocalDateCodec.INSTANCE;
            }
            case TIME: {
                return DurationCodec.INSTANCE;
            }
            case YEAR: {
                return ShortCodec.INSTANCE;
            }
            case OLDDECIMAL: 
            case DECIMAL: {
                return BigDecimalCodec.INSTANCE;
            }
            case BIT: {
                if (this.length == 1L && conf.tinyInt1isBit()) {
                    return BooleanCodec.INSTANCE;
                }
                return BitSetCodec.INSTANCE;
            }
            case GEOMETRY: {
                return ByteArrayCodec.INSTANCE;
            }
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: 
            case BLOB: {
                return BlobCodec.INSTANCE;
            }
        }
        return null;
    }

    @Override
    public boolean ending() {
        return this.ending;
    }
}

