/*
 * Decompiled with CFR 0.152.
 */
package org.microshed.testing;

import java.util.HashSet;
import java.util.Optional;
import java.util.ServiceLoader;
import org.microshed.testing.internal.InternalLogger;

public interface ApplicationEnvironment {
    public static final int DEFAULT_PRIORITY = 0;
    public static final String ENV_CLASS = "MICROSHED_TEST_ENV_CLASS";

    default public boolean isAvailable() {
        return true;
    }

    default public int getPriority() {
        return 0;
    }

    public void applyConfiguration(Class<?> var1);

    public void start();

    public String getApplicationURL();

    default public boolean configureRestAssured() {
        return true;
    }

    public static class Resolver {
        private static ApplicationEnvironment loaded = null;

        private Resolver() {
        }

        public static ApplicationEnvironment load() {
            if (loaded != null) {
                return loaded;
            }
            String strategy = System.getProperty(ApplicationEnvironment.ENV_CLASS);
            if (strategy == null || strategy.isEmpty()) {
                strategy = System.getenv(ApplicationEnvironment.ENV_CLASS);
            }
            if (strategy != null && !strategy.isEmpty()) {
                Class<?> found;
                try {
                    found = Class.forName(strategy);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Unable to load the selected ApplicationEnvironment class: " + strategy, e);
                }
                if (!ApplicationEnvironment.class.isAssignableFrom(found)) {
                    throw new IllegalStateException("ApplicationEnvironment class " + strategy + " was found, but it does not implement the required interface " + ApplicationEnvironment.class);
                }
                try {
                    loaded = (ApplicationEnvironment)found.newInstance();
                    return loaded;
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalStateException("Unable to initialize " + found, e);
                }
            }
            InternalLogger LOG = InternalLogger.get(ApplicationEnvironment.class);
            HashSet envs = new HashSet();
            ServiceLoader.load(ApplicationEnvironment.class).forEach(envs::add);
            Optional<ApplicationEnvironment> selectedEnv = envs.stream().map(env -> {
                LOG.debug("Found ApplicationEnvironment " + env.getClass() + " with priority=" + env.getPriority() + ", available=" + env.isAvailable());
                return env;
            }).filter(env -> env.isAvailable()).sorted((c1, c2) -> c1.getClass().getCanonicalName().compareTo(c2.getClass().getCanonicalName())).sorted((c1, c2) -> Integer.compare(c2.getPriority(), c1.getPriority())).findFirst();
            loaded = selectedEnv.orElseThrow(() -> new IllegalStateException("No available " + ApplicationEnvironment.class.getSimpleName() + " was discovered."));
            return loaded;
        }

        public static boolean isSelected(Class<? extends ApplicationEnvironment> clazz) {
            return Resolver.load().getClass().getCanonicalName().equals(clazz.getCanonicalName());
        }
    }
}

