/*
 * Decompiled with CFR 0.152.
 */
package org.microshed.testing.jwt;

import java.security.Key;
import org.jose4j.base64url.SimplePEMEncoder;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.jwk.RsaJwkGenerator;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.lang.JoseException;

public class JwtBuilder {
    public static final String MP_JWT_PUBLIC_KEY = "mp_jwt_verify_publickey";
    public static final String MP_JWT_ISSUER = "mp_jwt_verify_issuer";
    private static final String BEGIN_PUBLIC_KEY = "-----BEGIN PUBLIC KEY-----";
    private static final String END_PUBLIC_KEY = "-----END PUBLIC KEY-----";
    private JwtClaims claims = null;
    private JsonWebSignature jws = null;
    static RsaJsonWebKey rsajwk = null;

    private static void init() {
        if (rsajwk != null) {
            return;
        }
        try {
            rsajwk = RsaJwkGenerator.generateJwk((int)2048);
            rsajwk.setKeyId("keyid");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public static String getPublicKey() {
        JwtBuilder.init();
        return JwtBuilder.pemEncode(rsajwk.getPublicKey());
    }

    private static String pemEncode(Key publicKey) {
        byte[] encoded = publicKey.getEncoded();
        return "-----BEGIN PUBLIC KEY-----\r\n" + SimplePEMEncoder.encode((byte[])encoded) + END_PUBLIC_KEY;
    }

    public static String buildJwt(String subject, String issuer, String[] claims) throws JoseException, MalformedClaimException {
        JwtBuilder builder = new JwtBuilder();
        JwtBuilder.init();
        builder.claims = new JwtClaims();
        builder.jws = new JsonWebSignature();
        builder.jws.setKeyIdHeaderValue(rsajwk.getKeyId());
        builder.jws.setAlgorithmHeaderValue("RS256");
        builder.jws.setKey((Key)rsajwk.getPrivateKey());
        if (subject != null) {
            builder.claims.setClaim("sub", (Object)subject);
            builder.claims.setClaim("upn", (Object)subject);
        }
        builder.claims.setIssuer(issuer == null ? "http://testissuer.com" : issuer);
        builder.claims.setExpirationTimeMinutesInTheFuture(60.0f);
        JwtBuilder.setClaims(builder, claims);
        if (builder.claims.getIssuedAt() == null) {
            builder.claims.setIssuedAtToNow();
        }
        builder.jws.setPayload(builder.claims.toJson());
        return builder.jws.getCompactSerialization();
    }

    private static void setClaims(JwtBuilder builder, String[] claims) throws MalformedClaimException {
        for (String claim : claims) {
            if (!claim.contains("=")) {
                throw new MalformedClaimException("Claim did not contain an equals sign (=). Each claim must be of the form 'key=value'");
            }
            int loc = claim.indexOf(61);
            String claimName = claim.substring(0, loc);
            Object claimValue = claim.substring(loc + 1);
            claimValue = JwtBuilder.handleArrays((String)claimValue);
            builder.claims.setClaim(claimName, claimValue);
        }
    }

    private static Object handleArrays(String claimValue) {
        if (!claimValue.contains(",")) {
            return claimValue;
        }
        String[] elements = claimValue.split(",");
        return elements;
    }
}

