/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.milyn.assertion.AssertArgument;
import org.milyn.edisax.EDIConfigurationException;
import org.milyn.edisax.EDIParseException;
import org.milyn.edisax.model.EDIConfigDigester;
import org.milyn.edisax.model.internal.Component;
import org.milyn.edisax.model.internal.Delimiters;
import org.milyn.edisax.model.internal.Description;
import org.milyn.edisax.model.internal.Edimap;
import org.milyn.edisax.model.internal.Field;
import org.milyn.edisax.model.internal.Import;
import org.milyn.edisax.model.internal.Segment;
import org.milyn.edisax.model.internal.SegmentGroup;
import org.milyn.io.StreamUtils;
import org.milyn.resource.URIResourceLocator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdifactModel {
    private static final URI UNSPECIFIED = URI.create("unspecified");
    private Description description;
    private String mappingConfig;
    private final URI modelURI;
    private final URI importBaseURI;
    private volatile Edimap edimap;
    private Collection<EdifactModel> associateModels;

    public EdifactModel(Edimap edimap) {
        AssertArgument.isNotNull((Object)edimap, (String)"edimap");
        this.edimap = edimap;
        this.modelURI = UNSPECIFIED;
        this.importBaseURI = URIResourceLocator.getSystemBaseURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EdifactModel(InputStream mappingModelStream) throws IOException {
        AssertArgument.isNotNull((Object)mappingModelStream, (String)"mappingModelStream");
        this.importBaseURI = URIResourceLocator.getSystemBaseURI();
        this.modelURI = UNSPECIFIED;
        try {
            this.mappingConfig = StreamUtils.readStreamAsString((InputStream)mappingModelStream);
        }
        finally {
            mappingModelStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EdifactModel(URI modelURI, URI importBaseURI, InputStream mappingModelStream) throws IOException {
        AssertArgument.isNotNull((Object)importBaseURI, (String)"importBaseURI");
        AssertArgument.isNotNull((Object)mappingModelStream, (String)"mappingModelStream");
        this.modelURI = modelURI;
        this.importBaseURI = importBaseURI;
        try {
            this.mappingConfig = StreamUtils.readStreamAsString((InputStream)mappingModelStream);
        }
        finally {
            mappingModelStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EdifactModel(URI modelURI, URI importBaseURI, Reader mappingModelStream) throws IOException {
        AssertArgument.isNotNull((Object)importBaseURI, (String)"importBaseURI");
        AssertArgument.isNotNull((Object)mappingModelStream, (String)"mappingModelStream");
        this.modelURI = modelURI;
        this.importBaseURI = importBaseURI;
        try {
            this.mappingConfig = StreamUtils.readStream((Reader)mappingModelStream);
        }
        finally {
            mappingModelStream.close();
        }
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    public Description getDescription() {
        if (this.description != null) {
            return this.description;
        }
        return this.getEdimap().getDescription();
    }

    public Edimap getEdimap() {
        if (this.edimap == null) {
            try {
                this.parseSequence();
            }
            catch (Exception e) {
                throw new EDIConfigurationException("Error parsing EDI Mapping Model [" + this.mappingConfig + "].", e);
            }
        }
        return this.edimap;
    }

    public Delimiters getDelimiters() {
        return this.getEdimap().getDelimiters();
    }

    public URI getModelURI() {
        return this.modelURI;
    }

    public void setAssociateModels(Collection<EdifactModel> associateModels) {
        this.associateModels = associateModels;
    }

    private synchronized void parseSequence() throws EDIConfigurationException, IOException, SAXException {
        if (this.edimap != null) {
            return;
        }
        DependencyTree<String> tree = new DependencyTree<String>();
        EDIConfigDigester digester = new EDIConfigDigester(this.modelURI, this.importBaseURI);
        this.edimap = digester.digestEDIConfig(new StringReader(this.mappingConfig));
        this.description = this.edimap.getDescription();
        this.importFiles(tree.getRoot(), this.edimap, tree);
    }

    private void importFiles(Node<String> parent, Edimap edimap, DependencyTree<String> tree) throws SAXException, EDIConfigurationException, IOException {
        for (Import imp : edimap.getImports()) {
            URI importUri = imp.getResourceURI();
            Map<String, Segment> importedSegments = null;
            Node<String> child = new Node<String>(importUri.toString());
            Node<String> conflictNode = tree.add(parent, child);
            if (conflictNode != null) {
                throw new EDIParseException(edimap, "Circular dependency encountered in edi-message-mapping with imported files [" + importUri + "] and [" + conflictNode.getValue() + "]");
            }
            importedSegments = this.getImportedSegments(importUri);
            if (importedSegments == null) {
                EDIConfigDigester digester = new EDIConfigDigester(importUri, URIResourceLocator.extractBaseURI((URI)importUri));
                Edimap importedEdimap = digester.digestEDIConfig(new URIResourceLocator().getResource(importUri.toString()));
                this.importFiles(child, importedEdimap, tree);
                importedSegments = this.createImportMap(importedEdimap);
            }
            this.applyImportOnSegments(edimap.getSegments().getSegments(), imp, importedSegments);
        }
        edimap.getImports().clear();
    }

    private Map<String, Segment> getImportedSegments(URI importUri) {
        if (this.associateModels != null) {
            for (EdifactModel model : this.associateModels) {
                if (!model.getModelURI().equals(importUri)) continue;
                return this.createImportMap(model.getEdimap());
            }
        }
        return null;
    }

    private void applyImportOnSegments(List<SegmentGroup> segmentGroup, Import imp, Map<String, Segment> importedSegments) throws EDIParseException {
        for (SegmentGroup segment : segmentGroup) {
            if (segment instanceof Segment) {
                this.applyImportOnSegment((Segment)segment, imp, importedSegments);
            }
            if (segment.getSegments() == null) continue;
            this.applyImportOnSegments(segment.getSegments(), imp, importedSegments);
        }
    }

    private void applyImportOnSegment(Segment segment, Import imp, Map<String, Segment> importedSegments) throws EDIParseException {
        if (segment.getNodeTypeRef() != null && segment.getNodeTypeRef().startsWith(imp.getNamespace() + ":")) {
            String key = segment.getNodeTypeRef().substring(segment.getNodeTypeRef().indexOf(58) + 1);
            Segment importedSegment = importedSegments.get(key);
            if (importedSegment == null) {
                throw new EDIParseException(this.edimap, "Referenced segment [" + key + "] does not exist in imported edi-message-mapping [" + imp.getResource() + "]");
            }
            this.insertImportedSegmentInfo(segment, importedSegment, imp.isTruncatableSegments(), imp.isTruncatableFields(), imp.isTruncatableComponents());
        }
    }

    private void insertImportedSegmentInfo(Segment segment, Segment importedSegment, Boolean truncatableSegments, Boolean truncatableFields, Boolean truncatableComponents) {
        segment.getFields().addAll(importedSegment.getFields());
        segment.setImportXmlTag(importedSegment.getXmltag());
        if (importedSegment.getSegments().size() > 0) {
            segment.getSegments().addAll(importedSegment.getSegments());
        }
        if (truncatableSegments != null) {
            segment.setTruncatable(truncatableSegments);
        }
        if (truncatableFields != null || truncatableComponents != null) {
            for (Field field : segment.getFields()) {
                field.setTruncatable(this.isTruncatable(truncatableFields, field.isTruncatable()));
                if (truncatableComponents == null) continue;
                for (Component component : field.getComponents()) {
                    component.setTruncatable(this.isTruncatable(truncatableComponents, component.isTruncatable()));
                }
            }
        }
    }

    private Map<String, Segment> createImportMap(Edimap edimap) {
        HashMap<String, Segment> result = new HashMap<String, Segment>();
        for (SegmentGroup segmentGroup : edimap.getSegments().getSegments()) {
            if (!(segmentGroup instanceof Segment)) continue;
            result.put(((Segment)segmentGroup).getSegcode(), (Segment)segmentGroup);
        }
        return result;
    }

    private Boolean isTruncatable(Boolean truncatableImporting, boolean truncatableImported) {
        Boolean result = truncatableImported;
        if (truncatableImporting != null) {
            result = truncatableImporting;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Node<T> {
        private T value;
        private Node<T> parent;
        private List<Node<T>> children = new ArrayList<Node<T>>();

        public Node(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        public Node<T> getParent() {
            return this.parent;
        }

        public void setParent(Node<T> parent) {
            this.parent = parent;
        }

        public List<Node<T>> getChildren() {
            return this.children;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DependencyTree<T> {
        Node<T> root;

        public DependencyTree() {
            this.root = new Node<Object>(null);
        }

        public Node<T> getRoot() {
            return this.root;
        }

        public Node<T> add(Node<T> parent, Node<T> child) {
            for (Node<T> node = parent; node != null; node = node.getParent()) {
                if (node == this.root || !node.getValue().equals(child.getValue())) continue;
                return node;
            }
            child.setParent(parent);
            parent.getChildren().add(child);
            return null;
        }

        public List<T> getUniqueValues() {
            ArrayList result = new ArrayList();
            return this.getUniqueValuesForNode(this.root, result);
        }

        private List<T> getUniqueValuesForNode(Node<T> node, List<T> list) {
            if (node.getValue() != null && !list.contains(node.getValue())) {
                list.add(node.getValue());
            }
            return list;
        }
    }
}

