/*
 * Decompiled with CFR 0.152.
 */
package org.milyn;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.assertion.AssertArgument;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.container.standalone.StandaloneApplicationContext;
import org.milyn.container.standalone.StandaloneExecutionContext;
import org.milyn.delivery.Filter;
import org.milyn.event.ExecutionEventListener;
import org.milyn.event.types.FilterLifecycleEvent;
import org.milyn.net.URIUtil;
import org.milyn.payload.FilterResult;
import org.milyn.payload.FilterSource;
import org.milyn.profile.Profile;
import org.milyn.profile.UnknownProfileMemberException;
import org.milyn.resource.URIResourceLocator;
import org.xml.sax.SAXException;

public class Smooks {
    private static Log logger = LogFactory.getLog(Smooks.class);
    private StandaloneApplicationContext context = new StandaloneApplicationContext();
    private ClassLoader classLoader;

    public Smooks() {
    }

    public Smooks(String resourceURI) throws IOException, SAXException {
        this();
        this.addConfigurations(resourceURI);
    }

    public Smooks(InputStream resourceConfigStream) throws IOException, SAXException {
        this();
        this.addConfigurations(resourceConfigStream);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigurations(String resourceURI) throws IOException, SAXException {
        AssertArgument.isNotNullAndNotEmpty((String)resourceURI, (String)"resourceURI");
        URIResourceLocator resourceLocator = new URIResourceLocator();
        InputStream resourceConfigStream = resourceLocator.getResource(resourceURI);
        try {
            URI resourceURIObj = new URI(resourceURI);
            this.addConfigurations(URIUtil.getParent((URI)resourceURIObj).toString(), resourceConfigStream);
        }
        catch (URISyntaxException e) {
            logger.error((Object)("Failed to load Smooks resource configuration '" + resourceURI + "'."), (Throwable)e);
        }
        finally {
            resourceConfigStream.close();
        }
    }

    public void addConfigurations(String baseURI, InputStream resourceConfigStream) throws SAXException, IOException {
        AssertArgument.isNotNullAndNotEmpty((String)baseURI, (String)"baseURI");
        AssertArgument.isNotNull((Object)resourceConfigStream, (String)"resourceConfigStream");
        try {
            this.context.getStore().registerResources(baseURI, resourceConfigStream);
        }
        catch (URISyntaxException e) {
            throw new IOException("Failed to read resource configuration. Invalid 'baseURI'.");
        }
    }

    public void addConfigurations(InputStream resourceConfigStream) throws SAXException, IOException {
        this.addConfigurations("./", resourceConfigStream);
    }

    public ExecutionContext createExecutionContext() {
        return this.createExecutionContext(Profile.DEFAULT_PROFILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionContext createExecutionContext(String targetProfile) throws UnknownProfileMemberException {
        if (this.classLoader != null) {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            try {
                StandaloneExecutionContext standaloneExecutionContext = new StandaloneExecutionContext(targetProfile, this.context);
                return standaloneExecutionContext;
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
        return new StandaloneExecutionContext(targetProfile, this.context);
    }

    public void filter(Source source) throws SmooksException {
        this.filter(source, null, this.createExecutionContext());
    }

    public void filter(Source source, Result result) throws SmooksException {
        this.filter(source, result, this.createExecutionContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(Source source, Result result, ExecutionContext executionContext) throws SmooksException {
        AssertArgument.isNotNull((Object)source, (String)"source");
        AssertArgument.isNotNull((Object)executionContext, (String)"executionContext");
        if (this.classLoader != null) {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            try {
                this._filter(source, result, executionContext);
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        } else {
            this._filter(source, result, executionContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _filter(Source source, Result result, ExecutionContext executionContext) {
        ExecutionEventListener eventListener = executionContext.getEventListener();
        try {
            Filter.setCurrentExecutionContext(executionContext);
            try {
                if (eventListener != null) {
                    eventListener.onEvent(new FilterLifecycleEvent(FilterLifecycleEvent.EventType.STARTED));
                }
                Filter messageFilter = executionContext.getDeliveryConfig().newFilter(executionContext);
                Filter.setFilter(messageFilter);
                try {
                    FilterSource.setSource(source, executionContext);
                    FilterResult.setResult(result, executionContext);
                    messageFilter.doFilter(source, result);
                }
                catch (SmooksException e) {
                    executionContext.setTerminationError(e);
                    throw e;
                }
                catch (Throwable t) {
                    executionContext.setTerminationError(t);
                    throw new SmooksException("Smooks Filtering operation failed.", t);
                }
                finally {
                    messageFilter.cleanup();
                    Filter.removeCurrentFilter();
                }
            }
            finally {
                Filter.removeCurrentExecutionContext();
            }
        }
        finally {
            if (eventListener != null) {
                eventListener.onEvent(new FilterLifecycleEvent(FilterLifecycleEvent.EventType.FINISHED));
            }
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.context;
    }

    public void close() {
        this.context.getStore().close();
    }
}

