/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.milyn.cdr.ParameterDecodeException;
import org.milyn.cdr.ParameterDecoder;

public class PropertyListParameterDecoder
extends ParameterDecoder {
    public Object decodeValue(String value) throws ParameterDecodeException {
        Properties properties = new Properties();
        try {
            properties.load(new ByteArrayInputStream(value.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new ParameterDecodeException("Unexpected error.  'UTF-8' is not a supported character encoding.", e);
        }
        catch (IOException e) {
            throw new ParameterDecodeException("Unexpected error.  Unable to read ByteArrayInputStream based stream.", e);
        }
        return properties;
    }
}

