/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.SmooksResourceConfigurationList;
import org.milyn.cdr.XMLConfigDigester;
import org.milyn.cdr.annotation.Configurator;
import org.milyn.classpath.ClasspathUtils;
import org.milyn.container.ApplicationContext;
import org.milyn.delivery.ContentHandler;
import org.milyn.delivery.ContentHandlerFactory;
import org.milyn.delivery.JavaContentHandlerFactory;
import org.milyn.delivery.UnsupportedContentHandlerTypeException;
import org.milyn.delivery.annotation.Resource;
import org.milyn.profile.ProfileSet;
import org.milyn.profile.ProfileStore;
import org.milyn.resource.ContainerResourceLocator;
import org.milyn.util.ClassUtil;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmooksResourceConfigurationStore {
    private static Log logger = LogFactory.getLog(SmooksResourceConfigurationStore.class);
    private List<SmooksResourceConfigurationList> configLists = new ArrayList<SmooksResourceConfigurationList>();
    private List<ContentHandler> allocatedHandlers = new ArrayList<ContentHandler>(){

        @Override
        public boolean add(ContentHandler contentHandler) {
            if (this.contains(contentHandler)) {
                return false;
            }
            return super.add(contentHandler);
        }
    };
    private SmooksResourceConfigurationList defaultList = new SmooksResourceConfigurationList("default");
    private ApplicationContext applicationContext;
    private Thread shutdownHook;
    private static final String CDU_CREATOR = "cdu-creator";

    public SmooksResourceConfigurationStore(ApplicationContext applicationContext) {
        if (applicationContext == null) {
            throw new IllegalArgumentException("null 'applicationContext' arg in constructor call.");
        }
        this.applicationContext = applicationContext;
        this.configLists.add(this.defaultList);
        this.registerInstalledHandlerFactories();
        this.registerInstalledResources("null-dom.cdrl");
        this.registerInstalledResources("null-sax.cdrl");
        this.registerInstalledResources("installed-param-decoders.cdrl");
        this.registerInstalledResources("installed-serializers.cdrl");
        this.addShutdownHook();
    }

    private void addShutdownHook() {
        this.shutdownHook = new Thread(){

            public void run() {
                SmooksResourceConfigurationStore.this._close();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeShutdownHook() {
        if (this.shutdownHook != null) {
            Thread thread = this.shutdownHook;
            synchronized (thread) {
                if (this.shutdownHook != null) {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                    this.shutdownHook = null;
                }
            }
        }
    }

    private void registerInstalledHandlerFactories() {
        List handlerFactories = ClassUtil.getClasses((String)"META-INF/content-handlers.inf", ContentHandlerFactory.class);
        for (Class handlerFactory : handlerFactories) {
            Resource resourceAnnotation = handlerFactory.getAnnotation(Resource.class);
            if (resourceAnnotation == null) continue;
            this.addHandlerFactoryConfig(handlerFactory, resourceAnnotation.type());
        }
        this.addHandlerFactoryConfig(JavaContentHandlerFactory.class, "class");
    }

    private void addHandlerFactoryConfig(Class handlerFactory, String type) {
        SmooksResourceConfiguration res = new SmooksResourceConfiguration(CDU_CREATOR);
        res.setTargetProfile("*");
        res.setResource(handlerFactory.getName());
        res.setParameter("restype", type);
        this.defaultList.add(res);
    }

    private void registerInstalledResources(String resourceFile) {
        InputStream resource = ClassUtil.getResourceAsStream((String)resourceFile, this.getClass());
        if (resource == null) {
            throw new IllegalStateException("Failed to load " + resourceFile + ".  Expected to be in the same package as " + this.getClass().getName());
        }
        try {
            this.registerResources(resourceFile, resource);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error processing resource file '" + resourceFile + "'.", e);
        }
    }

    public void load(BufferedReader cdrlLoadList) throws IOException {
        String uri;
        ContainerResourceLocator resLocator = this.applicationContext.getResourceLocator();
        while ((uri = cdrlLoadList.readLine()) != null) {
            if ((uri = uri.trim()).equals("") || uri.charAt(0) == '#') continue;
            try {
                InputStream resource = resLocator.getResource(uri);
                logger.info((Object)("Loading Smooks Resources from uri [" + uri + "]."));
                this.registerResources(uri, resource);
                logger.debug((Object)("[" + uri + "] Loaded."));
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)("[" + uri + "] Load failure. " + e.getMessage()), (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)("[" + uri + "] Load failure. " + e.getMessage()), (Throwable)e);
            }
            catch (SAXException e) {
                logger.error((Object)("[" + uri + "] Load failure. " + e.getMessage()), (Throwable)e);
            }
            catch (URISyntaxException e) {
                logger.error((Object)("[" + uri + "] Load failure. " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void registerResources(String baseURI, InputStream resourceConfigStream) throws SAXException, IOException, URISyntaxException {
        if (baseURI == null || baseURI.trim().equals("")) {
            throw new IllegalArgumentException("null or empty 'name' arg in method call.");
        }
        if (resourceConfigStream == null) {
            throw new IllegalArgumentException("null 'resourceConfigStream' arg in method call.");
        }
        SmooksResourceConfigurationList configList = XMLConfigDigester.digestConfig(resourceConfigStream, baseURI);
        this.configLists.add(configList);
        this.addProfileSets(configList.getProfiles());
    }

    private void addProfileSets(List<ProfileSet> profileSets) {
        if (profileSets == null) {
            return;
        }
        if (this.applicationContext instanceof ApplicationContext) {
            ProfileStore profileStore = this.applicationContext.getProfileStore();
            for (ProfileSet profileSet : profileSets) {
                profileStore.addProfileSet(profileSet);
            }
        }
    }

    public void registerResource(SmooksResourceConfiguration resourceConfig) {
        if (resourceConfig == null) {
            throw new IllegalArgumentException("null 'resourceConfig' arg in method call.");
        }
        this.defaultList.add(resourceConfig);
    }

    public void addSmooksResourceConfigurationList(SmooksResourceConfigurationList resourceList) {
        this.configLists.add(resourceList);
    }

    public Iterator<SmooksResourceConfigurationList> getSmooksResourceConfigurationLists() {
        return this.configLists.iterator();
    }

    public SmooksResourceConfiguration[] getSmooksResourceConfigurations(ProfileSet profileSet) {
        Vector<SmooksResourceConfiguration> allSmooksResourceConfigurationsColl = new Vector<SmooksResourceConfiguration>();
        for (int i = 0; i < this.configLists.size(); ++i) {
            SmooksResourceConfigurationList list = this.configLists.get(i);
            SmooksResourceConfiguration[] resourceConfigs = list.getTargetConfigurations(profileSet);
            allSmooksResourceConfigurationsColl.addAll(Arrays.asList(resourceConfigs));
        }
        SmooksResourceConfiguration[] allSmooksResourceConfigurations = new SmooksResourceConfiguration[allSmooksResourceConfigurationsColl.size()];
        allSmooksResourceConfigurationsColl.toArray(allSmooksResourceConfigurations);
        return allSmooksResourceConfigurations;
    }

    public Object getObject(SmooksResourceConfiguration resourceConfig) {
        Class classRuntime;
        Object object = null;
        String className = ClasspathUtils.toClassName((String)resourceConfig.getResource());
        try {
            classRuntime = ClassUtil.forName((String)className, this.getClass());
        }
        catch (ClassNotFoundException e) {
            IllegalStateException state = new IllegalStateException("Error loading Java class: " + className);
            state.initCause(e);
            throw state;
        }
        try {
            Constructor constructor = classRuntime.getConstructor(SmooksResourceConfiguration.class);
            object = constructor.newInstance(resourceConfig);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            IllegalStateException state = new IllegalStateException("Error loading Java class: " + className);
            state.initCause(e);
            throw state;
        }
        if (object == null) {
            try {
                object = classRuntime.newInstance();
            }
            catch (Exception e) {
                IllegalStateException state = new IllegalStateException("Java class " + className + " must contain a default constructor if it does not contain a constructor that takes an instance of " + SmooksResourceConfiguration.class.getName() + ".");
                state.initCause(e);
                throw state;
            }
        }
        if (object instanceof ContentHandler) {
            Configurator.configure(object, resourceConfig, this.applicationContext);
            this.allocatedHandlers.add(object);
        }
        return object;
    }

    public List<ContentHandler> getAllocatedHandlers() {
        return this.allocatedHandlers;
    }

    public ContentHandlerFactory getContentHandlerFactory(String type) throws UnsupportedContentHandlerTypeException {
        if (type == null) {
            throw new IllegalArgumentException("null 'resourceExtension' arg in method call.");
        }
        for (int i = 0; i < this.configLists.size(); ++i) {
            SmooksResourceConfigurationList list = this.configLists.get(i);
            for (int ii = 0; ii < list.size(); ++ii) {
                SmooksResourceConfiguration config = list.get(ii);
                String selector = config.getSelector();
                if (!CDU_CREATOR.equals(selector) || !type.equalsIgnoreCase(config.getStringParameter("restype"))) continue;
                return (ContentHandlerFactory)this.getObject(config);
            }
        }
        throw new UnsupportedContentHandlerTypeException(type);
    }

    public void close() {
        this._close();
        this.removeShutdownHook();
    }

    private void _close() {
        if (this.allocatedHandlers != null) {
            logger.debug((Object)"Uninitializing all ContentHandler instances allocated through this store.");
            for (ContentHandler deliveryUnit : this.allocatedHandlers) {
                try {
                    logger.debug((Object)("Uninitializing ContentHandler instance: " + deliveryUnit.getClass().getName()));
                    Configurator.uninitialise(deliveryUnit);
                }
                catch (Throwable throwable) {
                    logger.error((Object)("Error uninitializing " + deliveryUnit.getClass().getName() + "."), throwable);
                }
            }
            this.allocatedHandlers = null;
        }
    }
}

