/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.Config;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ApplicationContext;
import org.milyn.delivery.ContentHandler;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.annotation.Uninitialize;
import org.milyn.javabean.DataDecodeException;
import org.milyn.javabean.DataDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configurator {
    private static Log logger = LogFactory.getLog(Configurator.class);

    public static <U extends ContentHandler> U configure(U instance, SmooksResourceConfiguration config, ApplicationContext appContext) throws SmooksConfigurationException {
        AssertArgument.isNotNull((Object)appContext, (String)"appContext");
        Configurator.processFieldContextAnnotation(instance, appContext);
        return Configurator.configure(instance, config);
    }

    public static <U extends ContentHandler> U configure(U instance, SmooksResourceConfiguration config) throws SmooksConfigurationException {
        AssertArgument.isNotNull(instance, (String)"instance");
        AssertArgument.isNotNull((Object)config, (String)"config");
        Configurator.processFieldConfigAnnotations(instance, config);
        Configurator.processMethodConfigAnnotations(instance, config);
        Configurator.setConfiguration(instance, config);
        Configurator.initialise(instance);
        return instance;
    }

    private static <U extends ContentHandler> void processFieldContextAnnotation(U instance, ApplicationContext appContext) {
        Configurator.processFieldContextAnnotation(instance.getClass(), instance, appContext);
    }

    private static <U extends ContentHandler> void processFieldContextAnnotation(Class contentHandlerClass, U instance, ApplicationContext appContext) {
        Field[] fields = contentHandlerClass.getDeclaredFields();
        Class superClass = contentHandlerClass.getSuperclass();
        if (superClass != null && ContentHandler.class.isAssignableFrom(superClass)) {
            Configurator.processFieldContextAnnotation(superClass, instance, appContext);
        }
        for (Field field : fields) {
            AppContext appContextAnnotation = field.getAnnotation(AppContext.class);
            if (appContextAnnotation == null) continue;
            try {
                Configurator.setField(field, instance, appContext);
            }
            catch (IllegalAccessException e) {
                throw new SmooksConfigurationException("Failed to set ApplicationContext value on '" + Configurator.getLongMemberName(field) + "'.", e);
            }
        }
    }

    private static <U extends ContentHandler> void processFieldConfigAnnotations(U instance, SmooksResourceConfiguration config) {
        Class<?> contentHandlerClass = instance.getClass();
        Configurator.processFieldConfigAnnotations(contentHandlerClass, instance, config);
    }

    private static <U extends ContentHandler> void processFieldConfigAnnotations(Class contentHandlerClass, U instance, SmooksResourceConfiguration config) {
        Field[] fields = contentHandlerClass.getDeclaredFields();
        Class superClass = contentHandlerClass.getSuperclass();
        if (superClass != null) {
            Configurator.processFieldConfigAnnotations(superClass, instance, config);
        }
        for (Field field : fields) {
            Config configAnnotation;
            ConfigParam configParamAnnotation = field.getAnnotation(ConfigParam.class);
            if (configParamAnnotation != null) {
                Configurator.applyConfigParam(configParamAnnotation, field, field.getType(), instance, config);
            }
            if ((configAnnotation = field.getAnnotation(Config.class)) == null) continue;
            if (configParamAnnotation != null) {
                throw new SmooksConfigurationException("Invalid Smooks configuration annotations on Field '" + Configurator.getLongMemberName(field) + "'.  Field should not specify both @ConfigParam and @Config annotations.");
            }
            Configurator.applyConfig(field, instance, config);
        }
    }

    private static <U extends ContentHandler> void processMethodConfigAnnotations(U instance, SmooksResourceConfiguration config) {
        Method[] methods;
        for (Method method : methods = instance.getClass().getMethods()) {
            ConfigParam configParamAnnotation = method.getAnnotation(ConfigParam.class);
            if (configParamAnnotation == null) continue;
            Class<?>[] params = method.getParameterTypes();
            if (params.length == 1) {
                Configurator.applyConfigParam(configParamAnnotation, method, params[0], instance, config);
                continue;
            }
            throw new SmooksConfigurationException("Method '" + Configurator.getLongMemberName(method) + "' defines a @ConfigParam, yet it specifies more than a single paramater.");
        }
    }

    private static void applyConfigParam(ConfigParam configParam, Member member, Class type, ContentHandler instance, SmooksResourceConfiguration config) throws SmooksConfigurationException {
        String paramValue;
        String name = configParam.name();
        if ("##NULL".equals(name)) {
            if (member instanceof Method) {
                name = Configurator.getPropertyName((Method)member);
                if (name == null) {
                    throw new SmooksConfigurationException("Unable to determine the property name associated with '" + Configurator.getLongMemberName(member) + "'. " + "Setter methods that specify the @ConfigParam annotation " + "must either follow the Javabean naming convention ('setX' for propert 'x'), or specify the " + "propery name via the 'name' parameter on the @ConfigParam annotation.");
                }
            } else {
                name = member.getName();
            }
        }
        if ((paramValue = config.getStringParameter(name)) == null) {
            paramValue = configParam.defaultVal();
            if ("##NULL".equals(paramValue)) {
                String[] choices = configParam.choice();
                Configurator.assertValidChoice(choices, name, "##NULL");
                Configurator.setMember(member, instance, null);
                return;
            }
            if ("org.milyn.cdr.annotation.AnnotationConstants##UNASSIGNED".equals(paramValue)) {
                paramValue = null;
            }
        }
        if (paramValue != null) {
            DataDecoder decoder;
            String[] choices = configParam.choice();
            Configurator.assertValidChoice(choices, name, paramValue);
            Class<? extends DataDecoder> decoderClass = configParam.decoder();
            if (decoderClass.isAssignableFrom(DataDecoder.class)) {
                decoder = DataDecoder.Factory.create(type);
                if (decoder == null) {
                    throw new SmooksConfigurationException("ContentHandler class member '" + Configurator.getLongMemberName(member) + "' must define a decoder through it's @ConfigParam annotation.  Unable to automatically determine DataDecoder from member type.");
                }
            } else {
                try {
                    decoder = decoderClass.newInstance();
                }
                catch (InstantiationException e) {
                    throw new SmooksConfigurationException("Failed to create DataDecoder instance from class '" + decoderClass.getName() + "'.  Make sure the DataDecoder implementation has a public default constructor.", e);
                }
                catch (IllegalAccessException e) {
                    throw new SmooksConfigurationException("Failed to create DataDecoder instance from class '" + decoderClass.getName() + "'.  Make sure the DataDecoder implementation has a public default constructor.", e);
                }
            }
            try {
                Configurator.setMember(member, instance, decoder.decode(paramValue));
            }
            catch (DataDecodeException e) {
                throw new SmooksConfigurationException("Failed to set paramater configuration value on '" + Configurator.getLongMemberName(member) + "'.", e);
            }
        }
        if (configParam.use() == ConfigParam.Use.REQUIRED) {
            throw new SmooksConfigurationException("<param> '" + name + "' not specified on resource configuration:\n" + config);
        }
    }

    private static void assertValidChoice(String[] choices, String name, String paramValue) throws SmooksConfigurationException {
        if (choices == null || choices.length == 0) {
            throw new RuntimeException("Unexpected annotation default choice value.  Should not be null or empty.  Code may have changed incompatibly.");
        }
        if (choices.length == 1 && "##NULL".equals(choices[0])) {
            return;
        }
        for (String choice : choices) {
            if (!paramValue.equals(choice)) continue;
            return;
        }
        throw new SmooksConfigurationException("Value '" + paramValue + "' for paramater '" + name + "' is invalid.  Valid choices for this paramater are: " + Arrays.asList(choices));
    }

    private static void applyConfig(Field field, ContentHandler instance, SmooksResourceConfiguration config) {
        try {
            Configurator.setField(field, instance, config);
        }
        catch (IllegalAccessException e) {
            throw new SmooksConfigurationException("Failed to set paramater configuration value on '" + Configurator.getLongMemberName(field) + "'.", e);
        }
    }

    private static void setConfiguration(ContentHandler instance, SmooksResourceConfiguration config) {
        try {
            Method setConfigurationMethod = instance.getClass().getMethod("setConfiguration", SmooksResourceConfiguration.class);
            setConfigurationMethod.invoke((Object)instance, config);
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
            throw new SmooksConfigurationException("Error invoking 'setConfiguration' method on class '" + instance.getClass().getName() + "'.  This class must be public.  Alternatively, use the @Config annotation on a class field.", e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof SmooksConfigurationException) {
                throw (SmooksConfigurationException)e.getTargetException();
            }
            Throwable cause = e.getTargetException();
            throw new SmooksConfigurationException("Error invoking 'setConfiguration' method on class '" + instance.getClass().getName() + "'.", cause != null ? cause : e);
        }
    }

    private static String getLongMemberName(Member field) {
        return field.getDeclaringClass().getName() + "#" + field.getName();
    }

    private static void setMember(Member member, ContentHandler instance, Object value) {
        block5: {
            try {
                if (member instanceof Field) {
                    Configurator.setField((Field)member, instance, value);
                    break block5;
                }
                try {
                    Configurator.setMethod((Method)member, instance, value);
                }
                catch (InvocationTargetException e) {
                    throw new SmooksConfigurationException("Failed to set paramater configuration value on '" + Configurator.getLongMemberName(member) + "'.", e.getTargetException());
                }
            }
            catch (IllegalAccessException e) {
                throw new SmooksConfigurationException("Failed to set paramater configuration value on '" + Configurator.getLongMemberName(member) + "'.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setField(Field field, ContentHandler instance, Object value) throws IllegalAccessException {
        boolean isAccessible = field.isAccessible();
        if (!isAccessible) {
            field.setAccessible(true);
        }
        try {
            field.set(instance, value);
        }
        finally {
            field.setAccessible(isAccessible);
        }
    }

    private static void setMethod(Method method, ContentHandler instance, Object value) throws IllegalAccessException, InvocationTargetException {
        method.invoke((Object)instance, value);
    }

    private static <U extends ContentHandler> void initialise(U instance) {
        Configurator.invoke(instance, Initialize.class);
    }

    public static <U extends ContentHandler> void uninitialise(U instance) {
        Configurator.invoke(instance, Uninitialize.class);
    }

    private static <U extends ContentHandler> void invoke(U instance, Class<? extends Annotation> annotation) {
        Method[] methods;
        for (Method method : methods = instance.getClass().getMethods()) {
            if (method.getAnnotation(annotation) == null) continue;
            if (method.getParameterTypes().length == 0) {
                try {
                    method.invoke(instance, new Object[0]);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new SmooksConfigurationException("Error invoking @" + annotation.getSimpleName() + " method '" + method.getName() + "' on class '" + instance.getClass().getName() + "'.", e);
                }
                catch (InvocationTargetException e) {
                    throw new SmooksConfigurationException("Error invoking @" + annotation.getSimpleName() + " method '" + method.getName() + "' on class '" + instance.getClass().getName() + "'.", e.getTargetException());
                }
            }
            logger.warn((Object)("Method '" + Configurator.getLongMemberName(method) + "' defines an @" + annotation.getSimpleName() + " annotation on a paramaterized method.  This is not allowed!"));
        }
    }

    private static String getPropertyName(Method method) {
        if (!method.getName().startsWith("set")) {
            return null;
        }
        StringBuffer methodName = new StringBuffer(method.getName());
        if (methodName.length() < 4) {
            return null;
        }
        methodName.delete(0, 3);
        methodName.setCharAt(0, Character.toLowerCase(methodName.charAt(0)));
        return methodName.toString();
    }
}

