/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr.extension;

import java.util.EmptyStackException;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.cdr.extension.ExtensionContext;
import org.milyn.cdr.extension.MapToResourceConfigFromText;
import org.milyn.cdr.extension.ResourceConfigUtil;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.dom.DOMVisitBefore;
import org.w3c.dom.Element;

public class MapToResourceConfigFromParentConfig
implements DOMVisitBefore {
    private static Log logger = LogFactory.getLog(MapToResourceConfigFromText.class);
    @ConfigParam(defaultVal="-1")
    private int parentRelIndex;
    @ConfigParam
    private String mapFrom;
    @ConfigParam
    private String mapTo;
    @ConfigParam(defaultVal="##NULL")
    private String defaultValue;

    @Initialize
    public void initialize() throws SmooksConfigurationException {
        if (this.parentRelIndex >= 0) {
            throw new SmooksConfigurationException("param 'parentRelIndex' value must be negative.  Value is '" + this.parentRelIndex + "'.");
        }
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        SmooksResourceConfiguration parentConfig;
        SmooksResourceConfiguration currentConfig;
        Stack<SmooksResourceConfiguration> resourceStack = ExtensionContext.getExtensionContext(executionContext).getResourceStack();
        String actualMapTo = this.mapTo;
        if (actualMapTo == null) {
            actualMapTo = this.mapFrom;
        }
        try {
            currentConfig = resourceStack.peek();
        }
        catch (EmptyStackException e) {
            throw new SmooksException("No SmooksResourceConfiguration available in ExtensionContext stack.  Unable to set SmooksResourceConfiguration property '" + actualMapTo + "' with element text value.");
        }
        try {
            parentConfig = (SmooksResourceConfiguration)resourceStack.get(resourceStack.size() - 1 + this.parentRelIndex);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SmooksException("No Parent SmooksResourceConfiguration available in ExtensionContext stack at relative index '" + this.parentRelIndex + "'.  Unable to set SmooksResourceConfiguration property '" + actualMapTo + "' with value of '" + this.mapFrom + "' from parent configuration.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Mapping property '" + this.mapFrom + "' on parent resource configuration to property'" + actualMapTo + "'."));
        }
        ResourceConfigUtil.mapProperty(parentConfig, this.mapFrom, currentConfig, actualMapTo, this.defaultValue, executionContext);
    }
}

