/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.container.plugin;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.milyn.Smooks;
import org.milyn.SmooksException;
import org.milyn.assertion.AssertArgument;
import org.milyn.container.ExecutionContext;
import org.milyn.container.plugin.ResultFactory;
import org.milyn.container.plugin.ResultType;
import org.milyn.container.plugin.SourceFactory;
import org.milyn.container.plugin.SourceResult;
import org.milyn.payload.ByteResult;
import org.milyn.payload.JavaResult;
import org.milyn.payload.StringResult;

public class PayloadProcessor {
    private Smooks smooks;
    private ResultType resultType;
    private String javaResultBeanId;

    public PayloadProcessor(Smooks smooks, ResultType resultType) {
        AssertArgument.isNotNull((Object)smooks, (String)"smooks");
        AssertArgument.isNotNull((Object)((Object)resultType), (String)"resultType");
        this.smooks = smooks;
        this.resultType = resultType;
    }

    public void setJavaResultBeanId(String javaResultBeanId) {
        AssertArgument.isNotNullAndNotEmpty((String)javaResultBeanId, (String)"javaResultBeanId");
        this.javaResultBeanId = javaResultBeanId;
    }

    public final Object process(Object payload, ExecutionContext executionContext) throws SmooksException {
        Result result;
        Source source;
        AssertArgument.isNotNull((Object)payload, (String)"payload");
        if (payload instanceof SourceResult) {
            SourceResult sourceResult = (SourceResult)payload;
            source = sourceResult.getSource();
            result = sourceResult.getResult();
        } else {
            source = SourceFactory.getInstance().createSource(payload);
            result = ResultFactory.getInstance().createResult(this.resultType);
        }
        this.smooks.filter(source, result, executionContext);
        if (result instanceof JavaResult) {
            if (this.javaResultBeanId != null) {
                return ((JavaResult)result).getResultMap().get(this.javaResultBeanId);
            }
            return ((JavaResult)result).getResultMap();
        }
        if (result instanceof StringResult) {
            return ((StringResult)result).getResult();
        }
        if (result instanceof ByteResult) {
            return ((ByteResult)result).getResult();
        }
        return result;
    }
}

