/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.milyn.SmooksException;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.ExecutionLifecycleCleanable;
import org.milyn.delivery.dom.DOMElementVisitor;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXElementVisitor;
import org.milyn.delivery.sax.SAXText;
import org.w3c.dom.Element;

public abstract class AbstractDataSource
implements SAXElementVisitor,
DOMElementVisitor,
ExecutionLifecycleCleanable {
    private static final String DS_CONTEXT_KEY_PREFIX = AbstractDataSource.class.getName() + "#datasource:";
    private static final String CONNECTION_CONTEXT_KEY_PREFIX = AbstractDataSource.class.getName() + "#connection:";

    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.bind(executionContext);
    }

    public void onChildText(SAXElement element, SAXText childText, ExecutionContext executionContext) throws SmooksException, IOException {
    }

    public void onChildElement(SAXElement element, SAXElement childElement, ExecutionContext executionContext) throws SmooksException, IOException {
    }

    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.unbind(executionContext);
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.bind(executionContext);
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        this.unbind(executionContext);
    }

    private void bind(ExecutionContext executionContext) {
        executionContext.setAttribute(DS_CONTEXT_KEY_PREFIX + this.getName(), this);
    }

    public void executeExecutionLifecycleCleanup(ExecutionContext executionContext) {
        this.unbind(executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbind(ExecutionContext executionContext) {
        block11: {
            try {
                Connection connection = (Connection)executionContext.getAttribute(CONNECTION_CONTEXT_KEY_PREFIX + this.getName());
                if (connection == null) break block11;
                try {
                    if (!this.isAutoCommit()) {
                        if (executionContext.getTerminationError() == null) {
                            connection.commit();
                        } else {
                            connection.rollback();
                        }
                    }
                }
                finally {
                    executionContext.removeAttribute(CONNECTION_CONTEXT_KEY_PREFIX + this.getName());
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new SmooksException("Unable to unbind DataSource '" + this.getName() + "'.");
            }
            finally {
                executionContext.removeAttribute(DS_CONTEXT_KEY_PREFIX + this.getName());
            }
        }
    }

    public static Connection getConnection(String dataSourceName, ExecutionContext executionContext) throws SmooksException {
        Connection connection = (Connection)executionContext.getAttribute(CONNECTION_CONTEXT_KEY_PREFIX + dataSourceName);
        if (connection == null) {
            AbstractDataSource datasource = (AbstractDataSource)executionContext.getAttribute(DS_CONTEXT_KEY_PREFIX + dataSourceName);
            if (datasource == null) {
                throw new SmooksException("DataSource '" + dataSourceName + "' not bound to context.  Configure an '" + AbstractDataSource.class.getName() + "' implementation and target it at '$document'.");
            }
            try {
                connection = datasource.getConnection();
                connection.setAutoCommit(datasource.isAutoCommit());
            }
            catch (SQLException e) {
                throw new SmooksException("Unable to open connection to dataSource '" + dataSourceName + "'.", e);
            }
            executionContext.setAttribute(CONNECTION_CONTEXT_KEY_PREFIX + dataSourceName, connection);
        }
        return connection;
    }

    public abstract String getName();

    public abstract Connection getConnection() throws SQLException;

    public abstract boolean isAutoCommit();
}

