/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.db;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.db.AbstractDataSource;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.event.report.annotation.VisitAfterReport;
import org.milyn.event.report.annotation.VisitBeforeReport;
import org.milyn.util.ClassUtil;

@VisitBeforeReport(summary="Bind DirectDataSource <b>${resource.parameters.datasource}</b> to ExecutionContext.", detailTemplate="reporting/DirectDataSource_before.html")
@VisitAfterReport(summary="Cleaning up DirectDataSource <b>${resource.parameters.datasource}</b>. Includes performing commit/rollback etc.", detailTemplate="reporting/DirectDataSource_after.html")
public class DirectDataSource
extends AbstractDataSource {
    @ConfigParam(name="datasource")
    private String datasourceName;
    @ConfigParam
    private boolean autoCommit;
    @ConfigParam
    private String driver;
    @ConfigParam
    private String url;
    @ConfigParam
    private String username;
    @ConfigParam
    private String password;

    public String getName() {
        return this.datasourceName;
    }

    @Initialize
    public void registerDriver() throws SQLException {
        Driver driverInstance;
        try {
            driverInstance = (Driver)ClassUtil.forName((String)this.driver, this.getClass()).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("Failed to register JDBC driver '" + this.driver + "'.  Driver class not available on classpath.");
        }
        catch (Exception e) {
            throw new SQLException("Failed to register JDBC driver '" + this.driver + "'.  Unable to create instance of driver class.");
        }
        DriverManager.registerDriver(driverInstance);
    }

    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.url, this.username, this.password);
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }
}

