/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.db;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.db.AbstractDataSource;
import org.milyn.delivery.annotation.Initialize;

public class JndiDataSource
extends AbstractDataSource {
    @ConfigParam(name="datasource")
    private String datasourceName;
    @ConfigParam
    private boolean autoCommit;
    private DataSource datasource;

    @Initialize
    public void intitialize() {
        InitialContext context = null;
        try {
            context = new InitialContext();
            this.datasource = (DataSource)context.lookup(this.datasourceName);
        }
        catch (NamingException e) {
            throw new SmooksConfigurationException("DataSource lookup failed for DataSource '" + this.datasourceName + "'.  Make sure you have the DataSource descriptor deployed and that the JNDI names match.", e);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException e) {
                    throw new SmooksConfigurationException("Error closing Naming Context after looking up DataSource '" + this.datasourceName + "'.", e);
                }
            }
        }
    }

    public String getName() {
        return this.datasourceName;
    }

    public Connection getConnection() throws SQLException {
        return this.datasource.getConnection();
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }
}

