/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery;

import java.util.List;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.Parameter;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.annotation.Configurator;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.ContentDeliveryConfig;
import org.milyn.delivery.java.JavaXMLReader;
import org.milyn.delivery.java.XStreamXMLReader;
import org.milyn.payload.FilterSource;
import org.milyn.payload.JavaSource;
import org.milyn.util.ClassUtil;
import org.milyn.xml.NullSourceXMLReader;
import org.milyn.xml.SmooksXMLReader;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.XMLReaderFactory;

public class AbstractParser {
    private static Log logger = LogFactory.getLog(AbstractParser.class);
    private ExecutionContext execContext;
    private SmooksResourceConfiguration saxDriverConfig;

    public AbstractParser(ExecutionContext execContext, SmooksResourceConfiguration saxDriverConfig) {
        AssertArgument.isNotNull((Object)execContext, (String)"execContext");
        this.execContext = execContext;
        this.saxDriverConfig = saxDriverConfig;
    }

    public AbstractParser(ExecutionContext execContext) {
        this(execContext, AbstractParser.getSAXParserConfiguration(execContext.getDeliveryConfig()));
    }

    protected ExecutionContext getExecContext() {
        return this.execContext;
    }

    protected SmooksResourceConfiguration getSaxDriverConfig() {
        return this.saxDriverConfig;
    }

    public static SmooksResourceConfiguration getSAXParserConfiguration(ContentDeliveryConfig deliveryConfig) {
        if (deliveryConfig == null) {
            throw new IllegalArgumentException("null 'deliveryConfig' arg in method call.");
        }
        SmooksResourceConfiguration saxDriverConfig = null;
        List<SmooksResourceConfiguration> saxConfigs = deliveryConfig.getSmooksResourceConfigurations("org.xml.sax.driver");
        if (saxConfigs != null && !saxConfigs.isEmpty()) {
            saxDriverConfig = saxConfigs.get(0);
        }
        return saxDriverConfig;
    }

    protected XMLReader createXMLReader(DefaultHandler2 handler) throws SAXException {
        XMLReader reader;
        ExecutionContext execContext = this.getExecContext();
        Source source = FilterSource.getSource(execContext);
        if (this.saxDriverConfig != null) {
            String className = this.saxDriverConfig.getResource();
            reader = className != null ? XMLReaderFactory.createXMLReader(className) : XMLReaderFactory.createXMLReader();
            if (reader instanceof SmooksXMLReader) {
                Configurator.configure((SmooksXMLReader)reader, this.saxDriverConfig, execContext.getContext());
                ((SmooksXMLReader)reader).setExecutionContext(execContext);
            }
        } else {
            JavaSource javaSource;
            reader = source instanceof JavaSource ? ((javaSource = (JavaSource)source).getSourceObjects() != null ? new XStreamXMLReader() : new NullSourceXMLReader()) : XMLReaderFactory.createXMLReader();
        }
        if (reader instanceof JavaXMLReader) {
            if (!(source instanceof JavaSource)) {
                throw new SAXException("A " + JavaSource.class.getName() + " source must be supplied for " + JavaXMLReader.class.getName() + " implementations.");
            }
            ((JavaXMLReader)reader).setSourceObjects(((JavaSource)source).getSourceObjects());
        }
        reader.setContentHandler(handler);
        try {
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
        }
        catch (SAXNotRecognizedException e) {
            logger.debug((Object)("XMLReader property 'http://xml.org/sax/properties/lexical-handler' not recognized by XMLReader '" + reader.getClass().getName() + "'."));
        }
        reader.setFeature("http://xml.org/sax/features/namespaces", true);
        reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        this.setHandlers(reader);
        this.setFeatures(reader);
        return reader;
    }

    private void setHandlers(XMLReader reader) throws SAXException {
        List handlers;
        if (this.saxDriverConfig != null && (handlers = this.saxDriverConfig.getParameters("sax-handler")) != null) {
            for (Parameter handler : handlers) {
                Object handlerObj = this.createHandler(handler.getValue());
                if (handlerObj instanceof EntityResolver) {
                    reader.setEntityResolver((EntityResolver)handlerObj);
                }
                if (handlerObj instanceof DTDHandler) {
                    reader.setDTDHandler((DTDHandler)handlerObj);
                }
                if (!(handlerObj instanceof ErrorHandler)) continue;
                reader.setErrorHandler((ErrorHandler)handlerObj);
            }
        }
    }

    private Object createHandler(String handlerName) throws SAXException {
        try {
            Class handlerClass = ClassUtil.forName((String)handlerName, this.getClass());
            return handlerClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new SAXException("Failed to create SAX Handler '" + handlerName + "'.", e);
        }
        catch (IllegalAccessException e) {
            throw new SAXException("Failed to create SAX Handler '" + handlerName + "'.", e);
        }
        catch (InstantiationException e) {
            throw new SAXException("Failed to create SAX Handler '" + handlerName + "'.", e);
        }
    }

    private void setFeatures(XMLReader reader) throws SAXNotSupportedException, SAXNotRecognizedException {
        try {
            reader.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", true);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (this.saxDriverConfig != null) {
            List features = this.saxDriverConfig.getParameters("feature-on");
            if (features != null) {
                for (Parameter feature : features) {
                    reader.setFeature(feature.getValue(), true);
                }
            }
            if ((features = this.saxDriverConfig.getParameters("feature-off")) != null) {
                for (Parameter feature : features) {
                    reader.setFeature(feature.getValue(), false);
                }
            }
        }
    }
}

