/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.Parameter;
import org.milyn.cdr.ParameterAccessor;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.SmooksResourceConfigurationSortComparator;
import org.milyn.cdr.SmooksResourceConfigurationStore;
import org.milyn.container.ApplicationContext;
import org.milyn.delivery.ConfigurationExpander;
import org.milyn.delivery.ContentDeliveryConfig;
import org.milyn.delivery.ContentHandler;
import org.milyn.delivery.ContentHandlerConfigMap;
import org.milyn.delivery.ContentHandlerConfigMapTable;
import org.milyn.delivery.ContentHandlerFactory;
import org.milyn.delivery.Filter;
import org.milyn.delivery.JavaContentHandlerFactory;
import org.milyn.delivery.UnsupportedContentHandlerTypeException;
import org.milyn.delivery.annotation.VisitAfterIf;
import org.milyn.delivery.annotation.VisitBeforeIf;
import org.milyn.delivery.dom.DOMContentDeliveryConfig;
import org.milyn.delivery.dom.DOMVisitAfter;
import org.milyn.delivery.dom.DOMVisitBefore;
import org.milyn.delivery.dom.Phase;
import org.milyn.delivery.dom.VisitPhase;
import org.milyn.delivery.dom.serialize.SerializationUnit;
import org.milyn.delivery.sax.SAXContentDeliveryConfig;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.delivery.sax.SAXVisitBefore;
import org.milyn.dtd.DTDStore;
import org.milyn.event.types.ConfigBuilderEvent;
import org.milyn.expression.MVELExpressionEvaluator;
import org.milyn.profile.ProfileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentDeliveryConfigBuilder {
    private static Log logger = LogFactory.getLog(ContentDeliveryConfigBuilder.class);
    private static final String DELIVERY_CONFIG_TABLE_CTX_KEY = ContentDeliveryConfig.class.getName() + "#configTable";
    private ProfileSet profileSet;
    private ApplicationContext applicationContext;
    private static final String ELCSPEC_PREFIX = "elcspec:";
    private List<SmooksResourceConfiguration> resourceConfigsList = new ArrayList<SmooksResourceConfiguration>();
    private LinkedHashMap<String, List<SmooksResourceConfiguration>> resourceConfigTable = new LinkedHashMap();
    private ContentHandlerConfigMapTable<DOMVisitBefore> assemblyVisitBefores = new ContentHandlerConfigMapTable();
    private ContentHandlerConfigMapTable<DOMVisitAfter> assemblyVisitAfters = new ContentHandlerConfigMapTable();
    private ContentHandlerConfigMapTable<DOMVisitBefore> processingVisitBefores = new ContentHandlerConfigMapTable();
    private ContentHandlerConfigMapTable<DOMVisitAfter> processingVisitAfters = new ContentHandlerConfigMapTable();
    private ContentHandlerConfigMapTable<SerializationUnit> serializationUnitTable = new ContentHandlerConfigMapTable();
    private ContentHandlerConfigMapTable<SAXVisitBefore> saxVisitBefores = new ContentHandlerConfigMapTable();
    private ContentHandlerConfigMapTable<SAXVisitAfter> saxVisitAfters = new ContentHandlerConfigMapTable();
    private List<ConfigBuilderEvent> configBuilderEvents = new ArrayList<ConfigBuilderEvent>();
    private DTDStore.DTDObjectContainer dtd;
    private int elementHandlerCount = 0;
    private int saxElementHandlerCount = 0;
    private int domElementHandlerCount = 0;

    private ContentDeliveryConfigBuilder(ProfileSet profileSet, ApplicationContext applicationContext) {
        this.profileSet = profileSet;
        this.applicationContext = applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static ContentDeliveryConfig getConfig(ProfileSet profileSet, ApplicationContext applicationContext) {
        ContentDeliveryConfig config;
        Class<ContentDeliveryConfigBuilder> clazz;
        if (profileSet == null) {
            throw new IllegalArgumentException("null 'profileSet' arg passed in method call.");
        }
        if (applicationContext == null) {
            throw new IllegalArgumentException("null 'applicationContext' arg passed in method call.");
        }
        LinkedHashMap<String, ContentDeliveryConfig> configTable = ContentDeliveryConfigBuilder.getDeliveryConfigTable(applicationContext);
        if (configTable == null) {
            clazz = ContentDeliveryConfigBuilder.class;
            // MONITORENTER : org.milyn.delivery.ContentDeliveryConfigBuilder.class
            configTable = ContentDeliveryConfigBuilder.getDeliveryConfigTable(applicationContext);
            if (configTable == null) {
                configTable = new LinkedHashMap();
                applicationContext.setAttribute(DELIVERY_CONFIG_TABLE_CTX_KEY, configTable);
            }
            // MONITOREXIT : clazz
        }
        if ((config = configTable.get(profileSet.getBaseProfile())) != null) return config;
        clazz = ContentDeliveryConfigBuilder.class;
        // MONITORENTER : org.milyn.delivery.ContentDeliveryConfigBuilder.class
        config = configTable.get(profileSet.getBaseProfile());
        if (config == null) {
            ContentDeliveryConfigBuilder configBuilder = new ContentDeliveryConfigBuilder(profileSet, applicationContext);
            configBuilder.load();
            config = configBuilder.createConfig();
            configTable.put(profileSet.getBaseProfile(), config);
        }
        // MONITOREXIT : clazz
        return config;
    }

    private ContentDeliveryConfig createConfig() {
        Filter.StreamFilterType filterType = this.getStreamFilterType();
        this.configBuilderEvents.add(new ConfigBuilderEvent("SAX/DOM support characteristics of the Resource Configuration map:\n" + this.getResourceFilterCharacteristics()));
        this.configBuilderEvents.add(new ConfigBuilderEvent("Using Stream Filter Type: " + (Object)((Object)filterType)));
        if (filterType == Filter.StreamFilterType.DOM) {
            DOMContentDeliveryConfig domConfig = new DOMContentDeliveryConfig();
            logger.debug((Object)"Using the DOM Stream Filter.");
            domConfig.setAssemblyVisitBefores(this.assemblyVisitBefores);
            domConfig.setAssemblyVisitAfters(this.assemblyVisitAfters);
            domConfig.setProcessingVisitBefores(this.processingVisitBefores);
            domConfig.setProcessingVisitAfters(this.processingVisitAfters);
            domConfig.setSerailizationVisitors(this.serializationUnitTable);
            domConfig.setApplicationContext(this.applicationContext);
            domConfig.setSmooksResourceConfigurations(this.resourceConfigTable);
            domConfig.setDtd(this.dtd);
            domConfig.getConfigBuilderEvents().addAll(this.configBuilderEvents);
            return domConfig;
        }
        SAXContentDeliveryConfig saxConfig = new SAXContentDeliveryConfig();
        logger.debug((Object)"Using the SAX Stream Filter.");
        saxConfig.setVisitBefores(this.saxVisitBefores);
        saxConfig.setVisitAfters(this.saxVisitAfters);
        saxConfig.setApplicationContext(this.applicationContext);
        saxConfig.setSmooksResourceConfigurations(this.resourceConfigTable);
        saxConfig.setDtd(this.dtd);
        saxConfig.getConfigBuilderEvents().addAll(this.configBuilderEvents);
        saxConfig.optimizeConfig();
        return saxConfig;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Filter.StreamFilterType getStreamFilterType() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("SAX/DOM support characteristics of the Resource Configuration map:\n" + this.getResourceFilterCharacteristics()));
        }
        if (this.saxElementHandlerCount == this.elementHandlerCount && this.domElementHandlerCount == this.elementHandlerCount) {
            Parameter filterTypeParam = ParameterAccessor.getParameter("stream.filter.type", this.resourceConfigTable);
            if (filterTypeParam != null) {
                if (filterTypeParam.getValue().equalsIgnoreCase(Filter.StreamFilterType.DOM.name())) {
                    return Filter.StreamFilterType.DOM;
                }
                if (!filterTypeParam.getValue().equalsIgnoreCase(Filter.StreamFilterType.SAX.name())) throw new SmooksException("Invalid 'stream.filter.type' configuration parameter value of '" + filterTypeParam + "'.  Must be 'SAX' or 'DOM'.");
                return Filter.StreamFilterType.SAX;
            }
        } else {
            if (this.domElementHandlerCount == this.elementHandlerCount) {
                return Filter.StreamFilterType.DOM;
            }
            if (this.saxElementHandlerCount != this.elementHandlerCount) throw new SmooksException("Ambiguous Resource Configuration set.  All Element Content Handlers must support processing on the SAX and/or DOM Filter:\n" + this.getResourceFilterCharacteristics());
            return Filter.StreamFilterType.SAX;
        }
        Filter.StreamFilterType filterType = Filter.StreamFilterType.DOM;
        logger.debug((Object)"All configured XML Element Content Handler resource configurations can be applied using the SAX or DOM Stream Filter.  Defaulting to DOM Filter.  Set 'global-parameters:stream.filter.type'.");
        logger.debug((Object)"You can explicitly select the Filter type as follows:\n\t\t<resource-config selector=\"global-parameters\">\n\t\t\t<param name=\"stream.filter.type\">SAX/DOM</param>\n\t\t</resource-config>");
        return filterType;
    }

    private String getResourceFilterCharacteristics() {
        StringBuffer stringBuf = new StringBuffer();
        ArrayList<ContentHandler> printedHandlers = new ArrayList<ContentHandler>();
        stringBuf.append("\t\tDOM   SAX    Resource  ('x' equals supported)\n");
        stringBuf.append("\t\t---------------------------------------------------------------------\n");
        this.printHandlerCharacteristics(this.assemblyVisitBefores, stringBuf, printedHandlers);
        this.printHandlerCharacteristics(this.assemblyVisitAfters, stringBuf, printedHandlers);
        this.printHandlerCharacteristics(this.processingVisitBefores, stringBuf, printedHandlers);
        this.printHandlerCharacteristics(this.processingVisitAfters, stringBuf, printedHandlers);
        this.printHandlerCharacteristics(this.serializationUnitTable, stringBuf, printedHandlers);
        this.printHandlerCharacteristics(this.saxVisitBefores, stringBuf, printedHandlers);
        this.printHandlerCharacteristics(this.saxVisitAfters, stringBuf, printedHandlers);
        stringBuf.append("\n\n");
        return stringBuf.toString();
    }

    private <U extends ContentHandler> void printHandlerCharacteristics(ContentHandlerConfigMapTable<U> table, StringBuffer stringBuf, List<ContentHandler> printedHandlers) {
        Collection<List<ContentHandlerConfigMap<U>>> map = table.getTable().values();
        for (List<ContentHandlerConfigMap<U>> mapList : map) {
            for (ContentHandlerConfigMap<U> configMap : mapList) {
                U handler = configMap.getContentHandler();
                boolean domSupported = this.isDOMContentHandler((ContentHandler)handler);
                boolean saxSupported = this.isSAXContentHandler((ContentHandler)handler);
                if (printedHandlers.contains(handler)) continue;
                printedHandlers.add((ContentHandler)handler);
                stringBuf.append("\t\t " + (domSupported ? "x" : " ") + "     " + (saxSupported ? "x" : " ") + "     " + configMap.getResourceConfig() + "\n");
            }
        }
    }

    private static LinkedHashMap<String, ContentDeliveryConfig> getDeliveryConfigTable(ApplicationContext applicationContext) {
        return (LinkedHashMap)applicationContext.getAttribute(DELIVERY_CONFIG_TABLE_CTX_KEY);
    }

    private void load() {
        this.resourceConfigsList.clear();
        this.resourceConfigsList.addAll(Arrays.asList(this.applicationContext.getStore().getSmooksResourceConfigurations(this.profileSet)));
        this.buildSmooksResourceConfigurationTable(this.resourceConfigsList);
        this.sortSmooksResourceConfigurations(this.resourceConfigTable);
        List<SmooksResourceConfiguration> dtdSmooksResourceConfigurations = this.resourceConfigTable.get("dtd");
        if (dtdSmooksResourceConfigurations != null && dtdSmooksResourceConfigurations.size() > 0) {
            SmooksResourceConfiguration dtdSmooksResourceConfiguration = dtdSmooksResourceConfigurations.get(0);
            byte[] dtdDataBytes = dtdSmooksResourceConfiguration.getBytes();
            if (dtdDataBytes != null) {
                DTDStore.addDTD(this.profileSet, new ByteArrayInputStream(dtdDataBytes));
                this.dtd = DTDStore.getDTDObject(this.profileSet);
            } else {
                logger.error((Object)("DTD resource [" + dtdSmooksResourceConfiguration.getResource() + "] not found in classpath."));
            }
        }
        this.expandSmooksResourceConfigurationTable();
        this.sortSmooksResourceConfigurations(this.resourceConfigTable);
        this.extractContentHandlers();
        if (logger.isDebugEnabled()) {
            this.logResourceConfig();
        }
    }

    private void logResourceConfig() {
        logger.debug((Object)"==================================================================================================");
        logger.debug((Object)("Resource configuration (sorted) for profile [" + this.profileSet.getBaseProfile() + "].  Sub Profiles: [" + this.profileSet + "]"));
        Iterator<Map.Entry<String, List<SmooksResourceConfiguration>>> configurations = this.resourceConfigTable.entrySet().iterator();
        int i = 0;
        while (configurations.hasNext()) {
            Map.Entry<String, List<SmooksResourceConfiguration>> entry = configurations.next();
            List<SmooksResourceConfiguration> resources = entry.getValue();
            logger.debug((Object)(i + ") " + entry.getKey()));
            for (int ii = 0; ii < resources.size(); ++ii) {
                logger.debug((Object)("\t(" + ii + ") " + resources.get(ii)));
            }
        }
        logger.debug((Object)"==================================================================================================");
    }

    private void buildSmooksResourceConfigurationTable(List resourceConfigsList) {
        for (SmooksResourceConfiguration config : resourceConfigsList) {
            this.addResourceConfiguration(config);
        }
    }

    private void addResourceConfiguration(SmooksResourceConfiguration config) {
        String target = config.getSelector();
        if (config.isSelectorContextual()) {
            target = config.getTargetElement();
        }
        this.addResourceConfiguration(target, config);
    }

    private void addResourceConfiguration(String element, SmooksResourceConfiguration resourceConfiguration) {
        List<SmooksResourceConfiguration> elementConfigList;
        if (!this.resourceConfigsList.contains(resourceConfiguration)) {
            this.resourceConfigsList.add(resourceConfiguration);
        }
        if ((elementConfigList = this.resourceConfigTable.get(element)) == null) {
            elementConfigList = new Vector<SmooksResourceConfiguration>();
            this.resourceConfigTable.put(element, elementConfigList);
        }
        if (!elementConfigList.contains(resourceConfiguration)) {
            elementConfigList.add(resourceConfiguration);
        }
    }

    private void expandSmooksResourceConfigurationTable() {
        class ExpansionSmooksResourceConfigurationStrategy
        implements SmooksResourceConfigurationStrategy {
            ExpansionSmooksResourceConfigurationStrategy() {
            }

            public void applyStrategy(String elementName, SmooksResourceConfiguration resourceConfig) {
                if (resourceConfig.isXmlDef()) {
                    String[] elements = ContentDeliveryConfigBuilder.this.getDTDElements(resourceConfig.getSelector().substring(SmooksResourceConfiguration.XML_DEF_PREFIX.length()));
                    for (int i = 0; i < elements.length; ++i) {
                        ContentDeliveryConfigBuilder.this.addResourceConfiguration(elements[i], resourceConfig);
                    }
                }
            }
        }
        SmooksResourceConfigurationTableIterator tableIterator = new SmooksResourceConfigurationTableIterator(new ExpansionSmooksResourceConfigurationStrategy());
        tableIterator.iterate();
    }

    private void sortSmooksResourceConfigurations(Map<String, List<SmooksResourceConfiguration>> table) {
        Parameter sortParam = ParameterAccessor.getParameter("sort.resources", table);
        if (sortParam != null && sortParam.getValue().trim().equalsIgnoreCase("true") && !table.isEmpty()) {
            for (Map.Entry<String, List<SmooksResourceConfiguration>> entry : table.entrySet()) {
                List<SmooksResourceConfiguration> markupElSmooksResourceConfigurations = entry.getValue();
                SmooksResourceConfiguration[] resourceConfigs = markupElSmooksResourceConfigurations.toArray(new SmooksResourceConfiguration[markupElSmooksResourceConfigurations.size()]);
                SmooksResourceConfigurationSortComparator sortComparator = new SmooksResourceConfigurationSortComparator(this.profileSet);
                Arrays.sort(resourceConfigs, sortComparator);
                entry.setValue(new Vector<SmooksResourceConfiguration>(Arrays.asList(resourceConfigs)));
            }
        }
    }

    private void extractContentHandlers() {
        ContentHandlerExtractionStrategy cduStrategy = new ContentHandlerExtractionStrategy(this.applicationContext);
        SmooksResourceConfigurationTableIterator tableIterator = new SmooksResourceConfigurationTableIterator(cduStrategy);
        tableIterator.iterate();
    }

    private String[] getDTDElements(String string) {
        String tmpString = string.toLowerCase();
        if (tmpString.startsWith(ELCSPEC_PREFIX)) {
            if ((tmpString = tmpString.substring(ELCSPEC_PREFIX.length())).equals("empty")) {
                return this.dtd.getEmptyElements();
            }
            if (tmpString.equals("not-empty")) {
                return this.dtd.getNonEmptyElements();
            }
            if (tmpString.equals("any")) {
                return this.dtd.getAnyElements();
            }
            if (tmpString.equals("not-any")) {
                return this.dtd.getNonAnyElements();
            }
            if (tmpString.equals("mixed")) {
                return this.dtd.getMixedElements();
            }
            if (tmpString.equals("not-mixed")) {
                return this.dtd.getNonMixedElements();
            }
            if (tmpString.equals("pcdata")) {
                return this.dtd.getPCDataElements();
            }
            if (tmpString.equals("not-pcdata")) {
                return this.dtd.getNonPCDataElements();
            }
        }
        throw new IllegalStateException("Unsupported DTD spec definition [" + string + "]");
    }

    private void logExecutionEvent(SmooksResourceConfiguration resourceConfig, String message) {
        this.configBuilderEvents.add(new ConfigBuilderEvent(resourceConfig, message));
    }

    private boolean isDOMContentHandler(ContentHandler contentHandler) {
        return contentHandler instanceof DOMVisitBefore || contentHandler instanceof DOMVisitAfter || contentHandler instanceof SerializationUnit;
    }

    private boolean isSAXContentHandler(ContentHandler contentHandler) {
        return contentHandler instanceof SAXVisitBefore || contentHandler instanceof SAXVisitAfter;
    }

    protected static boolean visitBeforeAnnotationsOK(SmooksResourceConfiguration resourceConfig, ContentHandler contentHandler) {
        Class<?> handlerClass = contentHandler.getClass();
        VisitBeforeIf visitBeforeIf = handlerClass.getAnnotation(VisitBeforeIf.class);
        if (visitBeforeIf != null) {
            MVELExpressionEvaluator conditionEval = new MVELExpressionEvaluator();
            conditionEval.setExpression(visitBeforeIf.condition());
            return conditionEval.eval(resourceConfig);
        }
        return true;
    }

    protected static boolean visitAfterAnnotationsOK(SmooksResourceConfiguration resourceConfig, ContentHandler contentHandler) {
        Class<?> handlerClass = contentHandler.getClass();
        VisitAfterIf visitAfterIf = handlerClass.getAnnotation(VisitAfterIf.class);
        if (visitAfterIf != null) {
            MVELExpressionEvaluator conditionEval = new MVELExpressionEvaluator();
            conditionEval.setExpression(visitAfterIf.condition());
            return conditionEval.eval(resourceConfig);
        }
        return true;
    }

    private static interface SmooksResourceConfigurationStrategy {
        public void applyStrategy(String var1, SmooksResourceConfiguration var2);
    }

    private class SmooksResourceConfigurationTableIterator {
        private SmooksResourceConfigurationStrategy strategy;

        private SmooksResourceConfigurationTableIterator(SmooksResourceConfigurationStrategy strategy) {
            this.strategy = strategy;
        }

        private void iterate() {
            for (int i = 0; i < ContentDeliveryConfigBuilder.this.resourceConfigsList.size(); ++i) {
                SmooksResourceConfiguration smooksResourceConfiguration = (SmooksResourceConfiguration)ContentDeliveryConfigBuilder.this.resourceConfigsList.get(i);
                this.strategy.applyStrategy(smooksResourceConfiguration.getTargetElement(), smooksResourceConfiguration);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ContentHandlerExtractionStrategy
    implements SmooksResourceConfigurationStrategy {
        private SmooksResourceConfigurationStore store;

        public ContentHandlerExtractionStrategy(ApplicationContext applicationContext) {
            this.store = applicationContext.getStore();
        }

        @Override
        public void applyStrategy(String elementName, SmooksResourceConfiguration resourceConfig) {
            this.applyCDUStrategy(elementName, resourceConfig);
        }

        public boolean applyCDUStrategy(String elementName, SmooksResourceConfiguration resourceConfig) {
            String restype;
            ContentHandlerFactory creator;
            if (resourceConfig.isJavaContentHandler()) {
                try {
                    creator = this.store.getContentHandlerFactory("class");
                    if (this.addCDU(elementName, resourceConfig, creator)) {
                        return true;
                    }
                }
                catch (UnsupportedContentHandlerTypeException e) {
                    throw new IllegalStateException("No ContentHandlerFactory configured (IoC) for type 'class' (Java).");
                }
                catch (InstantiationException e) {
                    // empty catch block
                }
            }
            if ((creator = this.tryCreateCreator(restype = resourceConfig.getResourceType())) != null) {
                if (!(creator instanceof JavaContentHandlerFactory)) {
                    try {
                        return this.addCDU(elementName, resourceConfig, creator);
                    }
                    catch (InstantiationException e) {
                        logger.warn((Object)"ContentHandler creation failure.", (Throwable)e);
                    }
                }
            } else if (restype != null) {
                ContentDeliveryConfigBuilder.this.logExecutionEvent(resourceConfig, "Unable to create ContentHandler class instance for resource.  This is probably because there's no " + ContentHandlerFactory.class.getSimpleName() + " implementation for resource " + "type '" + restype + "' available on the classpath.");
            }
            return false;
        }

        private ContentHandlerFactory tryCreateCreator(String restype) {
            ContentHandlerFactory creator;
            try {
                if (restype == null || restype.trim().equals("")) {
                    logger.debug((Object)"Request to attempt ContentHandlerFactory creation based on a null/empty resource type.");
                    return null;
                }
                creator = this.store.getContentHandlerFactory(restype);
            }
            catch (UnsupportedContentHandlerTypeException e) {
                return null;
            }
            return creator;
        }

        private boolean addCDU(String elementName, SmooksResourceConfiguration resourceConfig, ContentHandlerFactory handlerFactory) throws InstantiationException {
            List<SmooksResourceConfiguration> additionalConfigs;
            ContentHandler contentHandler;
            try {
                contentHandler = handlerFactory.create(resourceConfig);
                this.store.getAllocatedHandlers().add(contentHandler);
            }
            catch (SmooksConfigurationException e) {
                throw e;
            }
            catch (Throwable thrown) {
                String message = "ContentHandlerFactory [" + handlerFactory.getClass().getName() + "] unable to create resource processing instance for resource [" + resourceConfig + "]. ";
                if (logger.isDebugEnabled()) {
                    logger.warn((Object)message, thrown);
                } else {
                    logger.warn((Object)(message + thrown.getMessage()));
                }
                ContentDeliveryConfigBuilder.this.configBuilderEvents.add(new ConfigBuilderEvent(resourceConfig, message, thrown));
                return false;
            }
            if (ContentDeliveryConfigBuilder.this.isSAXContentHandler(contentHandler) || ContentDeliveryConfigBuilder.this.isDOMContentHandler(contentHandler)) {
                ContentDeliveryConfigBuilder.this.elementHandlerCount++;
                if (ContentDeliveryConfigBuilder.this.isSAXContentHandler(contentHandler)) {
                    ContentDeliveryConfigBuilder.this.saxElementHandlerCount++;
                    if (contentHandler instanceof SAXVisitBefore && ContentDeliveryConfigBuilder.visitBeforeAnnotationsOK(resourceConfig, contentHandler)) {
                        ContentDeliveryConfigBuilder.this.saxVisitBefores.addMapping(elementName, resourceConfig, (SAXVisitBefore)contentHandler);
                    }
                    if (contentHandler instanceof SAXVisitAfter && ContentDeliveryConfigBuilder.visitAfterAnnotationsOK(resourceConfig, contentHandler)) {
                        ContentDeliveryConfigBuilder.this.saxVisitAfters.addMapping(elementName, resourceConfig, (SAXVisitAfter)contentHandler);
                    }
                    ContentDeliveryConfigBuilder.this.logExecutionEvent(resourceConfig, "Added as a SAX resource.");
                }
                if (ContentDeliveryConfigBuilder.this.isDOMContentHandler(contentHandler)) {
                    ContentDeliveryConfigBuilder.this.domElementHandlerCount++;
                    if (contentHandler instanceof SerializationUnit) {
                        ContentDeliveryConfigBuilder.this.serializationUnitTable.addMapping(elementName, resourceConfig, (SerializationUnit)contentHandler);
                        ContentDeliveryConfigBuilder.this.logExecutionEvent(resourceConfig, "Added as a DOM " + SerializationUnit.class.getSimpleName() + " resource.");
                    } else {
                        Phase phaseAnnotation = contentHandler.getClass().getAnnotation(Phase.class);
                        String visitPhase = resourceConfig.getStringParameter("VisitPhase", VisitPhase.PROCESSING.toString());
                        if (phaseAnnotation != null && phaseAnnotation.value() == VisitPhase.ASSEMBLY) {
                            if (contentHandler instanceof DOMVisitBefore && ContentDeliveryConfigBuilder.visitBeforeAnnotationsOK(resourceConfig, contentHandler)) {
                                ContentDeliveryConfigBuilder.this.assemblyVisitBefores.addMapping(elementName, resourceConfig, (DOMVisitBefore)contentHandler);
                            }
                            if (contentHandler instanceof DOMVisitAfter && ContentDeliveryConfigBuilder.visitAfterAnnotationsOK(resourceConfig, contentHandler)) {
                                ContentDeliveryConfigBuilder.this.assemblyVisitAfters.addMapping(elementName, resourceConfig, (DOMVisitAfter)contentHandler);
                            }
                            ContentDeliveryConfigBuilder.this.logExecutionEvent(resourceConfig, "Added as a DOM Assembly Phase resource.");
                        } else if (visitPhase.equalsIgnoreCase(VisitPhase.ASSEMBLY.toString())) {
                            if (contentHandler instanceof DOMVisitBefore && ContentDeliveryConfigBuilder.visitBeforeAnnotationsOK(resourceConfig, contentHandler)) {
                                ContentDeliveryConfigBuilder.this.assemblyVisitBefores.addMapping(elementName, resourceConfig, (DOMVisitBefore)contentHandler);
                            }
                            if (contentHandler instanceof DOMVisitAfter && ContentDeliveryConfigBuilder.visitAfterAnnotationsOK(resourceConfig, contentHandler)) {
                                ContentDeliveryConfigBuilder.this.assemblyVisitAfters.addMapping(elementName, resourceConfig, (DOMVisitAfter)contentHandler);
                            }
                            ContentDeliveryConfigBuilder.this.logExecutionEvent(resourceConfig, "Added as a DOM Assembly Phase resource.");
                        } else {
                            if (contentHandler instanceof DOMVisitBefore && ContentDeliveryConfigBuilder.visitBeforeAnnotationsOK(resourceConfig, contentHandler)) {
                                ContentDeliveryConfigBuilder.this.processingVisitBefores.addMapping(elementName, resourceConfig, (DOMVisitBefore)contentHandler);
                            }
                            if (contentHandler instanceof DOMVisitAfter && ContentDeliveryConfigBuilder.visitAfterAnnotationsOK(resourceConfig, contentHandler)) {
                                ContentDeliveryConfigBuilder.this.processingVisitAfters.addMapping(elementName, resourceConfig, (DOMVisitAfter)contentHandler);
                            }
                            ContentDeliveryConfigBuilder.this.logExecutionEvent(resourceConfig, "Added as a DOM Processing Phase resource.");
                        }
                    }
                }
            } else if (!(contentHandler instanceof ConfigurationExpander)) {
                return false;
            }
            if (contentHandler instanceof ConfigurationExpander && (additionalConfigs = ((ConfigurationExpander)contentHandler).expandConfigurations()) != null && !additionalConfigs.isEmpty()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Adding expansion resource configurations created by: " + resourceConfig));
                    for (SmooksResourceConfiguration additionalConfig : additionalConfigs) {
                        logger.debug((Object)("\tAdding expansion resource configuration: " + additionalConfig));
                    }
                }
                this.processExpansionConfigurations(additionalConfigs);
            }
            return true;
        }

        private void processExpansionConfigurations(List<SmooksResourceConfiguration> additionalConfigs) {
            for (SmooksResourceConfiguration config : additionalConfigs) {
                String targetElement = config.getTargetElement();
                if (this.applyCDUStrategy(targetElement, config)) continue;
                ContentDeliveryConfigBuilder.this.addResourceConfiguration(config);
            }
        }
    }
}

