/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.delivery.ContentHandler;
import org.milyn.delivery.ContentHandlerConfigMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentHandlerConfigMapTable<T extends ContentHandler> {
    private Map<String, List<ContentHandlerConfigMap<T>>> table = new LinkedHashMap<String, List<ContentHandlerConfigMap<T>>>();
    private int count = 0;

    public void addMapping(String selector, SmooksResourceConfiguration resourceConfig, T deliveryUnit) {
        List<ContentHandlerConfigMap<T>> selectorMappings = this.table.get(selector.toLowerCase());
        if (selectorMappings == null) {
            selectorMappings = new Vector<ContentHandlerConfigMap<T>>();
            this.table.put(selector.toLowerCase(), selectorMappings);
        }
        ContentHandlerConfigMap<T> mapInst = new ContentHandlerConfigMap<T>(deliveryUnit, resourceConfig);
        selectorMappings.add(mapInst);
        ++this.count;
    }

    public Map<String, List<ContentHandlerConfigMap<T>>> getTable() {
        return Collections.unmodifiableMap(this.table);
    }

    public List<ContentHandlerConfigMap<T>> getMappings(String selector) {
        return this.table.get(selector.toLowerCase());
    }

    public List<ContentHandlerConfigMap<T>> getMappings(String[] selectors) {
        ArrayList<ContentHandlerConfigMap<T>> combinedList = new ArrayList<ContentHandlerConfigMap<T>>();
        for (String selector : selectors) {
            List<ContentHandlerConfigMap<T>> selectorList = this.table.get(selector.toLowerCase());
            if (selectorList == null) continue;
            combinedList.addAll(selectorList);
        }
        return combinedList;
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public int getCount() {
        return this.count;
    }
}

