/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery.dom;

import java.io.IOException;
import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.AbstractParser;
import org.milyn.delivery.dom.DOMBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DOMParser
extends AbstractParser {
    private static Log logger = LogFactory.getLog(DOMParser.class);

    public DOMParser(ExecutionContext execContext) {
        super(execContext);
    }

    public DOMParser(ExecutionContext execContext, SmooksResourceConfiguration saxDriverConfig) {
        super(execContext, saxDriverConfig);
    }

    public Document parse(Reader source) throws IOException, SAXException {
        DOMBuilder contentHandler = new DOMBuilder(this.getExecContext());
        this.parse(source, contentHandler);
        return contentHandler.getDocument();
    }

    public void append(Reader source, Element appendElement) throws IOException, SAXException {
        DOMBuilder contentHandler = new DOMBuilder(this.getExecContext());
        contentHandler.setAppendElement(appendElement);
        this.parse(source, contentHandler);
    }

    private void parse(Reader source, DOMBuilder contentHandler) throws SAXException, IOException {
        XMLReader reader = this.createXMLReader(contentHandler);
        reader.parse(new InputSource(source));
    }
}

