/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery.dom.serialize;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.ParameterAccessor;
import org.milyn.cdr.ResourceConfigurationNotFoundException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.annotation.Configurator;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.ContentHandlerConfigMap;
import org.milyn.delivery.ContentHandlerConfigMapTable;
import org.milyn.delivery.dom.DOMContentDeliveryConfig;
import org.milyn.delivery.dom.serialize.DefaultSerializationUnit;
import org.milyn.delivery.dom.serialize.SerializationUnit;
import org.milyn.event.ExecutionEventListener;
import org.milyn.event.types.DOMFilterLifecycleEvent;
import org.milyn.event.types.ElementPresentEvent;
import org.milyn.event.types.ResourceTargetingEvent;
import org.milyn.xml.DocType;
import org.milyn.xml.DomUtils;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Serializer {
    private static Log logger = LogFactory.getLog(Serializer.class);
    private Node node;
    private ExecutionContext executionContext;
    private DOMContentDeliveryConfig deliveryConfig;
    private ContentHandlerConfigMapTable<SerializationUnit> serializationUnits;
    private boolean defaultSerializationOn;
    private List defaultSUs;
    private ExecutionEventListener eventListener;
    private boolean terminateOnVisitorException;
    private static DefaultSerializationUnit defaultSerializer = new DefaultSerializationUnit();

    public Serializer(Node node, ExecutionContext executionContext) {
        if (node == null) {
            throw new IllegalArgumentException("null 'node' arg passed in method call.");
        }
        if (executionContext == null) {
            throw new IllegalArgumentException("null 'executionContext' arg passed in method call.");
        }
        this.node = node;
        this.executionContext = executionContext;
        this.eventListener = executionContext.getEventListener();
        this.deliveryConfig = (DOMContentDeliveryConfig)executionContext.getDeliveryConfig();
        this.serializationUnits = this.deliveryConfig.getSerailizationVisitors();
        this.defaultSerializationOn = ParameterAccessor.getBoolParameter("default.serialization.on", true, executionContext.getDeliveryConfig());
        if (this.defaultSerializationOn) {
            this.defaultSUs = this.serializationUnits.getMappings("*");
            if (this.defaultSUs == null) {
                SmooksResourceConfiguration resourceConfig = new SmooksResourceConfiguration("*", "*", DefaultSerializationUnit.class.getName());
                resourceConfig.setDefaultResource(true);
                this.defaultSUs = new Vector();
                this.defaultSUs.add(new ContentHandlerConfigMap<DefaultSerializationUnit>(Configurator.configure(new DefaultSerializationUnit(), resourceConfig), resourceConfig));
            }
        }
        this.terminateOnVisitorException = ParameterAccessor.getBoolParameter("terminate.on.visitor.exception", true, executionContext.getDeliveryConfig());
    }

    public void serailize(Writer writer) throws ResourceConfigurationNotFoundException, IOException {
        if (writer == null) {
            throw new IllegalArgumentException("null 'writer' arg passed in method call.");
        }
        if (this.eventListener != null) {
            this.eventListener.onEvent(new DOMFilterLifecycleEvent(DOMFilterLifecycleEvent.DOMEventType.SERIALIZATION_STARTED));
        }
        if (this.node instanceof Document) {
            Document doc = (Document)this.node;
            Element rootElement = doc.getDocumentElement();
            DocType.DocumentTypeData docTypeData = DocType.getDocType(this.executionContext);
            if (docTypeData != null) {
                DocType.serializeDoctype(docTypeData, writer);
                if (docTypeData.getXmlns() != null) {
                    rootElement.setAttribute("xmlns", docTypeData.getXmlns());
                } else {
                    rootElement.removeAttribute("xmlns");
                }
            }
            this.recursiveDOMWrite(rootElement, writer, true);
        } else {
            NodeList deliveryNodes = this.node.getChildNodes();
            int nodeCount = deliveryNodes.getLength();
            boolean isRoot = this.node == this.node.getOwnerDocument().getDocumentElement();
            for (int i = 0; i < nodeCount; ++i) {
                Node childNode = deliveryNodes.item(i);
                if (childNode.getNodeType() != 1) continue;
                this.recursiveDOMWrite((Element)childNode, writer, isRoot);
            }
        }
    }

    private void serializeDoctype(String publicId, String systemId, String rootElement, Writer writer) throws IOException {
        writer.write("<!DOCTYPE ");
        writer.write(rootElement);
        writer.write(32);
        if (publicId != null) {
            writer.write("PUBLIC \"");
            writer.write(publicId);
            writer.write("\" ");
        }
        if (systemId != null) {
            writer.write(34);
            writer.write(systemId);
            writer.write(34);
        }
        writer.write(62);
        writer.write(10);
    }

    private void recursiveDOMWrite(Element element, Writer writer, boolean isRoot) throws IOException {
        NodeList children = element.getChildNodes();
        SerializationUnit elementSU = this.getSerializationUnit(element, isRoot);
        try {
            if (elementSU != null) {
                elementSU.writeElementStart(element, writer, this.executionContext);
            }
            if (children != null && children.getLength() > 0) {
                int childCount = children.getLength();
                block9: for (int i = 0; i < childCount; ++i) {
                    Node childNode = children.item(i);
                    if (elementSU != null) {
                        switch (childNode.getNodeType()) {
                            case 4: {
                                elementSU.writeElementCDATA((CDATASection)childNode, writer, this.executionContext);
                                break;
                            }
                            case 8: {
                                elementSU.writeElementComment((Comment)childNode, writer, this.executionContext);
                                break;
                            }
                            case 1: {
                                if (!elementSU.writeChildElements()) continue block9;
                                this.recursiveDOMWrite((Element)childNode, writer, false);
                                break;
                            }
                            case 5: {
                                elementSU.writeElementEntityRef((EntityReference)childNode, writer, this.executionContext);
                                break;
                            }
                            case 3: {
                                elementSU.writeElementText((Text)childNode, writer, this.executionContext);
                                break;
                            }
                            default: {
                                elementSU.writeElementNode(childNode, writer, this.executionContext);
                                break;
                            }
                        }
                        continue;
                    }
                    if (childNode.getNodeType() != 1) continue;
                    this.recursiveDOMWrite((Element)childNode, writer, false);
                }
            }
            if (elementSU != null) {
                elementSU.writeElementEnd(element, writer, this.executionContext);
            }
        }
        catch (Throwable thrown) {
            String error = "Failed to apply serialization unit [" + elementSU.getClass().getName() + "] to [" + this.executionContext.getDocumentSource() + ":" + DomUtils.getXPath(element) + "].";
            if (this.terminateOnVisitorException) {
                if (thrown instanceof SmooksException) {
                    throw (SmooksException)thrown;
                }
                throw new SmooksException(error, thrown);
            }
            logger.error((Object)error, thrown);
        }
    }

    private SerializationUnit getSerializationUnit(Element element, boolean isRoot) {
        List<ContentHandlerConfigMap<SerializationUnit>> elementSUs;
        String elementName = DomUtils.getName(element);
        if (this.eventListener != null) {
            this.eventListener.onEvent(new ElementPresentEvent(element));
        }
        if ((elementSUs = isRoot ? this.serializationUnits.getMappings(new String[]{"$document", elementName}) : this.serializationUnits.getMappings(elementName)) == null || elementSUs.isEmpty()) {
            elementSUs = this.defaultSUs;
        }
        if (elementSUs != null) {
            int numSUs = elementSUs.size();
            for (int i = 0; i < numSUs; ++i) {
                ContentHandlerConfigMap<SerializationUnit> configMap = elementSUs.get(i);
                SmooksResourceConfiguration config = configMap.getResourceConfig();
                if (!config.isTargetedAtElement(element)) continue;
                if (this.eventListener != null) {
                    this.eventListener.onEvent(new ResourceTargetingEvent((Object)element, config, new Object[0]));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Applying serialisation resource [" + config + "] to element [" + DomUtils.getXPath(element) + "]."));
                }
                return configMap.getContentHandler();
            }
        }
        return null;
    }

    public static void recursiveDOMWrite(Element element, Writer writer) throws IOException {
        NodeList children = element.getChildNodes();
        try {
            defaultSerializer.writeElementStart(element, writer);
            if (children != null && children.getLength() > 0) {
                int childCount = children.getLength();
                block9: for (int i = 0; i < childCount; ++i) {
                    Node childNode = children.item(i);
                    switch (childNode.getNodeType()) {
                        case 4: {
                            defaultSerializer.writeElementCDATA((CDATASection)childNode, writer, null);
                            continue block9;
                        }
                        case 8: {
                            defaultSerializer.writeElementComment((Comment)childNode, writer, null);
                            continue block9;
                        }
                        case 1: {
                            Serializer.recursiveDOMWrite((Element)childNode, writer);
                            continue block9;
                        }
                        case 5: {
                            defaultSerializer.writeElementEntityRef((EntityReference)childNode, writer, null);
                            continue block9;
                        }
                        case 3: {
                            defaultSerializer.writeElementText((Text)childNode, writer, null);
                            continue block9;
                        }
                        default: {
                            defaultSerializer.writeElementNode(childNode, writer, null);
                        }
                    }
                }
            }
            defaultSerializer.writeElementEnd(element, writer);
        }
        catch (Throwable thrown) {
            if (thrown instanceof SmooksException) {
                throw (SmooksException)thrown;
            }
            throw new SmooksException("Serailization Error.", thrown);
        }
    }

    static {
        defaultSerializer.setCloseEmptyElements(true);
    }
}

