/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery.sax;

import java.io.IOException;
import org.milyn.SmooksException;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXElementVisitor;
import org.milyn.delivery.sax.SAXText;
import org.milyn.delivery.sax.SAXVisitor;
import org.milyn.delivery.sax.WriterUtil;

public class DefaultSAXElementSerializer
implements SAXElementVisitor {
    private SAXVisitor writerOwner = this;

    public void setWriterOwner(SAXVisitor writerOwner) {
        this.writerOwner = writerOwner;
    }

    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        element.getWriter(this.writerOwner);
    }

    public void onChildText(SAXElement element, SAXText text, ExecutionContext executionContext) throws SmooksException, IOException {
        this.writeStartElement(element);
        text.toWriter(element.getWriter(this.writerOwner));
    }

    public void onChildElement(SAXElement element, SAXElement childElement, ExecutionContext executionContext) throws SmooksException, IOException {
        this.writeStartElement(element);
    }

    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.writeEndElement(element);
    }

    public void writeStartElement(SAXElement element) throws IOException {
        if (!this.isStartWritten(element)) {
            element.setCache(true);
            WriterUtil.writeStartElement(element, element.getWriter(this.writerOwner));
        }
    }

    private void writeEndElement(SAXElement element) throws IOException {
        if (!this.isStartWritten(element)) {
            WriterUtil.writeEmptyElement(element, element.getWriter(this.writerOwner));
        } else {
            WriterUtil.writeEndElement(element, element.getWriter(this.writerOwner));
        }
    }

    public boolean isStartWritten(SAXElement element) {
        return element.getCache() != null;
    }
}

