/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery.sax;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.ParameterAccessor;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.ContentHandlerConfigMap;
import org.milyn.delivery.ExecutionLifecycleCleanable;
import org.milyn.delivery.ExecutionLifecycleCleanableList;
import org.milyn.delivery.VisitSequence;
import org.milyn.delivery.sax.DefaultSAXElementSerializer;
import org.milyn.delivery.sax.DynamicSAXElementVisitorList;
import org.milyn.delivery.sax.SAXContentDeliveryConfig;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXElementVisitor;
import org.milyn.delivery.sax.SAXElementVisitorMap;
import org.milyn.delivery.sax.SAXText;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.delivery.sax.SAXVisitBefore;
import org.milyn.delivery.sax.SAXVisitChildren;
import org.milyn.delivery.sax.SAXVisitor;
import org.milyn.delivery.sax.SAXWriterAccessException;
import org.milyn.delivery.sax.TextType;
import org.milyn.event.ExecutionEventListener;
import org.milyn.event.report.AbstractReportGenerator;
import org.milyn.event.types.ElementPresentEvent;
import org.milyn.event.types.ElementVisitEvent;
import org.milyn.event.types.ResourceTargetingEvent;
import org.milyn.io.NullWriter;
import org.milyn.xml.DocType;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAXHandler
extends DefaultHandler2 {
    private static Log logger = LogFactory.getLog(SAXHandler.class);
    private ExecutionContext execContext;
    private Writer writer;
    private ElementProcessor currentProcessor = null;
    private TextType currentTextType = TextType.TEXT;
    private SAXContentDeliveryConfig deliveryConfig;
    private Map<String, SAXElementVisitorMap> visitorConfigMap;
    private SAXElementVisitorMap globalVisitorConfig;
    private boolean defaultSerializationOn;
    private boolean maintainElementStack;
    private SAXElementVisitor defaultSerializer = new DefaultSAXElementSerializer();
    private ContentHandlerConfigMap defaultSerializerMapping;
    private ExecutionEventListener eventListener;
    private boolean reverseVisitOrderOnVisitAfter;
    private boolean terminateOnVisitorException;
    private ExecutionLifecycleCleanableList cleanupList;
    private DynamicSAXElementVisitorList dynamicVisitorList;
    private StringBuilder cdataNodeBuilder = new StringBuilder();
    private SAXText textWrapper = new SAXText();

    public SAXHandler(ExecutionContext executionContext, Writer writer) {
        this.execContext = executionContext;
        this.writer = writer;
        this.eventListener = executionContext.getEventListener();
        this.deliveryConfig = (SAXContentDeliveryConfig)executionContext.getDeliveryConfig();
        this.visitorConfigMap = this.deliveryConfig.getOptimizedVisitorConfig();
        this.globalVisitorConfig = this.visitorConfigMap.get("*");
        SmooksResourceConfiguration resource = new SmooksResourceConfiguration("*", DefaultSAXElementSerializer.class.getName());
        resource.setDefaultResource(true);
        this.defaultSerializationOn = executionContext.isDefaultSerializationOn();
        if (this.defaultSerializationOn) {
            this.defaultSerializationOn = !(writer instanceof NullWriter);
        }
        this.maintainElementStack = ParameterAccessor.getBoolParameter("maintain.element.stack", true, executionContext.getDeliveryConfig());
        this.defaultSerializerMapping = new ContentHandlerConfigMap<DefaultSAXElementSerializer>(new DefaultSAXElementSerializer(), resource);
        this.reverseVisitOrderOnVisitAfter = ParameterAccessor.getBoolParameter("reverse.visit.order.on.visit.after", true, executionContext.getDeliveryConfig());
        this.terminateOnVisitorException = !(executionContext.getEventListener() instanceof AbstractReportGenerator) ? ParameterAccessor.getBoolParameter("terminate.on.visitor.exception", true, executionContext.getDeliveryConfig()) : false;
        this.cleanupList = new ExecutionLifecycleCleanableList(executionContext);
        this.dynamicVisitorList = new DynamicSAXElementVisitorList(executionContext, this.cleanupList);
    }

    public void cleanup() {
        this.cleanupList.cleanup();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        boolean isRoot = this.currentProcessor == null;
        QName elementQName = SAXElement.toQName(namespaceURI, localName, qName);
        String elementName = elementQName.getLocalPart();
        SAXElementVisitorMap elementVisitorConfig = isRoot ? this.deliveryConfig.getCombinedOptimizedConfig(new String[]{"$document", elementName}) : this.visitorConfigMap.get(elementName.toLowerCase());
        if (elementVisitorConfig == null) {
            elementVisitorConfig = this.globalVisitorConfig;
        }
        if (!this.maintainElementStack && elementVisitorConfig == null) {
            ElementProcessor processor = new ElementProcessor();
            processor.isNullProcessor = true;
            processor.parentProcessor = this.currentProcessor;
            this.currentProcessor = processor;
            if (this.eventListener != null) {
                this.eventListener.onEvent(new ElementPresentEvent(new WriterManagedSAXElement(elementQName, atts, this.currentProcessor.element)));
            }
        } else {
            WriterManagedSAXElement element;
            if (!isRoot) {
                element = new WriterManagedSAXElement(elementQName, atts, this.currentProcessor.element);
                element.setWriter(this.getWriter());
                this.onChildElement(element);
            } else {
                element = new WriterManagedSAXElement(elementQName, atts, null);
                element.setWriter(this.writer);
            }
            if (this.eventListener != null) {
                this.eventListener.onEvent(new ElementPresentEvent(element));
            }
            this.visitBefore(element, elementVisitorConfig);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        boolean flush = false;
        List<SAXVisitAfter> dynamicVisitAfters = this.dynamicVisitorList.getVisitAfters();
        if (!dynamicVisitAfters.isEmpty()) {
            for (SAXVisitAfter dynamicVisitAfter : dynamicVisitAfters) {
                try {
                    dynamicVisitAfter.visitAfter(this.currentProcessor.element, this.execContext);
                }
                catch (Throwable t) {
                    String errorMsg = "Error in '" + dynamicVisitAfter.getClass().getName() + "' while processing the visitAfter event.";
                    this.processVisitorException(t, errorMsg);
                }
            }
        }
        if (this.currentProcessor.elementVisitorConfig != null) {
            List<ContentHandlerConfigMap<SAXVisitAfter>> visitAfterMappings = this.currentProcessor.elementVisitorConfig.getVisitAfters();
            if (visitAfterMappings != null) {
                if (this.reverseVisitOrderOnVisitAfter) {
                    int mappingCount = visitAfterMappings.size();
                    for (int i = mappingCount - 1; i >= 0; --i) {
                        ContentHandlerConfigMap<SAXVisitAfter> mapping = visitAfterMappings.get(i);
                        this.visitAfter(mapping);
                    }
                } else {
                    int mappingCount = visitAfterMappings.size();
                    for (int i = 0; i < mappingCount; ++i) {
                        ContentHandlerConfigMap<SAXVisitAfter> mapping = visitAfterMappings.get(i);
                        this.visitAfter(mapping);
                    }
                }
            }
            flush = true;
        }
        if (this.defaultSerializationOn && this.applyDefaultSerialization()) {
            try {
                this.defaultSerializer.visitAfter(this.currentProcessor.element, this.execContext);
                if (this.eventListener != null) {
                    this.eventListener.onEvent(new ElementVisitEvent(this.currentProcessor.element, this.defaultSerializerMapping, VisitSequence.AFTER));
                }
            }
            catch (IOException e) {
                throw new SmooksException("Unexpected exception applying defaultSerializer.", e);
            }
            flush = true;
        }
        if (flush) {
            this.flushCurrentWriter();
        }
        ElementProcessor parentProcessor = this.currentProcessor.parentProcessor;
        this.currentProcessor.element = null;
        this.currentProcessor.elementVisitorConfig = null;
        this.currentProcessor.parentProcessor = null;
        this.currentProcessor = parentProcessor;
    }

    private Writer getWriter() {
        if (!this.currentProcessor.isNullProcessor) {
            return this.currentProcessor.element.getWriter();
        }
        ElementProcessor processor = this.currentProcessor;
        while (processor.parentProcessor != null) {
            if ((processor = processor.parentProcessor).isNullProcessor) continue;
            return processor.element.getWriter();
        }
        return null;
    }

    private void visitBefore(WriterManagedSAXElement element, SAXElementVisitorMap elementVisitorConfig) {
        List<SAXVisitBefore> dynamicVisitBefores;
        List<ContentHandlerConfigMap<SAXVisitBefore>> visitBeforeMappings;
        ElementProcessor processor = new ElementProcessor();
        processor.parentProcessor = this.currentProcessor;
        processor.element = element;
        processor.elementVisitorConfig = elementVisitorConfig;
        this.currentProcessor = processor;
        if (this.currentProcessor.elementVisitorConfig != null && (visitBeforeMappings = this.currentProcessor.elementVisitorConfig.getVisitBefores()) != null) {
            int mappingCount = visitBeforeMappings.size();
            for (int i = 0; i < mappingCount; ++i) {
                ContentHandlerConfigMap<SAXVisitBefore> mapping = visitBeforeMappings.get(i);
                try {
                    if (!mapping.getResourceConfig().isTargetedAtElement(this.currentProcessor.element)) continue;
                    if (mapping.isLifecycleCleanable()) {
                        this.cleanupList.add((ExecutionLifecycleCleanable)((Object)mapping.getContentHandler()));
                    }
                    mapping.getContentHandler().visitBefore(this.currentProcessor.element, this.execContext);
                    if (this.eventListener == null) continue;
                    this.eventListener.onEvent(new ResourceTargetingEvent((Object)element, mapping.getResourceConfig(), VisitSequence.BEFORE, new Object[0]));
                    this.eventListener.onEvent(new ElementVisitEvent(element, mapping, VisitSequence.BEFORE));
                    continue;
                }
                catch (Throwable t) {
                    String errorMsg = "Error in '" + mapping.getContentHandler().getClass().getName() + "' while processing the visitBefore event.";
                    this.processVisitorException(this.currentProcessor.element, t, mapping, VisitSequence.BEFORE, errorMsg);
                }
            }
        }
        if (this.defaultSerializationOn && this.applyDefaultSerialization()) {
            try {
                this.defaultSerializer.visitBefore(this.currentProcessor.element, this.execContext);
                if (this.eventListener != null) {
                    this.eventListener.onEvent(new ElementVisitEvent(element, this.defaultSerializerMapping, VisitSequence.BEFORE));
                }
            }
            catch (IOException e) {
                throw new SmooksException("Unexpected exception applying defaultSerializer.", e);
            }
        }
        if (!(dynamicVisitBefores = this.dynamicVisitorList.getVisitBefores()).isEmpty()) {
            for (SAXVisitBefore dynamicVisitBefore : dynamicVisitBefores) {
                try {
                    dynamicVisitBefore.visitBefore(this.currentProcessor.element, this.execContext);
                }
                catch (Throwable t) {
                    String errorMsg = "Error in '" + dynamicVisitBefore.getClass().getName() + "' while processing the visitBefore event.";
                    this.processVisitorException(t, errorMsg);
                }
            }
        }
    }

    private void onChildElement(SAXElement childElement) {
        List<SAXVisitChildren> dynamicChildVisitors;
        List<ContentHandlerConfigMap<SAXVisitChildren>> visitChildMappings;
        if (this.currentProcessor.elementVisitorConfig != null && (visitChildMappings = this.currentProcessor.elementVisitorConfig.getChildVisitors()) != null) {
            int mappingCount = visitChildMappings.size();
            for (int i = 0; i < mappingCount; ++i) {
                ContentHandlerConfigMap<SAXVisitChildren> mapping = visitChildMappings.get(i);
                if (!mapping.getResourceConfig().isTargetedAtElement(this.currentProcessor.element)) continue;
                try {
                    mapping.getContentHandler().onChildElement(this.currentProcessor.element, childElement, this.execContext);
                    continue;
                }
                catch (Throwable t) {
                    String errorMsg = "Error in '" + mapping.getContentHandler().getClass().getName() + "' while processing the onChildElement event.";
                    this.processVisitorException(this.currentProcessor.element, t, mapping, VisitSequence.AFTER, errorMsg);
                }
            }
        }
        if (this.defaultSerializationOn && this.applyDefaultSerialization()) {
            try {
                this.defaultSerializer.onChildElement(this.currentProcessor.element, childElement, this.execContext);
            }
            catch (IOException e) {
                throw new SmooksException("Unexpected exception applying defaultSerializer.", e);
            }
        }
        if (!(dynamicChildVisitors = this.dynamicVisitorList.getChildVisitors()).isEmpty()) {
            for (SAXVisitChildren dynamicChildVisitor : dynamicChildVisitors) {
                try {
                    dynamicChildVisitor.onChildElement(this.currentProcessor.element, childElement, this.execContext);
                }
                catch (Throwable t) {
                    String errorMsg = "Error in '" + dynamicChildVisitor.getClass().getName() + "' while processing the onChildElement event.";
                    this.processVisitorException(t, errorMsg);
                }
            }
        }
    }

    private void visitAfter(ContentHandlerConfigMap<SAXVisitAfter> afterMapping) {
        try {
            if (afterMapping.getResourceConfig().isTargetedAtElement(this.currentProcessor.element)) {
                if (afterMapping.isLifecycleCleanable()) {
                    this.cleanupList.add((ExecutionLifecycleCleanable)((Object)afterMapping.getContentHandler()));
                }
                afterMapping.getContentHandler().visitAfter(this.currentProcessor.element, this.execContext);
                if (this.eventListener != null) {
                    this.eventListener.onEvent(new ElementVisitEvent(this.currentProcessor.element, afterMapping, VisitSequence.AFTER));
                }
            }
        }
        catch (Throwable t) {
            String errorMsg = "Error in '" + afterMapping.getContentHandler().getClass().getName() + "' while processing the visitAfter event.";
            this.processVisitorException(this.currentProcessor.element, t, afterMapping, VisitSequence.AFTER, errorMsg);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentTextType != TextType.CDATA) {
            this._characters(ch, start, length);
        } else {
            this.cdataNodeBuilder.append(ch, start, length);
        }
    }

    private void _characters(char[] ch, int start, int length) {
        List<SAXVisitChildren> dynamicChildVisitors;
        if (this.currentProcessor != null && !this.currentProcessor.isNullProcessor) {
            List<ContentHandlerConfigMap<SAXVisitChildren>> visitChildMappings;
            if (this.currentProcessor.elementVisitorConfig != null && (visitChildMappings = this.currentProcessor.elementVisitorConfig.getChildVisitors()) != null) {
                int mappingCount = visitChildMappings.size();
                for (int i = 0; i < mappingCount; ++i) {
                    ContentHandlerConfigMap<SAXVisitChildren> mapping = visitChildMappings.get(i);
                    try {
                        if (!mapping.getResourceConfig().isTargetedAtElement(this.currentProcessor.element)) continue;
                        this.textWrapper.setText(ch, start, length, this.currentTextType);
                        mapping.getContentHandler().onChildText(this.currentProcessor.element, this.textWrapper, this.execContext);
                        continue;
                    }
                    catch (Throwable t) {
                        String errorMsg = "Error in '" + mapping.getContentHandler().getClass().getName() + "' while processing the onChildText event.";
                        this.processVisitorException(this.currentProcessor.element, t, mapping, VisitSequence.AFTER, errorMsg);
                    }
                }
            }
            if (this.defaultSerializationOn && this.applyDefaultSerialization()) {
                try {
                    this.textWrapper.setText(ch, start, length, this.currentTextType);
                    this.defaultSerializer.onChildText(this.currentProcessor.element, this.textWrapper, this.execContext);
                }
                catch (IOException e) {
                    throw new SmooksException("Unexpected exception applying defaultSerializer.", e);
                }
            }
        }
        if (!(dynamicChildVisitors = this.dynamicVisitorList.getChildVisitors()).isEmpty()) {
            for (SAXVisitChildren dynamicChildVisitor : dynamicChildVisitors) {
                try {
                    this.textWrapper.setText(ch, start, length, this.currentTextType);
                    dynamicChildVisitor.onChildText(this.currentProcessor.element, this.textWrapper, this.execContext);
                }
                catch (Throwable t) {
                    String errorMsg = "Error in '" + dynamicChildVisitor.getClass().getName() + "' while processing the onChildText event.";
                    this.processVisitorException(t, errorMsg);
                }
            }
        }
    }

    private boolean applyDefaultSerialization() {
        if (this.currentProcessor.element == null || !this.defaultSerializationOn) {
            return false;
        }
        return this.currentProcessor.element.writerOwner == this.defaultSerializer || this.currentProcessor.element.writerOwner == null;
    }

    private void flushCurrentWriter() {
        Writer writer = this.getWriter();
        if (writer != null) {
            try {
                writer.flush();
            }
            catch (IOException e) {
                logger.error((Object)"Error flushing writer.", (Throwable)e);
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        this.currentTextType = TextType.COMMENT;
        this.characters(ch, start, length);
        this.currentTextType = TextType.TEXT;
    }

    @Override
    public void startCDATA() throws SAXException {
        this.currentTextType = TextType.CDATA;
        this.cdataNodeBuilder.setLength(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endCDATA() throws SAXException {
        try {
            char[] chars = new char[this.cdataNodeBuilder.length()];
            this.cdataNodeBuilder.getChars(0, chars.length, chars, 0);
            this._characters(chars, 0, chars.length);
            this.currentTextType = TextType.TEXT;
        }
        finally {
            this.cdataNodeBuilder.setLength(0);
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        this.currentTextType = TextType.ENTITY;
    }

    @Override
    public void endEntity(String name) throws SAXException {
        this.currentTextType = TextType.TEXT;
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        DocType.DocumentTypeData docTypeData;
        DocType.setDocType(name, publicId, systemId, null, this.execContext);
        if (this.writer != null && (docTypeData = DocType.getDocType(this.execContext)) != null) {
            try {
                DocType.serializeDoctype(docTypeData, this.writer);
            }
            catch (IOException e) {
                throw new SAXException("Failed to serialize DOCTYPE.");
            }
        }
    }

    private void processVisitorException(SAXElement element, Throwable error, ContentHandlerConfigMap configMapping, VisitSequence visitSequence, String errorMsg) throws SmooksException {
        if (this.eventListener != null) {
            this.eventListener.onEvent(new ElementVisitEvent(element, configMapping, visitSequence, error));
        }
        this.processVisitorException(error, errorMsg);
    }

    private void processVisitorException(Throwable error, String errorMsg) {
        if (this.terminateOnVisitorException) {
            if (error instanceof SmooksException) {
                throw (SmooksException)error;
            }
            throw new SmooksException(errorMsg, error);
        }
        logger.error((Object)errorMsg, error);
    }

    private class WriterManagedSAXElement
    extends SAXElement {
        private SAXVisitor writerOwner;

        public WriterManagedSAXElement(QName qName, Attributes attributes, SAXElement parent) {
            super(qName, attributes, parent);
        }

        public Writer getWriter(SAXVisitor visitor) throws SAXWriterAccessException {
            if (this.writerOwner == null) {
                this.writerOwner = visitor;
                return super.getWriter(visitor);
            }
            if (visitor == this.writerOwner) {
                return super.getWriter(visitor);
            }
            this.throwSAXWriterAccessException(visitor);
            return null;
        }

        public void setWriter(Writer writer, SAXVisitor visitor) throws SAXWriterAccessException {
            if (this.writerOwner == null) {
                this.writerOwner = visitor;
                super.setWriter(writer, visitor);
            } else if (visitor == this.writerOwner) {
                super.setWriter(writer, visitor);
            } else {
                this.throwSAXWriterAccessException(visitor);
            }
        }

        public SAXElement getParent() {
            if (!SAXHandler.this.maintainElementStack) {
                throw new SmooksConfigurationException("Invalid Smooks configuration.  Call to 'SAXElement.getParent()' when the 'maintain.element.stack' is set to 'false'.  You need to change this configuration, or modify the calling code.");
            }
            return super.getParent();
        }

        private Writer getWriter() {
            return super.getWriter(null);
        }

        private void setWriter(Writer writer) {
            super.setWriter(writer, null);
        }

        private void throwSAXWriterAccessException(SAXVisitor visitor) {
            throw new SAXWriterAccessException("Illegal access to the element writer for element '" + this + "' by SAX visitor '" + visitor.getClass().getName() + "'.  Writer already acquired by SAX visitor '" + this.writerOwner.getClass().getName() + "'.  See SAXElement javadocs (http://milyn.codehaus.org/Smooks).  Change Smooks visitor resource configuration.");
        }
    }

    private static class ElementProcessor {
        private ElementProcessor parentProcessor;
        private boolean isNullProcessor = false;
        private WriterManagedSAXElement element;
        public SAXElementVisitorMap elementVisitorConfig;

        private ElementProcessor() {
        }
    }
}

