/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery.sax;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.milyn.SmooksException;
import org.milyn.delivery.sax.TextType;
import org.milyn.xml.HTMLEntityLookup;

public class SAXText {
    private char[] characters;
    private int offset;
    private int length;
    private TextType type;

    protected SAXText() {
    }

    public SAXText(char[] characters, int offset, int length, TextType type) {
        this.setText(characters, offset, length, type);
    }

    protected void setText(char[] characters, int offset, int length, TextType type) {
        this.characters = characters;
        this.offset = offset;
        this.length = length;
        this.type = type;
    }

    public String getText() {
        return new String(this.characters, this.offset, this.length);
    }

    public TextType getType() {
        return this.type;
    }

    public String toString() {
        StringWriter writer = new StringWriter(this.characters.length + 12);
        try {
            this.toWriter(writer);
        }
        catch (IOException e) {
            throw new SmooksException("Unexpected IOException writing to a StringWriter.");
        }
        return writer.toString();
    }

    public void toWriter(Writer writer) throws IOException {
        if (writer != null) {
            if (this.type == TextType.TEXT) {
                writer.write(this.characters, this.offset, this.length);
            } else if (this.type == TextType.COMMENT) {
                writer.write("<!--");
                writer.write(this.characters, this.offset, this.length);
                writer.write("-->");
            } else if (this.type == TextType.CDATA) {
                writer.write("<![CDATA[");
                writer.write(this.characters, this.offset, this.length);
                writer.write("]]>");
            } else if (this.type == TextType.ENTITY) {
                writer.write("&");
                writer.write(HTMLEntityLookup.getEntityRef((char)this.characters[0]));
                writer.write(59);
            }
        }
    }
}

