/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery.sax;

import java.io.IOException;
import java.io.Writer;
import javax.xml.namespace.QName;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.TextType;
import org.milyn.xml.HTMLEntityLookup;
import org.xml.sax.Attributes;

public class WriterUtil {
    public static void writeEmptyElement(SAXElement element, Writer writer) throws IOException {
        if (writer != null) {
            WriterUtil.writeUnclosedElement(element, writer);
            writer.write(" />");
        }
    }

    public static void writeStartElement(SAXElement element, Writer writer) throws IOException {
        if (writer != null) {
            WriterUtil.writeUnclosedElement(element, writer);
            writer.write(">");
        }
    }

    public static void writeEndElement(SAXElement element, Writer writer) throws IOException {
        if (writer != null) {
            QName name = element.getName();
            String prefix = name.getPrefix();
            writer.write("</");
            if (prefix != null && !prefix.equals("")) {
                writer.write(prefix);
                writer.write(58);
            }
            writer.write(name.getLocalPart());
            writer.write(62);
        }
    }

    public static void writeText(String text, TextType textType, Writer writer) throws IOException {
        if (writer != null) {
            switch (textType) {
                case TEXT: {
                    writer.write(text);
                    break;
                }
                case CDATA: {
                    writer.write("<![CDATA[");
                    writer.write(text);
                    writer.write("]]>");
                    break;
                }
                case COMMENT: {
                    writer.write("<!--");
                    writer.write(text);
                    writer.write("-->");
                    break;
                }
                case ENTITY: {
                    writer.write("&");
                    writer.write(HTMLEntityLookup.getEntityRef((char)text.charAt(0)));
                    writer.write(59);
                }
            }
        }
    }

    private static void writeUnclosedElement(SAXElement element, Writer writer) throws IOException {
        QName name = element.getName();
        String prefix = name.getPrefix();
        writer.write(60);
        if (prefix != null && !prefix.equals("")) {
            writer.write(prefix);
            writer.write(58);
        }
        writer.write(name.getLocalPart());
        WriterUtil.writeAttributes(element.getAttributes(), writer);
    }

    private static void writeAttributes(Attributes attributes, Writer writer) throws IOException {
        if (attributes != null) {
            int attribCount = attributes.getLength();
            for (int i = 0; i < attribCount; ++i) {
                String attQName = attributes.getQName(i);
                String attValue = attributes.getValue(i);
                writer.write(32);
                if (attQName != null) {
                    writer.write(attQName);
                } else {
                    writer.write(attributes.getLocalName(i));
                }
                if (attValue.indexOf(34) != -1) {
                    writer.write("='");
                    writer.write(attValue);
                    writer.write("'");
                    continue;
                }
                writer.write("=\"");
                writer.write(attValue);
                writer.write(34);
            }
        }
    }
}

