/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.event.report;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.transform.Result;
import org.milyn.SmooksException;
import org.milyn.assertion.AssertArgument;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.ContentDeliveryConfig;
import org.milyn.delivery.ContentHandlerConfigMap;
import org.milyn.delivery.Filter;
import org.milyn.delivery.VisitSequence;
import org.milyn.delivery.dom.DOMContentDeliveryConfig;
import org.milyn.delivery.dom.serialize.DefaultSerializationUnit;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.event.BasicExecutionEventListener;
import org.milyn.event.ElementProcessingEvent;
import org.milyn.event.ExecutionEvent;
import org.milyn.event.ResourceBasedEvent;
import org.milyn.event.report.ReportConfiguration;
import org.milyn.event.report.model.DOMReport;
import org.milyn.event.report.model.MessageNode;
import org.milyn.event.report.model.Report;
import org.milyn.event.report.model.ReportInfoNode;
import org.milyn.event.report.model.ResultNode;
import org.milyn.event.types.ConfigBuilderEvent;
import org.milyn.event.types.DOMFilterLifecycleEvent;
import org.milyn.event.types.ElementPresentEvent;
import org.milyn.event.types.ElementVisitEvent;
import org.milyn.event.types.FilterLifecycleEvent;
import org.milyn.payload.FilterResult;
import org.milyn.payload.JavaResult;
import org.milyn.payload.StringResult;
import org.milyn.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReportGenerator
extends BasicExecutionEventListener {
    private ReportConfiguration reportConfiguration;
    private Report report;
    private ExecutionContext executionContext;
    private int messageNodeCounter = 0;
    private int reportInfoNodeCounter = 0;
    private List<ExecutionEvent> preProcessingEvents = new ArrayList<ExecutionEvent>();
    private List<ExecutionEvent> processingEvents = new ArrayList<ExecutionEvent>();
    private Stack<ReportNode> reportNodeStack = new Stack();
    private List<ReportNode> allNodes = new ArrayList<ReportNode>();
    protected static final DefaultSerializationUnit domSerializer = new DefaultSerializationUnit();

    protected AbstractReportGenerator(ReportConfiguration reportConfiguration) {
        AssertArgument.isNotNull((Object)reportConfiguration, (String)"reportConfiguration");
        this.reportConfiguration = reportConfiguration;
        this.setFilterEvents(reportConfiguration.getFilterEvents());
    }

    public ReportConfiguration getReportConfiguration() {
        return this.reportConfiguration;
    }

    public Writer getOutputWriter() {
        return this.reportConfiguration.getOutputWriter();
    }

    @Override
    public void onEvent(ExecutionEvent event) {
        AssertArgument.isNotNull((Object)event, (String)"event");
        if (this.ignoreEvent(event)) {
            return;
        }
        if (event instanceof FilterLifecycleEvent) {
            this.processLifecycleEvent((FilterLifecycleEvent)event);
        } else if (event instanceof ElementPresentEvent) {
            ReportNode node = new ReportNode((ElementPresentEvent)event);
            this.allNodes.add(node);
            this.processNewElementEvent(node);
        } else if (this.reportNodeStack.isEmpty()) {
            this.preProcessingEvents.add(event);
        } else if (event instanceof ElementProcessingEvent) {
            ReportNode reportNode = this.getReportNode(((ElementProcessingEvent)event).getElement());
            if (reportNode != null) {
                reportNode.elementProcessingEvents.add(event);
            }
        } else {
            this.processingEvents.add(event);
        }
    }

    @Override
    protected boolean ignoreEvent(ExecutionEvent event) {
        if (!super.ignoreEvent(event)) {
            if (event instanceof ResourceBasedEvent && !this.reportConfiguration.showDefaultAppliedResources()) {
                return ((ResourceBasedEvent)((Object)event)).getResourceConfig().isDefaultResource();
            }
            return false;
        }
        return true;
    }

    private void processLifecycleEvent(FilterLifecycleEvent event) {
        try {
            if (event.getEventType() != FilterLifecycleEvent.EventType.FINISHED) {
                ContentDeliveryConfig deliveryConfig = Filter.getCurrentExecutionContext().getDeliveryConfig();
                if (event instanceof DOMFilterLifecycleEvent) {
                    DOMFilterLifecycleEvent domEvent = (DOMFilterLifecycleEvent)event;
                    if (domEvent.getDOMEventType() == DOMFilterLifecycleEvent.DOMEventType.PROCESSING_STARTED) {
                        this.mapMessageNodeVists(((DOMReport)this.report).getAssemblies());
                    } else if (domEvent.getDOMEventType() == DOMFilterLifecycleEvent.DOMEventType.SERIALIZATION_STARTED) {
                        this.mapMessageNodeVists(this.report.getProcessings());
                    }
                } else if (event.getEventType() == FilterLifecycleEvent.EventType.STARTED) {
                    this.executionContext = Filter.getCurrentExecutionContext();
                    this.report = deliveryConfig instanceof DOMContentDeliveryConfig ? new DOMReport() : new Report();
                    this.mapConfigBuilderEvents(deliveryConfig.getConfigBuilderEvents());
                }
            } else {
                this.processFinishEvent();
            }
        }
        catch (IOException e) {
            throw new SmooksException("Failed to write report.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFinishEvent() throws IOException {
        if (this.report instanceof DOMReport) {
            if (this.report.getProcessings().isEmpty()) {
                this.mapMessageNodeVists(this.report.getProcessings());
            } else {
                this.mapMessageNodeVists(((DOMReport)this.report).getSerializations());
            }
        } else {
            this.mapMessageNodeVists(this.report.getProcessings());
        }
        ResultNode resultNode = new ResultNode();
        Result result = FilterResult.getResult(this.executionContext);
        this.report.setResult(resultNode);
        if (result != null) {
            if (result instanceof JavaResult) {
                resultNode.setSummary("This Smooks Filtering operation produced a JavaResult.  The following is an XML serialization of the JavaResult bean Map entries.");
            } else if (result instanceof StringResult) {
                resultNode.setSummary("This Smooks Filtering operation produced the following StreamResult.");
            } else {
                resultNode.setSummary("Cannot show Smooks Filtering Result.  Modify the code and use a '" + StringResult.class.getName() + "' Result in the call to the Smooks.filter() method.");
            }
            resultNode.setDetail(result.toString());
        } else {
            resultNode.setSummary("No Result.");
            resultNode.setDetail("");
        }
        try {
            this.applyTemplate(this.report);
        }
        finally {
            Writer writer = this.reportConfiguration.getOutputWriter();
            try {
                writer.flush();
            }
            finally {
                if (this.reportConfiguration.autoCloseWriter()) {
                    writer.close();
                }
            }
        }
    }

    private void processNewElementEvent(ReportNode node) {
        if (this.reportNodeStack.isEmpty()) {
            this.reportNodeStack.push(node);
        } else {
            ReportNode head = this.reportNodeStack.peek();
            while (head != null && node.depth <= head.depth) {
                this.reportNodeStack.pop();
                if (!this.reportNodeStack.isEmpty()) {
                    head = this.reportNodeStack.peek();
                    continue;
                }
                head = null;
            }
            node.parent = head;
            if (node.parent != null) {
                node.parent.children.add(node);
            }
            this.reportNodeStack.push(node);
        }
    }

    private void mapConfigBuilderEvents(List<ConfigBuilderEvent> configBuilderEvents) {
    }

    private void mapMessageNodeVists(List<MessageNode> visits) throws IOException {
        if (!this.allNodes.isEmpty()) {
            this.mapNode((ReportNode)this.reportNodeStack.elementAt(0), visits);
        }
        this.preProcessingEvents.clear();
        this.processingEvents.clear();
        this.reportNodeStack.clear();
        this.allNodes.clear();
    }

    private void mapNode(ReportNode reportNode, List<MessageNode> visits) throws IOException {
        MessageNode messageNode = new MessageNode();
        messageNode.setNodeId(this.messageNodeCounter);
        messageNode.setElementName(reportNode.getElementName());
        messageNode.setVisitBefore(true);
        messageNode.setDepth(reportNode.getDepth());
        this.mapNodeEvents(VisitSequence.BEFORE, reportNode, messageNode);
        visits.add(messageNode);
        ++this.messageNodeCounter;
        List children = reportNode.children;
        for (ReportNode child : children) {
            this.mapNode(child, visits);
        }
        messageNode = new MessageNode();
        messageNode.setNodeId(this.messageNodeCounter);
        messageNode.setElementName(reportNode.getElementName());
        messageNode.setVisitBefore(false);
        messageNode.setDepth(reportNode.getDepth());
        this.mapNodeEvents(VisitSequence.AFTER, reportNode, messageNode);
        visits.add(messageNode);
        ++this.messageNodeCounter;
    }

    private void mapNodeEvents(VisitSequence visitSequence, ReportNode reportNode, MessageNode messageNode) {
        List<ExecutionEvent> events = reportNode.getElementProcessingEvents();
        for (ExecutionEvent event : events) {
            ElementVisitEvent visitEvent;
            if (!(event instanceof ElementVisitEvent) || (visitEvent = (ElementVisitEvent)event).getSequence() != visitSequence) continue;
            ReportInfoNode reportInfoNode = new ReportInfoNode();
            ContentHandlerConfigMap configMapping = ((ElementVisitEvent)event).getConfigMapping();
            messageNode.addExecInfoNode(reportInfoNode);
            reportInfoNode.setNodeId(this.reportInfoNodeCounter);
            reportInfoNode.setSummary(configMapping.getContentHandler().getClass().getSimpleName() + ": " + visitEvent.getReportSummary());
            reportInfoNode.setDetail(visitEvent.getReportDetail());
            reportInfoNode.setResourceXML(configMapping.getResourceConfig().toXML());
            reportInfoNode.setContextState(visitEvent.getExecutionContextState());
            ++this.reportInfoNodeCounter;
        }
    }

    public abstract void applyTemplate(Report var1) throws IOException;

    private ReportNode getReportNode(Object element) {
        for (ReportNode node : this.allNodes) {
            if (node.element != element) continue;
            return node;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ReportNode {
        private ReportNode parent;
        private List<ReportNode> children = new ArrayList<ReportNode>();
        private Object element;
        private int depth;
        private List<ExecutionEvent> elementProcessingEvents = new ArrayList<ExecutionEvent>();

        public ReportNode(ElementPresentEvent eventPresentEvent) {
            this.element = eventPresentEvent.getElement();
            this.depth = eventPresentEvent.getDepth();
        }

        public String getElementName() {
            if (this.element instanceof SAXElement) {
                return ((SAXElement)this.element).getName().getLocalPart();
            }
            return DomUtils.getName((Element)this.element);
        }

        public String toString() {
            return this.element + " (depth " + this.depth + ")";
        }

        public ReportNode getParent() {
            return this.parent;
        }

        public List<ReportNode> getChildren() {
            return this.children;
        }

        public Object getElement() {
            return this.element;
        }

        public int getDepth() {
            return this.depth;
        }

        public List<ExecutionEvent> getElementProcessingEvents() {
            return this.elementProcessingEvents;
        }
    }
}

