/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.expression;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.expression.ExpressionEvaluationException;
import org.milyn.expression.ExpressionEvaluator;
import org.milyn.expression.MVELVariables;
import org.mvel.MVEL;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.integration.impl.MapVariableResolverFactory;

public class MVELExpressionEvaluator
implements ExpressionEvaluator {
    private static final String MVEL_VARIABLES_VARIABLE_NAME = "VARS";
    private String expression;
    private Serializable compiled;

    public void setExpression(String expression) throws SmooksConfigurationException {
        this.expression = expression.trim();
        this.compiled = MVEL.compileExpression((String)this.expression);
    }

    public String getExpression() {
        return this.expression;
    }

    public boolean eval(Object contextObject) throws ExpressionEvaluationException {
        return (Boolean)this.getValue(contextObject);
    }

    public Object getValue(Object contextObject) throws ExpressionEvaluationException {
        try {
            if (contextObject instanceof Map) {
                MapVariableResolverFactory contextVariableResolverFactory = new MapVariableResolverFactory((Map)contextObject);
                MapVariableResolverFactory variableResolverFactory = new MapVariableResolverFactory(new HashMap());
                variableResolverFactory.setNextFactory((VariableResolverFactory)contextVariableResolverFactory);
                variableResolverFactory.createVariable(MVEL_VARIABLES_VARIABLE_NAME, (Object)new MVELVariables((VariableResolverFactory)variableResolverFactory));
                return MVEL.executeExpression((Object)this.compiled, (VariableResolverFactory)variableResolverFactory);
            }
            return MVEL.executeExpression((Object)this.compiled, (Object)contextObject, (VariableResolverFactory)new MapVariableResolverFactory(new HashMap()));
        }
        catch (Exception e) {
            String msg = "Error evaluating MVEL expression '" + this.expression + "' against object type '" + contextObject.getClass().getName() + "'. " + "Common issues include:" + "\n\t\t1. Referencing a variable that is not bound into the context.";
            if (contextObject instanceof Map) {
                msg = msg + " In this case use VARS.isdef(\"someVar\") to check if the variable is bound in the context.";
            }
            msg = msg + "\n\t\t2. Invalid expression reference to a List/Array based variable token.  Example List/Array referencing expression token: 'order.orderItems[0].productId'.";
            throw new ExpressionEvaluationException(msg, e);
        }
    }
}

