/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.decoders;

import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.javabean.DataDecodeException;
import org.milyn.javabean.DataDecoder;
import org.milyn.javabean.DecodeType;
import org.milyn.javabean.decoders.MappingDecoder;
import org.milyn.util.ClassUtil;

@DecodeType(value={Enum.class})
public class EnumDecoder
implements DataDecoder {
    private Class enumType;
    private MappingDecoder mappingDecoder = new MappingDecoder();

    public void setConfiguration(SmooksResourceConfiguration resourceConfig) throws SmooksConfigurationException {
        String enumTypeName = resourceConfig.getStringParameter("enumType");
        if (enumTypeName == null || enumTypeName.trim().equals("")) {
            throw new SmooksConfigurationException("Invalid EnumDecoder configuration. 'enumType' param not specified.");
        }
        try {
            this.enumType = ClassUtil.forName((String)enumTypeName.trim(), EnumDecoder.class);
        }
        catch (ClassNotFoundException e) {
            throw new SmooksConfigurationException("Invalid Enum decoder configuration.  Failed to resolve '" + enumTypeName + "' as a Java Enum Class.", e);
        }
        if (!Enum.class.isAssignableFrom(this.enumType)) {
            throw new SmooksConfigurationException("Invalid Enum decoder configuration.  Resolved 'enumType' '" + enumTypeName + "' is not a Java Enum Class.");
        }
        this.mappingDecoder.setConfiguration(resourceConfig);
        this.mappingDecoder.setStrict(false);
    }

    public Object decode(String data) throws DataDecodeException {
        String mappedValue = (String)this.mappingDecoder.decode(data);
        try {
            return Enum.valueOf(this.enumType, mappedValue.trim());
        }
        catch (IllegalArgumentException e) {
            throw new DataDecodeException("Failed to decode '" + mappedValue + "' as a valid Enum constant of type '" + this.enumType.getName() + "'.");
        }
    }
}

