/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.decoders;

import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.javabean.DataDecodeException;
import org.milyn.javabean.DataDecoder;

public class MappingDecoder
implements DataDecoder {
    private SmooksResourceConfiguration resourceConfig;
    private boolean strict = true;

    public void setConfiguration(SmooksResourceConfiguration resourceConfig) throws SmooksConfigurationException {
        this.resourceConfig = resourceConfig;
        this.strict = resourceConfig.getBoolParameter("strict", true);
    }

    public Object decode(String data) throws DataDecodeException {
        String mappingValue = this.resourceConfig.getStringParameter(data);
        if (mappingValue == null) {
            if (this.strict) {
                throw new DataDecodeException("Mapping <param> for data '" + data + "' not defined.");
            }
            return data;
        }
        return mappingValue;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }
}

