/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.record;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.minidns.record.Data;
import org.minidns.record.Record;

public class TXT
extends Data {
    private final byte[] blob;

    public static TXT parse(DataInputStream dis, int length) throws IOException {
        byte[] blob = new byte[length];
        dis.readFully(blob);
        return new TXT(blob);
    }

    public TXT(byte[] blob) {
        this.blob = blob;
    }

    public byte[] getBlob() {
        return (byte[])this.blob.clone();
    }

    public String getText() {
        int i;
        List<byte[]> extents = this.getExtents();
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < extents.size() - 1; ++i) {
            sb.append(new String(extents.get(i))).append(" / ");
        }
        sb.append(new String(extents.get(i)));
        return sb.toString();
    }

    public List<byte[]> getExtents() {
        int segLength;
        ArrayList<byte[]> extents = new ArrayList<byte[]>();
        for (int used = 0; used < this.blob.length; used += segLength) {
            segLength = 0xFF & this.blob[used];
            int end = ++used + segLength;
            byte[] extent = Arrays.copyOfRange(this.blob, used, end);
            extents.add(extent);
        }
        return extents;
    }

    @Override
    public void serialize(DataOutputStream dos) throws IOException {
        dos.write(this.blob);
    }

    @Override
    public Record.TYPE getType() {
        return Record.TYPE.TXT;
    }

    public String toString() {
        return "\"" + this.getText() + "\"";
    }
}

