/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnssec;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.minidns.DnsCache;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsmessage.Question;
import org.minidns.dnsname.DnsName;
import org.minidns.dnsqueryresult.DnsQueryResult;
import org.minidns.dnssec.DnssecQueryResult;
import org.minidns.dnssec.DnssecUnverifiedReason;
import org.minidns.dnssec.DnssecValidationFailedException;
import org.minidns.dnssec.Verifier;
import org.minidns.iterative.ReliableDnsClient;
import org.minidns.record.DLV;
import org.minidns.record.DNSKEY;
import org.minidns.record.DS;
import org.minidns.record.Data;
import org.minidns.record.DelegatingDnssecRR;
import org.minidns.record.NSEC;
import org.minidns.record.NSEC3;
import org.minidns.record.RRSIG;
import org.minidns.record.Record;

public class DnssecClient
extends ReliableDnsClient {
    private static final BigInteger rootEntryKey = new BigInteger("1628686155461064465348252249725010996177649738666492500572664444461532807739744536029771810659241049343994038053541290419968870563183856865780916376571550372513476957870843322273120879361960335192976656756972171258658400305760429696147778001233984421619267530978084631948434496468785021389956803104620471232008587410372348519229650742022804219634190734272506220018657920136902014393834092648785514548876370028925405557661759399901378816916683122474038734912535425670533237815676134840739565610963796427401855723026687073600445461090736240030247906095053875491225879656640052743394090544036297390104110989318819106653199917493");
    private static final DnsName DEFAULT_DLV = DnsName.from((String)"dlv.isc.org");
    private final Map<DnsName, byte[]> knownSeps = new ConcurrentHashMap<DnsName, byte[]>();
    private boolean stripSignatureRecords = true;
    private DnsName dlv;

    public DnssecClient() {
        this((DnsCache)DEFAULT_CACHE);
    }

    public DnssecClient(DnsCache cache) {
        super(cache);
        this.addSecureEntryPoint(DnsName.ROOT, rootEntryKey.toByteArray());
    }

    public DnsQueryResult query(Question q) throws IOException {
        DnssecQueryResult dnssecQueryResult = this.queryDnssec(q);
        if (!dnssecQueryResult.isAuthenticData()) {
            throw new IOException();
        }
        return dnssecQueryResult.dnsQueryResult;
    }

    public DnssecQueryResult queryDnssec(CharSequence name, Record.TYPE type) throws IOException {
        Question q = new Question(name, type, Record.CLASS.IN);
        return this.queryDnssec(q);
    }

    public DnssecQueryResult queryDnssec(Question q) throws IOException {
        DnsQueryResult dnsQueryResult = super.query(q);
        DnssecQueryResult dnssecQueryResult = this.performVerification(dnsQueryResult);
        return dnssecQueryResult;
    }

    private DnssecQueryResult performVerification(DnsQueryResult dnsQueryResult) throws IOException {
        if (dnsQueryResult == null) {
            return null;
        }
        DnsMessage dnsMessage = dnsQueryResult.response;
        DnsMessage.Builder messageBuilder = dnsMessage.asBuilder();
        Set<DnssecUnverifiedReason> unverifiedReasons = this.verify(dnsMessage);
        messageBuilder.setAuthenticData(unverifiedReasons.isEmpty());
        List answers = dnsMessage.answerSection;
        List nameserverRecords = dnsMessage.authoritySection;
        List additionalResourceRecords = dnsMessage.additionalSection;
        HashSet<Record<RRSIG>> signatures = new HashSet<Record<RRSIG>>();
        Record.filter(signatures, RRSIG.class, (Collection)answers);
        Record.filter(signatures, RRSIG.class, (Collection)nameserverRecords);
        Record.filter(signatures, RRSIG.class, (Collection)additionalResourceRecords);
        if (this.stripSignatureRecords) {
            messageBuilder.setAnswers(DnssecClient.stripSignatureRecords(answers));
            messageBuilder.setNameserverRecords(DnssecClient.stripSignatureRecords(nameserverRecords));
            messageBuilder.setAdditionalResourceRecords(DnssecClient.stripSignatureRecords(additionalResourceRecords));
        }
        return new DnssecQueryResult(messageBuilder.build(), dnsQueryResult, signatures, unverifiedReasons);
    }

    private static List<Record<? extends Data>> stripSignatureRecords(List<Record<? extends Data>> records) {
        if (records.isEmpty()) {
            return records;
        }
        ArrayList<Record<? extends Data>> recordList = new ArrayList<Record<? extends Data>>(records.size());
        for (Record<? extends Data> record : records) {
            if (record.type == Record.TYPE.RRSIG) continue;
            recordList.add(record);
        }
        return recordList;
    }

    private Set<DnssecUnverifiedReason> verify(DnsMessage dnsMessage) throws IOException {
        if (!dnsMessage.answerSection.isEmpty()) {
            return this.verifyAnswer(dnsMessage);
        }
        return this.verifyNsec(dnsMessage);
    }

    private Set<DnssecUnverifiedReason> verifyAnswer(DnsMessage dnsMessage) throws IOException {
        Question q = (Question)dnsMessage.questions.get(0);
        List answers = dnsMessage.answerSection;
        List toBeVerified = dnsMessage.copyAnswers();
        VerifySignaturesResult verifiedSignatures = this.verifySignatures(q, answers, toBeVerified);
        Set<DnssecUnverifiedReason> result = verifiedSignatures.reasons;
        if (!result.isEmpty()) {
            return result;
        }
        boolean sepSignatureValid = false;
        HashSet<DnssecUnverifiedReason> sepReasons = new HashSet<DnssecUnverifiedReason>();
        Iterator iterator = toBeVerified.iterator();
        while (iterator.hasNext()) {
            Record record = ((Record)iterator.next()).ifPossibleAs(DNSKEY.class);
            if (record == null) continue;
            Set<DnssecUnverifiedReason> reasons = this.verifySecureEntryPoint((Record<DNSKEY>)record);
            if (reasons.isEmpty()) {
                sepSignatureValid = true;
            } else {
                sepReasons.addAll(reasons);
            }
            if (!verifiedSignatures.sepSignaturePresent) {
                LOGGER.finer("SEP key is not self-signed.");
            }
            iterator.remove();
        }
        if (verifiedSignatures.sepSignaturePresent && !sepSignatureValid) {
            result.addAll(sepReasons);
        }
        if (verifiedSignatures.sepSignatureRequired && !verifiedSignatures.sepSignaturePresent) {
            result.add(new DnssecUnverifiedReason.NoSecureEntryPointReason(q.name));
        }
        if (!toBeVerified.isEmpty()) {
            if (toBeVerified.size() != answers.size()) {
                throw new DnssecValidationFailedException(q, "Only some records are signed!");
            }
            result.add(new DnssecUnverifiedReason.NoSignaturesReason(q));
        }
        return result;
    }

    private Set<DnssecUnverifiedReason> verifyNsec(DnsMessage dnsMessage) throws IOException {
        HashSet<DnssecUnverifiedReason> result = new HashSet<DnssecUnverifiedReason>();
        Question q = (Question)dnsMessage.questions.get(0);
        boolean validNsec = false;
        boolean nsecPresent = false;
        DnsName zone = null;
        List authoritySection = dnsMessage.authoritySection;
        for (Record authorityRecord : authoritySection) {
            if (authorityRecord.type != Record.TYPE.SOA) continue;
            zone = authorityRecord.name;
            break;
        }
        if (zone == null) {
            throw new DnssecValidationFailedException.AuthorityDoesNotContainSoa(dnsMessage);
        }
        block5: for (Record record : authoritySection) {
            DnssecUnverifiedReason reason;
            switch (record.type) {
                case NSEC: {
                    nsecPresent = true;
                    Record nsecRecord = record.as(NSEC.class);
                    reason = Verifier.verifyNsec((Record<NSEC>)nsecRecord, q);
                    break;
                }
                case NSEC3: {
                    nsecPresent = true;
                    Record nsec3Record = record.as(NSEC3.class);
                    reason = Verifier.verifyNsec3(zone, (Record<NSEC3>)nsec3Record, q);
                    break;
                }
                default: {
                    continue block5;
                }
            }
            if (reason != null) {
                result.add(reason);
                continue;
            }
            validNsec = true;
        }
        if (nsecPresent && !validNsec) {
            throw new DnssecValidationFailedException(q, "Invalid NSEC!");
        }
        List toBeVerified = dnsMessage.copyAuthority();
        VerifySignaturesResult verifiedSignatures = this.verifySignatures(q, authoritySection, toBeVerified);
        if (validNsec && verifiedSignatures.reasons.isEmpty()) {
            result.clear();
        } else {
            result.addAll(verifiedSignatures.reasons);
        }
        if (!toBeVerified.isEmpty() && toBeVerified.size() != authoritySection.size()) {
            throw new DnssecValidationFailedException(q, "Only some resource records from the authority section are signed!");
        }
        return result;
    }

    private VerifySignaturesResult verifySignatures(Question q, Collection<Record<? extends Data>> reference, List<Record<? extends Data>> toBeVerified) throws IOException {
        Date now = new Date();
        LinkedList<RRSIG> outdatedRrSigs = new LinkedList<RRSIG>();
        VerifySignaturesResult result = new VerifySignaturesResult();
        ArrayList<Record> rrsigs = new ArrayList<Record>(toBeVerified.size());
        for (Record<? extends Data> recordToBeVerified : toBeVerified) {
            Record record = recordToBeVerified.ifPossibleAs(RRSIG.class);
            if (record == null) continue;
            RRSIG rrsig = (RRSIG)record.payloadData;
            if (rrsig.signatureExpiration.compareTo(now) < 0 || rrsig.signatureInception.compareTo(now) > 0) {
                outdatedRrSigs.add(rrsig);
                continue;
            }
            rrsigs.add(record);
        }
        if (rrsigs.isEmpty()) {
            if (!outdatedRrSigs.isEmpty()) {
                result.reasons.add(new DnssecUnverifiedReason.NoActiveSignaturesReason(q, outdatedRrSigs));
            } else {
                result.reasons.add(new DnssecUnverifiedReason.NoSignaturesReason(q));
            }
            return result;
        }
        for (Record sigRecord : rrsigs) {
            RRSIG rrsig = (RRSIG)sigRecord.payloadData;
            ArrayList<Record<? extends Data>> records = new ArrayList<Record<? extends Data>>(reference.size());
            for (Record<? extends Data> record : reference) {
                if (record.type != rrsig.typeCovered || !record.name.equals((Object)sigRecord.name)) continue;
                records.add(record);
            }
            Set<DnssecUnverifiedReason> reasons = this.verifySignedRecords(q, rrsig, records);
            result.reasons.addAll(reasons);
            if (q.name.equals((Object)rrsig.signerName) && rrsig.typeCovered == Record.TYPE.DNSKEY) {
                Iterator iterator = records.iterator();
                while (iterator.hasNext()) {
                    Record dnsKeyRecord = ((Record)iterator.next()).ifPossibleAs(DNSKEY.class);
                    DNSKEY dnskey = (DNSKEY)dnsKeyRecord.payloadData;
                    iterator.remove();
                    if (dnskey.getKeyTag() != rrsig.keyTag) continue;
                    result.sepSignaturePresent = true;
                }
                result.sepSignatureRequired = true;
            }
            if (!DnssecClient.isParentOrSelf(sigRecord.name.ace, rrsig.signerName.ace)) {
                LOGGER.finer("Records at " + sigRecord.name + " are cross-signed with a key from " + rrsig.signerName);
            } else {
                toBeVerified.removeAll(records);
            }
            toBeVerified.remove(sigRecord);
        }
        return result;
    }

    private static boolean isParentOrSelf(String child, String parent) {
        if (child.equals(parent)) {
            return true;
        }
        if (parent.isEmpty()) {
            return true;
        }
        String[] childSplit = child.split("\\.");
        String[] parentSplit = parent.split("\\.");
        if (parentSplit.length > childSplit.length) {
            return false;
        }
        for (int i = 1; i <= parentSplit.length; ++i) {
            if (parentSplit[parentSplit.length - i].equals(childSplit[childSplit.length - i])) continue;
            return false;
        }
        return true;
    }

    private Set<DnssecUnverifiedReason> verifySignedRecords(Question q, RRSIG rrsig, List<Record<? extends Data>> records) throws IOException {
        HashSet<DnssecUnverifiedReason> result = new HashSet<DnssecUnverifiedReason>();
        DNSKEY dnskey = null;
        if (rrsig.typeCovered == Record.TYPE.DNSKEY) {
            List dnskeyRrs = Record.filter(DNSKEY.class, records);
            for (Record dnsKeyRecord : dnskeyRrs) {
                if (((DNSKEY)dnsKeyRecord.payloadData).getKeyTag() != rrsig.keyTag) continue;
                dnskey = (DNSKEY)dnsKeyRecord.payloadData;
                break;
            }
        } else {
            if (q.type == Record.TYPE.DS && rrsig.signerName.equals((Object)q.name)) {
                result.add(new DnssecUnverifiedReason.NoTrustAnchorReason(q.name));
                return result;
            }
            DnssecQueryResult dnskeyRes = this.queryDnssec((CharSequence)rrsig.signerName, Record.TYPE.DNSKEY);
            result.addAll(dnskeyRes.getUnverifiedReasons());
            List dnskeyRrs = dnskeyRes.dnsQueryResult.response.filterAnswerSectionBy(DNSKEY.class);
            for (Record dnsKeyRecord : dnskeyRrs) {
                if (((DNSKEY)dnsKeyRecord.payloadData).getKeyTag() != rrsig.keyTag) continue;
                dnskey = (DNSKEY)dnsKeyRecord.payloadData;
                break;
            }
        }
        if (dnskey == null) {
            throw new DnssecValidationFailedException(q, records.size() + " " + rrsig.typeCovered + " record(s) are signed using an unknown key.");
        }
        DnssecUnverifiedReason unverifiedReason = Verifier.verify(records, rrsig, dnskey);
        if (unverifiedReason != null) {
            result.add(unverifiedReason);
        }
        return result;
    }

    private Set<DnssecUnverifiedReason> verifySecureEntryPoint(Record<DNSKEY> sepRecord) throws IOException {
        DNSKEY dnskey = (DNSKEY)sepRecord.payloadData;
        HashSet<DnssecUnverifiedReason> unverifiedReasons = new HashSet<DnssecUnverifiedReason>();
        Set<Object> activeReasons = new HashSet();
        if (this.knownSeps.containsKey(sepRecord.name)) {
            if (dnskey.keyEquals(this.knownSeps.get(sepRecord.name))) {
                return unverifiedReasons;
            }
            unverifiedReasons.add(new DnssecUnverifiedReason.ConflictsWithSep(sepRecord));
            return unverifiedReasons;
        }
        if (sepRecord.name.isRootLabel()) {
            unverifiedReasons.add(new DnssecUnverifiedReason.NoRootSecureEntryPointReason());
            return unverifiedReasons;
        }
        DS delegation = null;
        DnssecQueryResult dsResp = this.queryDnssec((CharSequence)sepRecord.name, Record.TYPE.DS);
        unverifiedReasons.addAll(dsResp.getUnverifiedReasons());
        List dsRrs = dsResp.dnsQueryResult.response.filterAnswerSectionBy(DS.class);
        for (Record dsRecord : dsRrs) {
            DS ds = (DS)dsRecord.payloadData;
            if (dnskey.getKeyTag() != ds.keyTag) continue;
            delegation = ds;
            activeReasons = dsResp.getUnverifiedReasons();
            break;
        }
        if (delegation == null) {
            LOGGER.fine("There is no DS record for " + sepRecord.name + ", server gives empty result");
        }
        if (delegation == null && this.dlv != null && !this.dlv.isChildOf(sepRecord.name)) {
            DnssecQueryResult dlvResp = this.queryDnssec((CharSequence)DnsName.from((DnsName)sepRecord.name, (DnsName)this.dlv), Record.TYPE.DLV);
            unverifiedReasons.addAll(dlvResp.getUnverifiedReasons());
            List dlvRrs = dlvResp.dnsQueryResult.response.filterAnswerSectionBy(DLV.class);
            for (Record dlvRecord : dlvRrs) {
                if (((DNSKEY)sepRecord.payloadData).getKeyTag() != ((DLV)dlvRecord.payloadData).keyTag) continue;
                LOGGER.fine("Found DLV for " + sepRecord.name + ", awesome.");
                delegation = (DelegatingDnssecRR)dlvRecord.payloadData;
                activeReasons = dlvResp.getUnverifiedReasons();
                break;
            }
        }
        if (delegation != null) {
            DnssecUnverifiedReason unverifiedReason = Verifier.verify(sepRecord, delegation);
            if (unverifiedReason != null) {
                unverifiedReasons.add(unverifiedReason);
            } else {
                unverifiedReasons = activeReasons;
            }
        } else if (unverifiedReasons.isEmpty()) {
            unverifiedReasons.add(new DnssecUnverifiedReason.NoTrustAnchorReason(sepRecord.name));
        }
        return unverifiedReasons;
    }

    protected DnsMessage.Builder newQuestion(DnsMessage.Builder message) {
        message.getEdnsBuilder().setUdpPayloadSize(this.dataSource.getUdpPayloadSize()).setDnssecOk();
        message.setCheckingDisabled(true);
        return super.newQuestion(message);
    }

    protected String isResponseAcceptable(DnsMessage response) {
        boolean dnssecOk = response.isDnssecOk();
        if (!dnssecOk) {
            return "DNSSEC OK (DO) flag not set in response";
        }
        boolean checkingDisabled = response.checkingDisabled;
        if (!checkingDisabled) {
            return "CHECKING DISABLED (CD) flag not set in response";
        }
        return super.isResponseAcceptable(response);
    }

    public void addSecureEntryPoint(DnsName name, byte[] key) {
        this.knownSeps.put(name, key);
    }

    public void removeSecureEntryPoint(DnsName name) {
        this.knownSeps.remove(name);
    }

    public void clearSecureEntryPoints() {
        this.knownSeps.clear();
    }

    public boolean isStripSignatureRecords() {
        return this.stripSignatureRecords;
    }

    public void setStripSignatureRecords(boolean stripSignatureRecords) {
        this.stripSignatureRecords = stripSignatureRecords;
    }

    public void enableLookasideValidation() {
        this.configureLookasideValidation(DEFAULT_DLV);
    }

    public void disableLookasideValidation() {
        this.configureLookasideValidation(null);
    }

    public void configureLookasideValidation(DnsName dlv) {
        this.dlv = dlv;
    }

    private static class VerifySignaturesResult {
        boolean sepSignatureRequired = false;
        boolean sepSignaturePresent = false;
        Set<DnssecUnverifiedReason> reasons = new HashSet<DnssecUnverifiedReason>();

        private VerifySignaturesResult() {
        }
    }
}

