/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.introspectingfilter;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;

public class OAuth2AccessTokenImpl
implements OAuth2AccessToken {
    private JsonObject token;
    private String tokenString;
    private Set<String> scopes = new HashSet<String>();
    private Date expireDate;

    public OAuth2AccessTokenImpl(JsonObject token, String tokenString) {
        this.token = token;
        this.tokenString = tokenString;
        if (token.get("scope") != null) {
            this.scopes = Sets.newHashSet((Iterable)Splitter.on((String)" ").split((CharSequence)token.get("scope").getAsString()));
        }
        if (token.get("exp") != null) {
            this.expireDate = new Date(token.get("exp").getAsLong() * 1000L);
        }
    }

    public Map<String, Object> getAdditionalInformation() {
        return null;
    }

    public Set<String> getScope() {
        return this.scopes;
    }

    public OAuth2RefreshToken getRefreshToken() {
        return null;
    }

    public String getTokenType() {
        return "Bearer";
    }

    public boolean isExpired() {
        return this.expireDate != null && this.expireDate.before(new Date());
    }

    public Date getExpiration() {
        return this.expireDate;
    }

    public int getExpiresIn() {
        if (this.expireDate != null) {
            return (int)TimeUnit.MILLISECONDS.toSeconds(this.expireDate.getTime() - new Date().getTime());
        }
        return 0;
    }

    public String getValue() {
        return this.tokenString;
    }
}

