/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.client;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.mitre.openid.connect.client.SubjectIssuerGrantedAuthority;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.NullAuthoritiesMapper;

public class NamedAdminAuthoritiesMapper
implements GrantedAuthoritiesMapper {
    private static final SimpleGrantedAuthority ROLE_ADMIN = new SimpleGrantedAuthority("ROLE_ADMIN");
    private static final SimpleGrantedAuthority ROLE_USER = new SimpleGrantedAuthority("ROLE_USER");
    private Set<SubjectIssuerGrantedAuthority> admins = new HashSet<SubjectIssuerGrantedAuthority>();
    private GrantedAuthoritiesMapper chain = new NullAuthoritiesMapper();

    public Collection<? extends GrantedAuthority> mapAuthorities(Collection<? extends GrantedAuthority> authorities) {
        HashSet<Object> out = new HashSet<Object>();
        out.addAll(authorities);
        for (GrantedAuthority grantedAuthority : authorities) {
            if (!this.admins.contains(grantedAuthority)) continue;
            out.add(ROLE_ADMIN);
        }
        out.add(ROLE_USER);
        return this.chain.mapAuthorities(out);
    }

    public Set<SubjectIssuerGrantedAuthority> getAdmins() {
        return this.admins;
    }

    public void setAdmins(Set<SubjectIssuerGrantedAuthority> admins) {
        this.admins = admins;
    }

    public GrantedAuthoritiesMapper getChain() {
        return this.chain;
    }

    public void setChain(GrantedAuthoritiesMapper chain) {
        this.chain = chain;
    }
}

