/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.client;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.mitre.openid.connect.client.NamedAdminAuthoritiesMapper;
import org.mitre.openid.connect.client.SubjectIssuerGrantedAuthority;
import org.mitre.openid.connect.client.UserInfoFetcher;
import org.mitre.openid.connect.model.OIDCAuthenticationToken;
import org.mitre.openid.connect.model.UserInfo;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class OIDCAuthenticationProvider
implements AuthenticationProvider {
    private UserInfoFetcher userInfoFetcher = new UserInfoFetcher();
    private GrantedAuthoritiesMapper authoritiesMapper = new NamedAdminAuthoritiesMapper();

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!this.supports(authentication.getClass())) {
            return null;
        }
        if (authentication instanceof OIDCAuthenticationToken) {
            OIDCAuthenticationToken token = (OIDCAuthenticationToken)authentication;
            ArrayList authorities = Lists.newArrayList((Object[])new SubjectIssuerGrantedAuthority[]{new SubjectIssuerGrantedAuthority(token.getSub(), token.getIssuer())});
            UserInfo userInfo = this.userInfoFetcher.loadUserInfo(token);
            if (userInfo != null && !Strings.isNullOrEmpty((String)userInfo.getSub()) && !userInfo.getSub().equals(token.getSub())) {
                throw new UsernameNotFoundException("user_id mismatch between id_token and user_info call: " + token.getSub() + " / " + userInfo.getSub());
            }
            return new OIDCAuthenticationToken(token.getSub(), token.getIssuer(), userInfo, this.authoritiesMapper.mapAuthorities((Collection)authorities), token.getIdTokenValue(), token.getAccessTokenValue(), token.getRefreshTokenValue());
        }
        return null;
    }

    public void setAuthoritiesMapper(GrantedAuthoritiesMapper authoritiesMapper) {
        this.authoritiesMapper = authoritiesMapper;
    }

    public boolean supports(Class<?> authentication) {
        return OIDCAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

