/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.client;

import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URI;
import org.apache.http.client.HttpClient;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.SystemDefaultHttpClient;
import org.mitre.openid.connect.config.ServerConfiguration;
import org.mitre.openid.connect.model.DefaultUserInfo;
import org.mitre.openid.connect.model.OIDCAuthenticationToken;
import org.mitre.openid.connect.model.UserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.RestTemplate;

public class UserInfoFetcher {
    private Logger logger = LoggerFactory.getLogger(UserInfoFetcher.class);

    public UserInfo loadUserInfo(final OIDCAuthenticationToken token) {
        ServerConfiguration serverConfiguration = token.getServerConfiguration();
        if (serverConfiguration == null) {
            this.logger.warn("No server configuration found.");
            return null;
        }
        if (Strings.isNullOrEmpty((String)serverConfiguration.getUserInfoUri())) {
            this.logger.warn("No userinfo endpoint, not fetching.");
            return null;
        }
        try {
            RestTemplate restTemplate;
            SystemDefaultHttpClient httpClient = new SystemDefaultHttpClient();
            HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
            String userInfoString = null;
            if (serverConfiguration.getUserInfoTokenMethod() == null || serverConfiguration.getUserInfoTokenMethod().equals((Object)ServerConfiguration.UserInfoTokenMethod.HEADER)) {
                RestTemplate restTemplate2 = new RestTemplate((ClientHttpRequestFactory)factory){

                    protected ClientHttpRequest createRequest(URI url, HttpMethod method) throws IOException {
                        ClientHttpRequest httpRequest = super.createRequest(url, method);
                        httpRequest.getHeaders().add("Authorization", String.format("Bearer %s", token.getAccessTokenValue()));
                        return httpRequest;
                    }
                };
                userInfoString = (String)restTemplate2.getForObject(serverConfiguration.getUserInfoUri(), String.class, new Object[0]);
            } else if (serverConfiguration.getUserInfoTokenMethod().equals((Object)ServerConfiguration.UserInfoTokenMethod.FORM)) {
                LinkedMultiValueMap form = new LinkedMultiValueMap();
                form.add((Object)"access_token", (Object)token.getAccessTokenValue());
                restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
                userInfoString = (String)restTemplate.postForObject(serverConfiguration.getUserInfoUri(), (Object)form, String.class, new Object[0]);
            } else if (serverConfiguration.getUserInfoTokenMethod().equals((Object)ServerConfiguration.UserInfoTokenMethod.QUERY)) {
                URIBuilder builder = new URIBuilder(serverConfiguration.getUserInfoUri());
                builder.setParameter("access_token", token.getAccessTokenValue());
                restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
                userInfoString = (String)restTemplate.getForObject(builder.toString(), String.class, new Object[0]);
            }
            if (!Strings.isNullOrEmpty((String)userInfoString)) {
                JsonObject userInfoJson = new JsonParser().parse(userInfoString).getAsJsonObject();
                UserInfo userInfo = DefaultUserInfo.fromJson((JsonObject)userInfoJson);
                return userInfo;
            }
            return null;
        }
        catch (Exception e) {
            this.logger.warn("Error fetching userinfo", (Throwable)e);
            return null;
        }
    }
}

