/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.client.keypublisher;

import com.google.common.base.Strings;
import java.util.Map;
import java.util.UUID;
import org.mitre.jwt.signer.service.JwtSigningAndValidationService;
import org.mitre.openid.connect.client.keypublisher.ClientKeyPublisherMapping;
import org.mitre.openid.connect.client.keypublisher.JwkViewResolver;
import org.mitre.openid.connect.view.JwkKeyListView;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.web.servlet.ModelAndView;

public class ClientKeyPublisher
implements BeanDefinitionRegistryPostProcessor {
    private JwtSigningAndValidationService signingAndValidationService;
    private String jwkPublishUrl;
    private BeanDefinitionRegistry registry;
    private String jwkViewName = "jwkKeyList";

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (!Strings.isNullOrEmpty((String)this.getJwkPublishUrl())) {
            BeanDefinitionBuilder clientKeyMapping = BeanDefinitionBuilder.rootBeanDefinition(ClientKeyPublisherMapping.class);
            BeanDefinitionBuilder viewResolver = BeanDefinitionBuilder.rootBeanDefinition(JwkViewResolver.class);
            if (!Strings.isNullOrEmpty((String)this.getJwkPublishUrl())) {
                clientKeyMapping.addPropertyValue("jwkPublishUrl", (Object)this.getJwkPublishUrl());
                this.jwkViewName = "jwkKeyList-" + UUID.randomUUID().toString();
                viewResolver.addPropertyValue("jwkViewName", (Object)this.jwkViewName);
                BeanDefinitionBuilder jwkView = BeanDefinitionBuilder.rootBeanDefinition(JwkKeyListView.class);
                this.registry.registerBeanDefinition("jwkKeyList", (BeanDefinition)jwkView.getBeanDefinition());
                viewResolver.addPropertyReference("jwk", "jwkKeyList");
            }
            this.registry.registerBeanDefinition("clientKeyMapping", (BeanDefinition)clientKeyMapping.getBeanDefinition());
            this.registry.registerBeanDefinition("jwkViewResolver", (BeanDefinition)viewResolver.getBeanDefinition());
        }
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.registry = registry;
    }

    public ModelAndView publishClientJwk() {
        Map keys = this.signingAndValidationService.getAllPublicKeys();
        return new ModelAndView(this.jwkViewName, "keys", (Object)keys);
    }

    public String getJwkPublishUrl() {
        return this.jwkPublishUrl;
    }

    public void setJwkPublishUrl(String jwkPublishUrl) {
        this.jwkPublishUrl = jwkPublishUrl;
    }

    public JwtSigningAndValidationService getSigningAndValidationService() {
        return this.signingAndValidationService;
    }

    public void setSigningAndValidationService(JwtSigningAndValidationService signingAndValidationService) {
        this.signingAndValidationService = signingAndValidationService;
    }
}

