/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.client.service.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.SystemDefaultHttpClient;
import org.mitre.oauth2.model.RegisteredClient;
import org.mitre.openid.connect.ClientDetailsEntityJsonProcessor;
import org.mitre.openid.connect.client.service.ClientConfigurationService;
import org.mitre.openid.connect.client.service.RegisteredClientService;
import org.mitre.openid.connect.client.service.impl.DynamicServerConfigurationService;
import org.mitre.openid.connect.client.service.impl.InMemoryRegisteredClientService;
import org.mitre.openid.connect.config.ServerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class DynamicRegistrationClientConfigurationService
implements ClientConfigurationService {
    private static Logger logger = LoggerFactory.getLogger(DynamicServerConfigurationService.class);
    private LoadingCache<ServerConfiguration, RegisteredClient> clients;
    private RegisteredClientService registeredClientService = new InMemoryRegisteredClientService();
    private RegisteredClient template;
    private Set<String> whitelist = new HashSet<String>();
    private Set<String> blacklist = new HashSet<String>();

    public DynamicRegistrationClientConfigurationService() {
        this.clients = CacheBuilder.newBuilder().build((CacheLoader)new DynamicClientRegistrationLoader());
    }

    @Override
    public RegisteredClient getClientConfiguration(ServerConfiguration issuer) {
        try {
            if (!this.whitelist.isEmpty() && !this.whitelist.contains(issuer)) {
                throw new AuthenticationServiceException("Whitelist was nonempty, issuer was not in whitelist: " + issuer);
            }
            if (this.blacklist.contains(issuer)) {
                throw new AuthenticationServiceException("Issuer was in blacklist: " + issuer);
            }
            return (RegisteredClient)this.clients.get((Object)issuer);
        }
        catch (UncheckedExecutionException ue) {
            logger.warn("Unable to get client configuration", (Throwable)ue);
            return null;
        }
        catch (ExecutionException e) {
            logger.warn("Unable to get client configuration", (Throwable)e);
            return null;
        }
    }

    public RegisteredClient getTemplate() {
        return this.template;
    }

    public void setTemplate(RegisteredClient template) {
        if (template != null) {
            template.setClientId(null);
            template.setClientSecret(null);
            template.setRegistrationClientUri(null);
            template.setRegistrationAccessToken(null);
        }
        this.template = template;
    }

    public RegisteredClientService getRegisteredClientService() {
        return this.registeredClientService;
    }

    public void setRegisteredClientService(RegisteredClientService registeredClientService) {
        this.registeredClientService = registeredClientService;
    }

    public Set<String> getWhitelist() {
        return this.whitelist;
    }

    public void setWhitelist(Set<String> whitelist) {
        this.whitelist = whitelist;
    }

    public Set<String> getBlacklist() {
        return this.blacklist;
    }

    public void setBlacklist(Set<String> blacklist) {
        this.blacklist = blacklist;
    }

    public class DynamicClientRegistrationLoader
    extends CacheLoader<ServerConfiguration, RegisteredClient> {
        private HttpClient httpClient = new SystemDefaultHttpClient();
        private HttpComponentsClientHttpRequestFactory httpFactory = new HttpComponentsClientHttpRequestFactory(this.httpClient);
        private Gson gson = new Gson();

        public RegisteredClient load(ServerConfiguration serverConfig) throws Exception {
            RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)this.httpFactory);
            RegisteredClient knownClient = DynamicRegistrationClientConfigurationService.this.registeredClientService.getByIssuer(serverConfig.getIssuer());
            if (knownClient == null) {
                JsonObject jsonRequest = ClientDetailsEntityJsonProcessor.serialize((RegisteredClient)DynamicRegistrationClientConfigurationService.this.template);
                String serializedClient = this.gson.toJson((JsonElement)jsonRequest);
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                headers.setAccept((List)Lists.newArrayList((Object[])new MediaType[]{MediaType.APPLICATION_JSON}));
                HttpEntity entity = new HttpEntity((Object)serializedClient, (MultiValueMap)headers);
                String registered = (String)restTemplate.postForObject(serverConfig.getRegistrationEndpointUri(), (Object)entity, String.class, new Object[0]);
                RegisteredClient client = ClientDetailsEntityJsonProcessor.parseRegistered((String)registered);
                DynamicRegistrationClientConfigurationService.this.registeredClientService.save(serverConfig.getIssuer(), client);
                return client;
            }
            if (knownClient.getClientId() == null) {
                HttpHeaders headers = new HttpHeaders();
                headers.set("Authorization", String.format("%s %s", "Bearer", knownClient.getRegistrationAccessToken()));
                headers.setAccept((List)Lists.newArrayList((Object[])new MediaType[]{MediaType.APPLICATION_JSON}));
                HttpEntity entity = new HttpEntity((MultiValueMap)headers);
                String registered = (String)restTemplate.exchange(knownClient.getRegistrationClientUri(), HttpMethod.GET, entity, String.class, new Object[0]).getBody();
                RegisteredClient client = ClientDetailsEntityJsonProcessor.parseRegistered((String)registered);
                return client;
            }
            return knownClient;
        }
    }
}

