/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.client.service.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.SystemDefaultHttpClient;
import org.mitre.discovery.util.JsonUtils;
import org.mitre.openid.connect.client.service.ServerConfigurationService;
import org.mitre.openid.connect.config.ServerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.web.client.RestTemplate;

public class DynamicServerConfigurationService
implements ServerConfigurationService {
    private static Logger logger = LoggerFactory.getLogger(DynamicServerConfigurationService.class);
    private LoadingCache<String, ServerConfiguration> servers;
    private Set<String> whitelist = new HashSet<String>();
    private Set<String> blacklist = new HashSet<String>();

    public DynamicServerConfigurationService() {
        this.servers = CacheBuilder.newBuilder().build((CacheLoader)new OpenIDConnectServiceConfigurationFetcher());
    }

    public Set<String> getWhitelist() {
        return this.whitelist;
    }

    public void setWhitelist(Set<String> whitelist) {
        this.whitelist = whitelist;
    }

    public Set<String> getBlacklist() {
        return this.blacklist;
    }

    public void setBlacklist(Set<String> blacklist) {
        this.blacklist = blacklist;
    }

    @Override
    public ServerConfiguration getServerConfiguration(String issuer) {
        try {
            if (!this.whitelist.isEmpty() && !this.whitelist.contains(issuer)) {
                throw new AuthenticationServiceException("Whitelist was nonempty, issuer was not in whitelist: " + issuer);
            }
            if (this.blacklist.contains(issuer)) {
                throw new AuthenticationServiceException("Issuer was in blacklist: " + issuer);
            }
            return (ServerConfiguration)this.servers.get((Object)issuer);
        }
        catch (UncheckedExecutionException ue) {
            logger.warn("Couldn't load configuration for " + issuer, (Throwable)ue);
            return null;
        }
        catch (ExecutionException e) {
            logger.warn("Couldn't load configuration for " + issuer, (Throwable)e);
            return null;
        }
    }

    private class OpenIDConnectServiceConfigurationFetcher
    extends CacheLoader<String, ServerConfiguration> {
        private HttpClient httpClient = new SystemDefaultHttpClient();
        private HttpComponentsClientHttpRequestFactory httpFactory = new HttpComponentsClientHttpRequestFactory(this.httpClient);
        private JsonParser parser = new JsonParser();

        private OpenIDConnectServiceConfigurationFetcher() {
        }

        public ServerConfiguration load(String issuer) throws Exception {
            RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)this.httpFactory);
            ServerConfiguration conf = new ServerConfiguration();
            String url = issuer + "/.well-known/openid-configuration";
            String jsonString = (String)restTemplate.getForObject(url, String.class, new Object[0]);
            JsonElement parsed = this.parser.parse(jsonString);
            if (parsed.isJsonObject()) {
                JsonObject o = parsed.getAsJsonObject();
                if (!o.has("issuer")) {
                    throw new IllegalStateException("Returned object did not have an 'issuer' field");
                }
                if (!issuer.equals(o.get("issuer").getAsString())) {
                    logger.info("Issuer used for discover was " + issuer + " but final issuer is " + o.get("issuer").getAsString());
                }
                conf.setIssuer(o.get("issuer").getAsString());
                conf.setAuthorizationEndpointUri(JsonUtils.getAsString((JsonObject)o, (String)"authorization_endpoint"));
                conf.setTokenEndpointUri(JsonUtils.getAsString((JsonObject)o, (String)"token_endpoint"));
                conf.setJwksUri(JsonUtils.getAsString((JsonObject)o, (String)"jwks_uri"));
                conf.setUserInfoUri(JsonUtils.getAsString((JsonObject)o, (String)"userinfo_endpoint"));
                conf.setRegistrationEndpointUri(JsonUtils.getAsString((JsonObject)o, (String)"registration_endpoint"));
                conf.setIntrospectionEndpointUri(JsonUtils.getAsString((JsonObject)o, (String)"introspection_endpoint"));
                conf.setAcrValuesSupported(JsonUtils.getAsStringList((JsonObject)o, (String)"acr_values_supported"));
                conf.setCheckSessionIframe(JsonUtils.getAsString((JsonObject)o, (String)"check_session_iframe"));
                conf.setClaimsLocalesSupported(JsonUtils.getAsStringList((JsonObject)o, (String)"claims_locales_supported"));
                conf.setClaimsParameterSupported(JsonUtils.getAsBoolean((JsonObject)o, (String)"claims_parameter_supported"));
                conf.setClaimsSupported(JsonUtils.getAsStringList((JsonObject)o, (String)"claims_supported"));
                conf.setDisplayValuesSupported(JsonUtils.getAsStringList((JsonObject)o, (String)"display_values_supported"));
                conf.setEndSessionEndpoint(JsonUtils.getAsString((JsonObject)o, (String)"end_session_endpoint"));
                conf.setGrantTypesSupported(JsonUtils.getAsStringList((JsonObject)o, (String)"grant_types_supported"));
                conf.setIdTokenSigningAlgValuesSupported(JsonUtils.getAsJwsAlgorithmList((JsonObject)o, (String)"id_token_signing_alg_values_supported"));
                conf.setIdTokenEncryptionAlgValuesSupported(JsonUtils.getAsJweAlgorithmList((JsonObject)o, (String)"id_token_encryption_alg_values_supported"));
                conf.setIdTokenEncryptionEncValuesSupported(JsonUtils.getAsEncryptionMethodList((JsonObject)o, (String)"id_token_encryption_enc_values_supported"));
                conf.setOpPolicyUri(JsonUtils.getAsString((JsonObject)o, (String)"op_policy_uri"));
                conf.setOpTosUri(JsonUtils.getAsString((JsonObject)o, (String)"op_tos_uri"));
                conf.setRequestObjectEncryptionAlgValuesSupported(JsonUtils.getAsJweAlgorithmList((JsonObject)o, (String)"request_object_encryption_alg_values_supported"));
                conf.setRequestObjectEncryptionEncValuesSupported(JsonUtils.getAsEncryptionMethodList((JsonObject)o, (String)"request_object_encryption_enc_values_supported"));
                conf.setRequestObjectSigningAlgValuesSupported(JsonUtils.getAsJwsAlgorithmList((JsonObject)o, (String)"request_object_signing_alg_values_supported"));
                conf.setRequestParameterSupported(JsonUtils.getAsBoolean((JsonObject)o, (String)"request_parameter_supported"));
                conf.setRequestUriParameterSupported(JsonUtils.getAsBoolean((JsonObject)o, (String)"request_uri_parameter_supported"));
                conf.setResponseTypesSupported(JsonUtils.getAsStringList((JsonObject)o, (String)"response_types_supported"));
                conf.setScopesSupported(JsonUtils.getAsStringList((JsonObject)o, (String)"scopes_supported"));
                conf.setSubjectTypesSupported(JsonUtils.getAsStringList((JsonObject)o, (String)"subject_types_supported"));
                conf.setServiceDocumentation(JsonUtils.getAsString((JsonObject)o, (String)"service_documentation"));
                conf.setTokenEndpointAuthMethodsSupported(JsonUtils.getAsStringList((JsonObject)o, (String)"token_endpoint_auth_methods"));
                conf.setTokenEndpointAuthSigningAlgValuesSupported(JsonUtils.getAsJwsAlgorithmList((JsonObject)o, (String)"token_endpoint_auth_signing_alg_values_supported"));
                conf.setUiLocalesSupported(JsonUtils.getAsStringList((JsonObject)o, (String)"ui_locales_supported"));
                conf.setUserinfoEncryptionAlgValuesSupported(JsonUtils.getAsJweAlgorithmList((JsonObject)o, (String)"userinfo_encryption_alg_values_supported"));
                conf.setUserinfoEncryptionEncValuesSupported(JsonUtils.getAsEncryptionMethodList((JsonObject)o, (String)"userinfo_encryption_enc_values_supported"));
                conf.setUserinfoSigningAlgValuesSupported(JsonUtils.getAsJwsAlgorithmList((JsonObject)o, (String)"userinfo_signing_alg_values_supported"));
                return conf;
            }
            throw new IllegalStateException("Couldn't parse server discovery results for " + url);
        }
    }
}

