/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.client.service.impl;

import com.google.common.base.Joiner;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.mitre.jwt.encryption.service.JwtEncryptionAndDecryptionService;
import org.mitre.jwt.signer.service.impl.JWKSetCacheService;
import org.mitre.oauth2.model.RegisteredClient;
import org.mitre.openid.connect.client.service.AuthRequestUrlBuilder;
import org.mitre.openid.connect.config.ServerConfiguration;
import org.springframework.security.authentication.AuthenticationServiceException;

public class EncryptedAuthRequestUrlBuilder
implements AuthRequestUrlBuilder {
    private JWKSetCacheService encrypterService;
    private JWEAlgorithm alg;
    private EncryptionMethod enc;

    @Override
    public String buildAuthRequestUrl(ServerConfiguration serverConfig, RegisteredClient clientConfig, String redirectUri, String nonce, String state, Map<String, String> options) {
        JWTClaimsSet claims = new JWTClaimsSet();
        claims.setClaim("response_type", (Object)"code");
        claims.setClaim("client_id", (Object)clientConfig.getClientId());
        claims.setClaim("scope", (Object)Joiner.on((String)" ").join((Iterable)clientConfig.getScope()));
        claims.setClaim("redirect_uri", (Object)redirectUri);
        claims.setClaim("nonce", (Object)nonce);
        claims.setClaim("state", (Object)state);
        for (Map.Entry<String, String> option : options.entrySet()) {
            claims.setClaim(option.getKey(), (Object)option.getValue());
        }
        EncryptedJWT jwt = new EncryptedJWT(new JWEHeader(this.alg, this.enc), (ReadOnlyJWTClaimsSet)claims);
        JwtEncryptionAndDecryptionService encryptor = this.encrypterService.getEncrypter(serverConfig.getJwksUri());
        encryptor.encryptJwt((JWEObject)jwt);
        try {
            URIBuilder uriBuilder = new URIBuilder(serverConfig.getAuthorizationEndpointUri());
            uriBuilder.addParameter("request", jwt.serialize());
            return uriBuilder.build().toString();
        }
        catch (URISyntaxException e) {
            throw new AuthenticationServiceException("Malformed Authorization Endpoint Uri", (Throwable)e);
        }
    }

    public JWKSetCacheService getEncrypterService() {
        return this.encrypterService;
    }

    public void setEncrypterService(JWKSetCacheService encrypterService) {
        this.encrypterService = encrypterService;
    }

    public JWEAlgorithm getAlg() {
        return this.alg;
    }

    public void setAlg(JWEAlgorithm alg) {
        this.alg = alg;
    }

    public EncryptionMethod getEnc() {
        return this.enc;
    }

    public void setEnc(EncryptionMethod enc) {
        this.enc = enc;
    }
}

