/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.client.service.impl;

import com.google.common.base.Joiner;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.mitre.oauth2.model.RegisteredClient;
import org.mitre.openid.connect.client.service.AuthRequestUrlBuilder;
import org.mitre.openid.connect.config.ServerConfiguration;
import org.springframework.security.authentication.AuthenticationServiceException;

public class PlainAuthRequestUrlBuilder
implements AuthRequestUrlBuilder {
    @Override
    public String buildAuthRequestUrl(ServerConfiguration serverConfig, RegisteredClient clientConfig, String redirectUri, String nonce, String state, Map<String, String> options) {
        try {
            URIBuilder uriBuilder = new URIBuilder(serverConfig.getAuthorizationEndpointUri());
            uriBuilder.addParameter("response_type", "code");
            uriBuilder.addParameter("client_id", clientConfig.getClientId());
            uriBuilder.addParameter("scope", Joiner.on((String)" ").join((Iterable)clientConfig.getScope()));
            uriBuilder.addParameter("redirect_uri", redirectUri);
            uriBuilder.addParameter("nonce", nonce);
            uriBuilder.addParameter("state", state);
            for (Map.Entry<String, String> option : options.entrySet()) {
                uriBuilder.addParameter(option.getKey(), option.getValue());
            }
            return uriBuilder.build().toString();
        }
        catch (URISyntaxException e) {
            throw new AuthenticationServiceException("Malformed Authorization Endpoint Uri", (Throwable)e);
        }
    }
}

